/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.synchronisation.SynchronisationFieldMapping;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabField;

public class FieldMapping
extends SynchronisationFieldMapping {
    private static final List<FieldMapping> BUILTIN_MAPPING = new ArrayList<FieldMapping>();
    private String gitLabField;

    static {
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.LABEL, GitLabField.TITLE.rawValue, true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.REFERENCE, GitLabField.REFERENCE.rawValue, true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.DESCRIPTION, GitLabField.DESCRIPTION.rawValue, true));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.CRITICALITY, GitLabField.LABELS.rawValue, false));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.CATEGORY, GitLabField.LABELS.rawValue, false));
        BUILTIN_MAPPING.add(new FieldMapping(BuiltinSquashField.STATUS, GitLabField.LABELS.rawValue, false));
    }

    public FieldMapping() {
    }

    public FieldMapping(BuiltinSquashField squashField, String gitLabField, boolean locked) {
        this(squashField.toString(), gitLabField, locked);
    }

    public FieldMapping(String squashField, String gitLabField, boolean locked) {
        super(squashField, locked);
        this.gitLabField = gitLabField;
    }

    public static Optional<String> getBuiltinMappingGitLabField(String id) {
        return BUILTIN_MAPPING.stream().filter(fieldMapping -> fieldMapping.getId().equals(id)).findFirst().map(FieldMapping::getGitLabField);
    }

    public static List<FieldMapping> getBuiltinMapping() {
        return BUILTIN_MAPPING;
    }

    public String getGitLabField() {
        return this.gitLabField;
    }

    public void setGitLabField(String gitLabField) {
        this.gitLabField = gitLabField;
    }

    public static List<FieldMapping> getLockedBuiltinMapping() {
        return BUILTIN_MAPPING.stream().filter(SynchronisationFieldMapping::isLocked).collect(Collectors.toList());
    }
}

