/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import jiracloud.com.atlassian.jira.rest.client.api.domain.IssueType;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;

public class IssueTypeJsonParser
implements JsonObjectParser<IssueType> {
    @Override
    public IssueType parse(JSONObject json) throws JSONException {
        URI selfUri = JsonParseUtil.getSelfUri(json);
        long id = json.getLong("id");
        String name = json.getString("name");
        boolean isSubtask = json.getBoolean("subtask");
        String iconUrl = JsonParseUtil.getOptionalString(json, "iconUrl");
        URI iconUri = iconUrl == null ? null : JsonParseUtil.parseURI(iconUrl);
        String description = JsonParseUtil.getOptionalString(json, "description");
        return new IssueType(selfUri, id, name, isSubtask, description, iconUri);
    }
}

