/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.auth.AuthScope;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.auth.UsernamePasswordCredentials;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.methods.CloseableHttpResponse;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.methods.HttpGet;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.client.BasicCredentialsProvider;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.client.CloseableHttpClient;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.client.HttpClients;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.EntityUtils;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.Redmine3RestClientOperation;

public class ProjectMembershipFetcher
extends Redmine3RestClientOperation<List<Membership>> {
    public static final String ID = "id";
    public static final String USER = "user";
    public static final String ROLES = "roles";
    public static final String NAME = "name";
    public static final String USER_LOGIN = "login";
    public static final String FIRSTNAME = "firstname";
    public static final String LASTNAME = "lastname";
    public static final String MAIL = "mail";
    private final String projectKey;
    private final String redmineUrl;
    private final String apiKey;
    private final String login;
    private final String password;

    public ProjectMembershipFetcher(RedmineManager manager, String redmineUrl, String apiKey, String login, String password, String projectKey) {
        super(manager);
        this.projectKey = projectKey;
        this.redmineUrl = redmineUrl;
        this.apiKey = apiKey;
        this.login = login;
        this.password = password;
    }

    /*
     * Loose catch block
     */
    @Override
    public List<Membership> doIt() throws RedmineException {
        Object auth2222;
        String url = this.redmineUrl + "/projects/" + this.projectKey + "/memberships.json?limit=1000";
        HttpGet request = new HttpGet(url);
        if (this.apiKey != null) {
            request.setHeader("X-Redmine-API-Key", this.apiKey);
        } else if (this.login != null && this.password != null) {
            auth2222 = this.login + ":" + this.password;
            String encoded = Base64.getEncoder().encodeToString(((String)auth2222).getBytes());
            request.setHeader("Authorization", "Basic " + encoded);
        }
        try {
            auth2222 = null;
            Object var4_6 = null;
            try {
                List<Membership> list;
                CloseableHttpResponse response;
                CloseableHttpClient client;
                block22: {
                    block21: {
                        client = this.buildHttpClient();
                        response = client.execute(request);
                        int status = response.getStatusLine().getStatusCode();
                        if (status != HttpStatus.OK.value()) {
                            throw new RedmineException("Failed to fetch memberships for project " + this.projectKey + ": HTTP " + status);
                        }
                        String json = EntityUtils.toString(response.getEntity());
                        list = this.parseMemberships(json);
                        if (response == null) break block21;
                        response.close();
                    }
                    if (client == null) break block22;
                    client.close();
                }
                return list;
                {
                    catch (Throwable auth2222) {
                        try {
                            if (response != null) {
                                response.close();
                            }
                            throw auth2222;
                        }
                        catch (Throwable throwable) {
                            if (auth2222 == null) {
                                auth2222 = throwable;
                            } else if (auth2222 != throwable) {
                                ((Throwable)auth2222).addSuppressed(throwable);
                            }
                            if (client != null) {
                                client.close();
                            }
                            throw auth2222;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (auth2222 == null) {
                    auth2222 = throwable;
                } else if (auth2222 != throwable) {
                    ((Throwable)auth2222).addSuppressed(throwable);
                }
                throw auth2222;
            }
        }
        catch (IOException e) {
            throw new RedmineException("Error fetching memberships for project " + this.projectKey, e);
        }
    }

    private CloseableHttpClient buildHttpClient() {
        if (this.login != null && this.password != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(this.login, this.password));
            return HttpClients.custom().setDefaultCredentialsProvider(credsProvider).build();
        }
        return HttpClients.createDefault();
    }

    private List<Membership> parseMemberships(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(json);
        JsonNode membershipsNode = root.path("memberships");
        ArrayList<Membership> memberships = new ArrayList<Membership>();
        for (JsonNode node : membershipsNode) {
            memberships.add(this.parseMembership(node));
        }
        return memberships;
    }

    private Membership parseMembership(JsonNode node) {
        Membership membership = new Membership();
        if (node.has(ID)) {
            membership.setId(node.get(ID).asInt());
        }
        if (node.has(USER)) {
            membership.setUser(this.parseUser(node.get(USER)));
        }
        if (node.has(ROLES)) {
            membership.setRoles(this.parseRoles(node.get(ROLES)));
        }
        return membership;
    }

    private User parseUser(JsonNode userNode) {
        User user = new User();
        user.setId(userNode.get(ID).asInt());
        user.setFullName(userNode.get(NAME).asText());
        if (userNode.has(USER_LOGIN)) {
            user.setLogin(userNode.get(USER_LOGIN).asText());
        }
        if (userNode.has(FIRSTNAME)) {
            user.setFirstName(userNode.get(FIRSTNAME).asText());
        }
        if (userNode.has(LASTNAME)) {
            user.setLastName(userNode.get(LASTNAME).asText());
        }
        if (userNode.has(MAIL)) {
            user.setMail(userNode.get(MAIL).asText());
        }
        return user;
    }

    private List<Role> parseRoles(JsonNode rolesNode) {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (JsonNode rNode : rolesNode) {
            Role role = new Role();
            role.setId(rNode.get(ID).asInt());
            role.setName(rNode.get(NAME).asText());
            roles.add(role);
        }
        return roles;
    }
}

