/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.message;

import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpRequest;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpVersion;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.ProtocolVersion;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.RequestLine;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.message.AbstractHttpMessage;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.message.BasicRequestLine;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;

public class BasicHttpRequest
extends AbstractHttpMessage
implements HttpRequest {
    private final String method;
    private final String uri;
    private RequestLine requestline;

    public BasicHttpRequest(String method, String uri) {
        this.method = Args.notNull(method, "Method name");
        this.uri = Args.notNull(uri, "Request URI");
        this.requestline = null;
    }

    public BasicHttpRequest(String method, String uri, ProtocolVersion ver) {
        this(new BasicRequestLine(method, uri, ver));
    }

    public BasicHttpRequest(RequestLine requestline) {
        this.requestline = Args.notNull(requestline, "Request line");
        this.method = requestline.getMethod();
        this.uri = requestline.getUri();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    @Override
    public RequestLine getRequestLine() {
        if (this.requestline == null) {
            this.requestline = new BasicRequestLine(this.method, this.uri, HttpVersion.HTTP_1_1);
        }
        return this.requestline;
    }

    public String toString() {
        return this.method + ' ' + this.uri + ' ' + this.headergroup;
    }
}

