/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.exception;

import com.taskadapter.redmineapi.NotAuthorizedException;
import com.taskadapter.redmineapi.RedmineAuthenticationException;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.tm.plugin.bugtracker.redmine3.exception.Redmine3IssueNotFound;
import org.squashtest.tm.plugin.bugtracker.redmine3.exception.Redmine3ProjectNotFound;

@Component(value="redmine3ExceptionHandler")
public class ExceptionHandler {
    @Autowired
    @Qualifier(value="redmine3ConnectorMessageSource")
    private MessageSource messageSource;

    private Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public BugTrackerRemoteException genericError(Exception ex) {
        String translation = this.messageSource.getMessage("exception.squash.unknownexception", null, this.getLocale());
        return new BugTrackerRemoteException(translation + ex.getMessage(), ex.getCause());
    }

    public BugTrackerRemoteException genericError(Exception ex, String specificMessage) {
        String translation = this.messageSource.getMessage("exception.squash.unknownexception", null, this.getLocale());
        return new BugTrackerRemoteException(translation + specificMessage, ex.getCause());
    }

    public ProjectNotFoundException projectNotFound(Redmine3ProjectNotFound exception) {
        Object[] objectArray;
        String projectIdentifier = exception.getProjectIdentifier();
        if (projectIdentifier != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = projectIdentifier;
        } else {
            objectArray = null;
        }
        Object[] args = objectArray;
        String translation = this.messageSource.getMessage("exception.squash.notfound.project", args, this.getLocale());
        return new ProjectNotFoundException(translation, exception.getCause());
    }

    public BugTrackerRemoteException numberConversionFailure(NumberFormatException exception) {
        Object[] args = this.toMsgArgs(exception);
        String translation = this.messageSource.getMessage("exception.squash.number.conversion", args, this.getLocale());
        return new BugTrackerRemoteException(translation, exception.getCause());
    }

    public BugTrackerRemoteException notAuthorizedException(NotAuthorizedException exception) {
        Object[] args = this.toMsgArgs(exception);
        String translation = this.messageSource.getMessage("exception.squash.operationdenied", args, this.getLocale());
        return new BugTrackerRemoteException(translation, exception.getCause());
    }

    public BugTrackerNoCredentialsException redmineAuthenticationException(RedmineAuthenticationException exception) {
        Object[] args = this.toMsgArgs(exception);
        String translation = this.messageSource.getMessage("exception.squash.accessdenied", args, this.getLocale());
        return new BugTrackerNoCredentialsException(translation, exception.getCause());
    }

    public BugTrackerRemoteException issueNotFound(Redmine3IssueNotFound exception) {
        Object[] args = this.toMsgArgs(exception);
        String translation = this.messageSource.getMessage("exception.squash.notfound.issue", args, this.getLocale());
        return new BugTrackerRemoteException(translation, exception.getCause());
    }

    public BugTrackerRemoteException userNotAssignable(Exception exception) {
        Object[] args = this.toMsgArgs(exception);
        String translation = this.messageSource.getMessage("exception.squash.notassignable.user", args, this.getLocale());
        return new BugTrackerRemoteException(translation, exception.getCause());
    }

    private Object[] toMsgArgs(Exception exception) {
        Object[] objectArray;
        String expression = exception.getMessage();
        if (expression != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = expression;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private static interface SquashMessageKeys {
        public static final String UNKNOWN_EXCEPTION = "exception.squash.unknownexception";
        public static final String WRONG_CREDENTIALS = "exception.squash.accessdenied";
        public static final String OPERATION_DENIED = "exception.squash.operationdenied";
        public static final String ISSUE_NOT_FOUND = "exception.squash.notfound.issue";
        public static final String PROJECT_NOT_FOUND = "exception.squash.notfound.project";
        public static final String NUMBER_CONVERSION = "exception.squash.number.conversion";
        public static final String USER_NOT_ASSIGNABLE = "exception.squash.notassignable.user";
    }
}

