/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.converter;

import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Version;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.EntityType;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.FieldValueCreator;
import org.squashtest.tm.plugin.bugtracker.redmine3.domain.Redmine3FieldInfo;
import org.squashtest.tm.plugin.bugtracker.redmine3.domain.Redmine3FieldSchema;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedProject;

@Component(value="redmine3EntityMapping")
public class EntityMapping {
    @Inject
    private FieldValueCreator fieldValueCreator;
    @Inject
    @Named(value="redmine3ConnectorMessageSource")
    private MessageSource messageSource;

    private Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public boolean shouldDismissField(Redmine3FieldInfo fieldInfo) {
        Iterator<Object> iter;
        boolean dismiss = false;
        Iterable<Object> values = fieldInfo.getAllowedValues();
        if (values != null && !(iter = values.iterator()).hasNext()) {
            dismiss = true;
        }
        return dismiss;
    }

    public List<FieldValue> createFieldValues(Redmine3FieldInfo fieldInfo, Project redmineProject) {
        if (fieldInfo.getAllowedValues() == null) {
            return Collections.emptyList();
        }
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        Redmine3FieldSchema schema = fieldInfo.getSchema();
        String itemType = schema.getItemType();
        for (Object aValue : fieldInfo.getAllowedValues()) {
            FieldValue newValue = this.fieldValueCreator.createFieldValue(itemType, aValue);
            values.add(newValue);
        }
        if (itemType.equals(EntityType.CUSTOM_VERSION.name())) {
            ExtendedProject extendedRedmineProject = (ExtendedProject)redmineProject;
            for (Version version : extendedRedmineProject.getVersions()) {
                FieldValue newValue = this.fieldValueCreator.createFieldValue(itemType, version.getName());
                values.add(newValue);
            }
        }
        if (!fieldInfo.isRequired() && this.needsEmptyValue(schema)) {
            this.addEmptyValue(values);
        }
        return values;
    }

    private boolean needsEmptyValue(Redmine3FieldSchema schema) {
        boolean result = true;
        EntityType type = EntityType.fromString(schema.getType());
        switch (type) {
            case CATEGORY: {
                break;
            }
            case VERSION: {
                break;
            }
            case CUSTOM_LIST: {
                break;
            }
            case CUSTOM_USER: {
                break;
            }
            case CUSTOM_VERSION: {
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private void addEmptyValue(List<FieldValue> values) {
        FieldValue fieldValue = new FieldValue();
        fieldValue.setId("-1");
        fieldValue.setScalar(this.messageSource.getMessage(EntityType.NONE.getText(), null, this.getLocale()));
        fieldValue.setTypename("string");
        values.add(fieldValue);
    }
}

