/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.service.GlobalCacheServiceImpl;

@Service(value="org.squashtest.tm.plugin.bugtracker.bugzilla.BugzillaFieldsCache")
@ConditionalOnProperty(name={"plugin.bugtracker.bugzilla.cache.enable"}, havingValue="true")
public class BugzillaGlobalFieldsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(BugzillaGlobalFieldsCache.class);
    private static final Map<String, List<Map<String, Object>>> bugTrackerUrlToFieldsMap = new HashMap<String, List<Map<String, Object>>>();
    @Inject
    private Environment environment;
    @Inject
    @Named(value="squashtest.tm.service.ThreadPoolTaskScheduler")
    private TaskScheduler taskScheduler;

    public static Map<String, List<Map<String, Object>>> getBugTrackerUrlToFieldsMap() {
        return bugTrackerUrlToFieldsMap;
    }

    @PostConstruct
    private void loadFieldsCacheAtStart() {
        List<String> bugTrackerUrlsToCacheAtStart = this.getBugTrackerUrlsToCacheAtStart();
        this.taskScheduler.schedule(this.createLoadFieldsCacheAtStartTask(bugTrackerUrlsToCacheAtStart), new Date());
    }

    private List<String> getBugTrackerUrlsToCacheAtStart() {
        List bugtrackerUrlsToCacheAtStart = (List)this.environment.getProperty("plugin.bugtracker.bugzilla.cache-at-start.bugtracker-urls", List.class);
        if (Objects.isNull(bugtrackerUrlsToCacheAtStart) || bugtrackerUrlsToCacheAtStart.isEmpty()) {
            LOGGER.info("Found no property 'plugin.bugtracker.bugzilla.cache-at-start.bugtracker-urls'. No bug tracker will be cached at start");
            return new ArrayList<String>();
        }
        return bugtrackerUrlsToCacheAtStart.stream().filter(url -> {
            try {
                new URL((String)url);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.info("Bugzilla url " + url + " defined in property 'plugin.bugtracker.bugzilla.cache-at-start.bugtracker-ids' is malformed. It will be ignored.");
                return false;
            }
        }).collect(Collectors.toList());
    }

    private Runnable createLoadFieldsCacheAtStartTask(List<String> bugTrackerUrlsToCacheAtStart) {
        return () -> {
            for (String bugTrackerUrl : bugTrackerUrlsToCacheAtStart) {
                try {
                    GlobalCacheServiceImpl globalFieldsCacheService = new GlobalCacheServiceImpl(bugTrackerUrl);
                    globalFieldsCacheService.refreshOrEmptyCache();
                }
                catch (BugzillaXmlrpcException bugzillaXmlrpcException) {
                    LOGGER.info("Could not load cache for bugzilla bug tracker at url " + bugTrackerUrl);
                }
            }
        };
    }

    @PostConstruct
    private void scheduleRefreshFieldsCache() {
        String cronExpressionProperty = this.getCronExpressionProperty();
        if (Objects.nonNull(cronExpressionProperty)) {
            CronTrigger cronTrigger = new CronTrigger(cronExpressionProperty);
            this.taskScheduler.schedule(this.createRefreshFieldsCacheTask(), (Trigger)cronTrigger);
            LOGGER.info("Created scheduled task to refresh bugzilla fields cache");
        }
    }

    private String getCronExpressionProperty() {
        String cronExpressionProperty = this.environment.getProperty("plugin.bugtracker.bugzilla.cache-refresh.cron-expression");
        if (StringUtils.isNotBlank((CharSequence)cronExpressionProperty)) {
            if (!this.isValidCronExpression(cronExpressionProperty)) {
                LOGGER.info("Found invalid property 'plugin.bugtracker.bugzilla.cache-refresh.cron-expression'. No cache refresh will be scheduled");
                return null;
            }
            LOGGER.info("Found property 'plugin.bugtracker.bugzilla.cache-refresh.cron-expression' to schedule bugzilla cache refresh");
            return cronExpressionProperty;
        }
        LOGGER.info("Found no property 'plugin.bugtracker.bugzilla.cache-refresh.cron-expression'. No cache refresh will be scheduled");
        return null;
    }

    private boolean isValidCronExpression(String cronExpression) {
        try {
            CronExpression.parse((String)cronExpression);
            return true;
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Invalid cron expression: {}", (Object)cronExpression, (Object)e);
            return false;
        }
    }

    private Runnable createRefreshFieldsCacheTask() {
        return () -> {
            LOGGER.info("Running scheduled task to refresh bugzilla fields");
            for (String bugTrackerUrl : bugTrackerUrlToFieldsMap.keySet()) {
                LOGGER.trace("#createRefreshFieldsCacheTask() - Retrieving fields from bugzilla for bug tracker url " + bugTrackerUrl);
                GlobalCacheServiceImpl globalFieldsCacheService = new GlobalCacheServiceImpl(bugTrackerUrl);
                globalFieldsCacheService.refreshOrEmptyCache();
                LOGGER.debug("#createRefreshFieldsCacheTask() - Retrieved fields from bugzilla for bug tracker url " + bugTrackerUrl);
            }
        };
    }
}

