/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestPlanItemDto;
import org.squashtest.tm.plugin.rest.jackson.model.TpiParentType;
import org.squashtest.tm.plugin.rest.repository.RestExecutionRepository;
import org.squashtest.tm.plugin.rest.repository.RestTestPlanItemRepository;
import org.squashtest.tm.plugin.rest.service.RestTestPlanItemService;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.testplanitem.SprintTestPlanItemManager;

@Service
@Transactional
public class RestTestPlanItemServiceImpl
implements RestTestPlanItemService {
    public static final String PARENT_TYPE = "parentType";
    public static final String PARENT_ID = "parentId";
    public static final String TEST_PLAN_ITEM_ID = "testPlanItemId";
    @Inject
    private RestTestPlanItemRepository tpiRepository;
    @Inject
    private RestExecutionRepository executionRepository;
    @Inject
    private CustomIterationModificationService nativeService;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    private SprintTestPlanItemManager sprintTestPlanItemManager;
    @Inject
    private DSLContext dslContext;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private SprintReqVersionDao sprintReqVersionDao;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private UserDao userDao;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private ProjectFinder projectFinder;

    @Override
    @PostAuthorize(value="hasPermission(returnObject , 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public TestPlanItem getOne(long id) {
        return (TestPlanItem)this.tpiRepository.getReferenceById(id);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#tpiId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem', 'READ')")
    @Transactional(readOnly=true)
    public Page<Execution> findExecutions(long tpiId, Pageable pageable) {
        return this.executionRepository.findAllByTestPlanItem_Id(tpiId, pageable);
    }

    @Override
    public Execution createExecution(long tpiId) {
        return this.nativeService.addManualExecution(tpiId);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestPlanItem> findItemsByCoveredRemoteRequirement(Pageable pageable, String remoteKey, String serverName) {
        List readableProjectIds = this.projectFinder.findReadableProjectIdsOnCampaignLibrary();
        return this.tpiRepository.findItemsByCoveredRemoteRequirement(remoteKey, serverName, readableProjectIds, pageable);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem', 'WRITE')")
    public TestPlanItem modifyTestPlanItem(TestPlanItemDto tpiDto, Long testPlanItemId) {
        User assignedTo;
        TestPlanItem tpi = (TestPlanItem)this.tpiRepository.getReferenceById(testPlanItemId);
        Dataset ds = tpiDto.getReferencedDataset() != null ? (Dataset)this.datasetDao.getReferenceById((Object)tpiDto.getReferencedDataset().getId()) : null;
        User user = assignedTo = tpiDto.getUser() != null ? this.userDao.findUserByLogin(tpiDto.getUser()) : null;
        if (tpiDto.isHasSetDataset()) {
            tpi.setReferencedDataset(ds);
        }
        if (tpiDto.isAssignedTo()) {
            tpi.setAssignee(assignedTo);
        }
        return tpi;
    }

    @Override
    public void deleteTestPlanItems(List<Long> testPlanIds) {
        Map<TpiParentType, Map<Long, List<Long>>> tpiInfos = this.findAllIdsByParentIdByParentType(testPlanIds);
        Map testPlanItemsByIteration = tpiInfos.getOrDefault((Object)TpiParentType.ITERATION, new HashMap());
        Map testPlanItemsBySprintReqVersion = tpiInfos.getOrDefault((Object)TpiParentType.SPRINT_REQ_VERSION, new HashMap());
        testPlanItemsByIteration.forEach((k, v) -> {
            boolean bl = this.iterationTestPlanManagerService.removeTestPlansFromIteration(v, k.longValue());
        });
        testPlanItemsBySprintReqVersion.forEach((k, v) -> this.sprintTestPlanItemManager.deleteSprintReqVersionTestPlanItems(k, v));
    }

    @Override
    public Map<TpiParentType, Map<Long, List<Long>>> findAllIdsByParentIdByParentType(List<Long> testPlanIds) {
        Result records = this.dslContext.select((SelectField)DSL.inline((Object)((Object)TpiParentType.ITERATION)).as(PARENT_TYPE), (SelectField)Tables.ITERATION.ITERATION_ID.as(PARENT_ID), (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as(TEST_PLAN_ITEM_ID)).from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(testPlanIds)).unionAll((Select)this.dslContext.select((SelectField)DSL.inline((Object)((Object)TpiParentType.SPRINT_REQ_VERSION)).as(PARENT_TYPE), (SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.as(PARENT_ID), (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as(TEST_PLAN_ITEM_ID)).from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(testPlanIds))).fetch();
        return records.stream().collect(Collectors.groupingBy(record -> (TpiParentType)((Object)((Object)record.getValue(PARENT_TYPE, TpiParentType.class))), Collectors.groupingBy(record -> (Long)record.getValue(PARENT_ID, Long.class), Collectors.mapping(record -> (Long)record.getValue(TEST_PLAN_ITEM_ID, Long.class), Collectors.toList()))));
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'WRITE')")
    public TestPlanItem addIterationTestPlanItem(TestPlanItemDto testPlanItemDto, long iterationId) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        return this.addTestPlanItem(testPlanItemDto, (TestPlanOwner)iteration);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'WRITE')")
    public TestPlanItem addSprintReqVersionTestPlanItem(TestPlanItemDto testPlanItemDto, long sprintReqVersionId) {
        SprintReqVersion sprintReqVersion = this.sprintReqVersionDao.findById((Object)sprintReqVersionId).orElse(null);
        if (Objects.isNull(sprintReqVersion)) {
            throw new IllegalArgumentException("SprintReqVersion with id " + sprintReqVersionId + " does not exist.");
        }
        return this.addTestPlanItem(testPlanItemDto, (TestPlanOwner)sprintReqVersion);
    }

    private TestPlanItem addTestPlanItem(TestPlanItemDto testPlanItemDto, TestPlanOwner entity) {
        TestCaseDto referencedTcDTo = testPlanItemDto.getTestCaseDto();
        DatasetDto referencedDatasetDto = testPlanItemDto.getReferencedDataset();
        TestCase testCase = (TestCase)this.testCaseDao.findById(referencedTcDTo.getId().longValue());
        String assignedTo = testPlanItemDto.getUser();
        User aTo = assignedTo != null ? this.userDao.findUserByLogin(assignedTo) : null;
        Dataset ds = referencedDatasetDto != null ? (Dataset)this.datasetDao.getReferenceById((Object)referencedDatasetDto.getId()) : null;
        TestPlanOwner testPlanOwner = entity;
        Objects.requireNonNull(testPlanOwner);
        TestPlanOwner testPlanOwner2 = testPlanOwner;
        int n = 0;
        TestPlan testPlan = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Iteration.class, SprintReqVersion.class}, (Object)testPlanOwner2, n)) {
            case 0 -> {
                Iteration iteration = (Iteration)testPlanOwner2;
                yield iteration.getTestPlan();
            }
            case 1 -> {
                SprintReqVersion sprintReqVersion = (SprintReqVersion)testPlanOwner2;
                yield sprintReqVersion.getTestPlan();
            }
            default -> throw new IllegalArgumentException("The entity " + String.valueOf(entity) + " must be either an Iteration or a SprintReqVersion");
        };
        return testPlan.createAndAddTestPlanItem(testCase, ds, aTo);
    }
}

