/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.service.RestReportingService;
import org.squashtest.tm.service.internal.customreport.CRLNDeletionHandler;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class RestReportingImpl
implements RestReportingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestReportingImpl.class);
    @Inject
    private DSLContext dslContext;
    @Inject
    private CRLNDeletionHandler deletionHandler;
    @Inject
    protected PermissionEvaluationService permissionService;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<Long> fetchAndDeleteReportingDeletableIds(List<Long> ids, String entityType) throws AccessDeniedException {
        List deletableIds = this.dslContext.select((SelectField)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID).from((TableLike)Tables.CUSTOM_REPORT_LIBRARY_NODE).where(Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID.in(ids)).and(Tables.CUSTOM_REPORT_LIBRARY_NODE.ENTITY_TYPE.eq((Object)entityType)).fetchInto(Long.class);
        ArrayList<Long> authorizedIds = new ArrayList<Long>();
        for (Long id : deletableIds) {
            try {
                this.permissionService.checkPermission(Collections.singletonList(id), Permissions.DELETE.name(), CustomReportLibraryNode.class.getName());
                authorizedIds.add(id);
            }
            catch (AccessDeniedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        this.deletionHandler.deleteNodes(authorizedIds);
        return authorizedIds;
    }

    @Override
    public CustomReportLibraryNode getReportingEntity(Long id, String entityType) {
        this.permissionService.checkPermission(Collections.singletonList(id), Permissions.READ.name(), CustomReportLibraryNode.class.getName());
        return this.getCustomReportLibraryNode(id, entityType);
    }

    public CustomReportLibraryNode getCustomReportLibraryNode(Long id, String entityType) {
        String request = "    SELECT c\n    FROM CustomReportLibraryNode c\n    WHERE c.id = :id AND c.entityType = :entityType\n";
        try {
            return (CustomReportLibraryNode)this.entityManager.createQuery(request, CustomReportLibraryNode.class).setParameter("id", (Object)id).setParameter("entityType", (Object)CustomReportTreeDefinition.valueOf((String)entityType)).getSingleResult();
        }
        catch (NoResultException noResultException) {
            throw new EntityNotFoundException("Unable to find a custom library node of type " + entityType.toLowerCase() + " with id " + String.valueOf(id));
        }
    }
}

