/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import java.io.IOException;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.campaign.Sprint;

@Component
public class SynchronizedSprintPropertyWriter
extends VirtualBeanPropertyWriter {
    public SynchronizedSprintPropertyWriter() {
    }

    public SynchronizedSprintPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        super(propDef, contextAnnotations, declaredType);
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws IOException {
        Sprint holder = (Sprint)bean;
        boolean isSynchronized = holder.isSynchronized();
        gen.writeFieldName("is_synchronized");
        gen.writeString(isSynchronized ? "true" : "false");
        if (isSynchronized) {
            gen.writeFieldName("remote_sprint_id");
            gen.writeString(holder.getRemoteSprintId().toString());
            gen.writeFieldName("remote_name");
            gen.writeString(holder.getRemoteName());
            gen.writeFieldName("remote_state");
            gen.writeString(holder.getRemoteState());
        }
        return null;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new SynchronizedSprintPropertyWriter(propDef, declaringClass.getAnnotations(), type);
    }
}

