/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import java.io.IOException;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.requirement.RequirementVersion;

@Component
public class SprintReqVersionPropertyWriter
extends VirtualBeanPropertyWriter {
    public SprintReqVersionPropertyWriter() {
    }

    private SprintReqVersionPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        super(propDef, contextAnnotations, declaredType);
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws IOException {
        SprintReqVersion holder = (SprintReqVersion)bean;
        boolean holderHasInfo = Objects.nonNull(holder.getName());
        RequirementVersion reqVersion = holder.getRequirementVersion();
        gen.writeStringField("name", holderHasInfo ? holder.getName() : reqVersion.getName());
        gen.writeStringField("reference", holderHasInfo ? holder.getReference() : reqVersion.getReference());
        gen.writeStringField("description", holderHasInfo ? holder.getDescription() : reqVersion.getDescription());
        gen.writeStringField("status", holderHasInfo ? holder.getStatus() : reqVersion.getStatus().name());
        gen.writeStringField("criticality", holderHasInfo ? holder.getCriticality() : reqVersion.getCriticality().name());
        gen.writeStringField("category", holderHasInfo ? holder.getCategory() : reqVersion.getCategory().getCode());
        return null;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new SprintReqVersionPropertyWriter(propDef, declaringClass.getAnnotations(), type);
    }
}

