/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.promptset.Prompt;
import org.squashtest.tm.plugin.rest.admin.jackson.model.PromptDto;
import org.squashtest.tm.plugin.rest.admin.service.RestPromptService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.PromptPatcher;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.internal.repository.PromptDao;
import org.squashtest.tm.service.promptset.PromptManagerService;

@Service
@Transactional
public class RestPromptServiceImpl
implements RestPromptService {
    private final PromptDao promptDao;
    private final PromptManagerService promptManagerService;
    private final PromptPatcher promptPatcher;

    public RestPromptServiceImpl(PromptDao promptDao, PromptManagerService promptManagerService, PromptPatcher promptPatcher) {
        this.promptDao = promptDao;
        this.promptManagerService = promptManagerService;
        this.promptPatcher = promptPatcher;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public Prompt findPromptById(Long promptId) {
        return (Prompt)this.promptDao.getReferenceById((Object)promptId);
    }

    @Override
    @IsUltimateLicenseAvailable
    public void deletePrompts(List<Long> promptIds) {
        this.promptManagerService.deletePrompts(promptIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public Prompt addPrompt(PromptDto promptDto) {
        return this.promptManagerService.addPrompt(promptDto.getPromptSetId().longValue(), promptDto.getPrompt());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public Prompt updatePrompt(Long promptId, PromptDto promptDto) {
        Prompt prompt = (Prompt)this.promptDao.getReferenceById((Object)promptId);
        this.promptPatcher.patch(prompt, promptDto);
        return prompt;
    }
}

