/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RequirementLinkTypeMappingDto;
import org.squashtest.tm.plugin.rest.admin.validators.RestJiraSyncApiValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;

@Component
public class RequirementLinkTypeMappingValidator
extends RestJiraSyncApiValidator {
    private static final String PATCH_REQUIREMENT_LINK_TYPE_MAPPING_VALIDATION = "path-requirement-link-type-mapping-validation";

    public boolean supports(Class<?> clazz) {
        return RequirementLinkTypeMappingDto.class.equals(clazz);
    }

    public void validatePatchRequirementLinkTypeMapping(Long projectId, Long requirementLinkTypeId, RequirementLinkTypeMappingDto requirementLinkTypeMappingDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)requirementLinkTypeMappingDto, PATCH_REQUIREMENT_LINK_TYPE_MAPPING_VALIDATION);
        this.checkEntityExist((Errors)validationBean, Project.class, projectId);
        this.checkEntityExist((Errors)validationBean, RequirementVersionLinkType.class, requirementLinkTypeId);
        if (Objects.nonNull(requirementLinkTypeMappingDto.getId())) {
            validationBean.rejectValue("id", "invalid id", "requirement link type id cannot be modified");
        }
        if (Objects.nonNull(requirementLinkTypeMappingDto.getSquashField())) {
            validationBean.rejectValue("squashField", "invalid SquashTM field", "SquashTM field cannot be modified");
        }
        if (Objects.isNull(requirementLinkTypeMappingDto.getJiraField())) {
            validationBean.rejectValue("jiraField", "invalid jira field", "jira field canoot be null");
        }
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)requirementLinkTypeMappingDto, errors, (String)PATCH_REQUIREMENT_LINK_TYPE_MAPPING_VALIDATION);
    }
}

