/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModel;
import org.squashtest.tm.plugin.rest.admin.controller.RestRemoteSynchronisationResourceAssembler;
import org.squashtest.tm.plugin.rest.admin.exception.JsonExceptionJiraSync;
import org.squashtest.tm.plugin.rest.admin.jackson.model.JiraRemoteSynchronisationModelDto;
import org.squashtest.tm.plugin.rest.admin.service.RestRemoteSynchronisationService;
import org.squashtest.tm.plugin.rest.admin.validators.RemoteSynchronisationValidator;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController
@UseDefaultRestApiConfiguration
@ConditionalOnClass(name={"org.squashtest.tm.plugin.rest.admin.SquashAdminApiConditionalInterface"})
public class RestRemoteSynchronisationController {
    private static final String SYNCHRONISATIONS = "synchronisations";
    @Inject
    private RemoteSynchronisationValidator synchronisationValidator;
    @Inject
    private RestRemoteSynchronisationService remoteSynchronisationService;
    @Inject
    private RestRemoteSynchronisationResourceAssembler resourceAssembler;
    @Inject
    private PagedResourcesAssembler<JiraRemoteSynchronisationModel> pagedResourcesAssembler;

    @GetMapping(value={"/projects/{id}/synchronisations"})
    public ResponseEntity<PagedModel<EntityModel<JiraRemoteSynchronisationModel>>> getAllSynchronisationByProjectId(@PathVariable(value="id") Long projectId, Pageable pageable) {
        Page<JiraRemoteSynchronisationModel> synchronisationPage = this.remoteSynchronisationService.findAllSynchronisationByProjectId(projectId, pageable);
        SingleRelPagedResources res = new SingleRelPagedResources(this.pagedResourcesAssembler.toModel(synchronisationPage, (RepresentationModelAssembler)this.resourceAssembler), SYNCHRONISATIONS);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/synchronisations/{id}"})
    public ResponseEntity getSynchronisationById(@PathVariable(value="id") Long synchronisationId) {
        try {
            JiraRemoteSynchronisationModel synchro = this.remoteSynchronisationService.getSynchronisationById(synchronisationId);
            EntityModel<JiraRemoteSynchronisationModel> res = this.resourceAssembler.toModel(synchro);
            return ResponseEntity.ok(res);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)new JsonExceptionJiraSync("EntityNotFoundException", "No entity JiraRemoteSynchronisation found with id :" + String.valueOf(synchronisationId)));
        }
    }

    @PostMapping(value={"/projects/{id}/synchronisations"})
    public ResponseEntity<EntityModel<JiraRemoteSynchronisationModel>> createSynchronisationOnProject(@PathVariable(value="id") long projectId, @RequestBody JiraRemoteSynchronisationModelDto jiraRemoteSync) throws BindException {
        this.synchronisationValidator.validatePostRemoteSynchronisation(jiraRemoteSync, projectId);
        jiraRemoteSync.coerceSelectTypeValue();
        JiraRemoteSynchronisationModel result = this.remoteSynchronisationService.addJiraRemoteSynchronisation(projectId, jiraRemoteSync);
        EntityModel<JiraRemoteSynchronisationModel> res = this.resourceAssembler.toModel(result);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/synchronisations/{id}"})
    public ResponseEntity<EntityModel<JiraRemoteSynchronisationModel>> updateRequirementSynchronisation(@PathVariable(value="id") long jiraSynchroId, @RequestBody JiraRemoteSynchronisationModelDto synchronisationDto) throws BindException {
        this.synchronisationValidator.validatePatchRequirementRemoteSynchronisation(synchronisationDto, jiraSynchroId);
        JiraRemoteSynchronisationModel synchro = this.remoteSynchronisationService.updateRequirementSynchronisation(jiraSynchroId, synchronisationDto);
        EntityModel<JiraRemoteSynchronisationModel> res = this.resourceAssembler.toModel(synchro);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/synchronisations/{id}/sprints"})
    public ResponseEntity<EntityModel<JiraRemoteSynchronisationModel>> createSprintSynchronisation(@PathVariable(value="id") long jiraSynchroId, @RequestBody JiraRemoteSynchronisationModelDto synchronisationDto) throws BindException {
        this.synchronisationValidator.validatePostSprintSynchronisation(synchronisationDto, jiraSynchroId);
        JiraRemoteSynchronisationModel synchro = this.remoteSynchronisationService.createSprintSynchronisation(jiraSynchroId, synchronisationDto);
        EntityModel<JiraRemoteSynchronisationModel> res = this.resourceAssembler.toModel(synchro);
        return ResponseEntity.ok(res);
    }

    @PatchMapping(value={"/synchronisations/{id}/sprints"})
    public ResponseEntity<EntityModel<JiraRemoteSynchronisationModel>> updateSprintSynchronisation(@PathVariable(value="id") long jiraSynchroId, @RequestBody JiraRemoteSynchronisationModelDto synchronisationDto) throws BindException {
        this.synchronisationValidator.validatePatchSprintRemoteSynchronisation(synchronisationDto, jiraSynchroId);
        JiraRemoteSynchronisationModel synchro = this.remoteSynchronisationService.updateSprintSynchronisation(jiraSynchroId, synchronisationDto);
        EntityModel<JiraRemoteSynchronisationModel> res = this.resourceAssembler.toModel(synchro);
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/synchronisations/{id}/synchronize"})
    public ResponseEntity launchSynchronisationOnProject(@PathVariable(value="id") long jiraSynchroId) {
        try {
            JiraRemoteSynchronisationModel synchro = this.remoteSynchronisationService.commandFullSynchronisation(jiraSynchroId);
            EntityModel<JiraRemoteSynchronisationModel> res = this.resourceAssembler.toModel(synchro);
            return ResponseEntity.ok(res);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)new JsonExceptionJiraSync("UnsupportedOperationException", String.format("Unable to force the synchronization %s because it's deactivated", jiraSynchroId)));
        }
    }

    @DeleteMapping(value={"/synchronisations/{id}"})
    public ResponseEntity<String> deleteSynchronisationOnProject(@PathVariable(value="id") long jiraSynchroId) {
        this.remoteSynchronisationService.deleteSynchronisation(jiraSynchroId);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/synchronisations/{id}/sprints"})
    public ResponseEntity<String> deleteSprintSynchronisation(@PathVariable(value="id") long jiraSynchroId) {
        this.remoteSynchronisationService.deleteSprintSynchronisation(jiraSynchroId);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"/synchronisations/{id}/activate"})
    public ResponseEntity<EntityModel<JiraRemoteSynchronisationModel>> deactivateSynchronisationNameOnProject(@PathVariable(value="id") long syncId, @RequestParam(value="enabled") String synchronisationEnable) {
        JiraRemoteSynchronisationModel synchro = this.remoteSynchronisationService.changeSync(syncId, synchronisationEnable);
        EntityModel<JiraRemoteSynchronisationModel> res = this.resourceAssembler.toModel(synchro);
        return ResponseEntity.ok(res);
    }
}

