/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.repository;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtenderType;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.RequirementSyncExtender;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.FieldLink;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.RequirementExtenderFolderDto;
import org.squashtest.tm.plugin.jirasync.domain.RequirementReference;
import org.squashtest.tm.plugin.jirasync.domain.SquashIssueLink;
import org.squashtest.tm.plugin.jirasync.helpers.SquashRequirementVersionLinkTypeHelper;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.backend.helper.JsonHelper;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.scanner.ScannerException;

@Repository(value="squash.tm.plugin.jirasync.dao")
public class PluginRequirementDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginRequirementDao.class);
    private static final String ID_AND_KEY_BY_KEY = "select req.id, ext.remoteReqId from Requirement req inner join req.syncExtender ext where ext.remoteReqId in (:keys) and ext.remoteSynchronisation.id = :remoteSyncId";
    private static final String RMV_CREAT_EVT = "delete RequirementCreation c where c.requirementVersion.id in (:vIds)";
    private static final String FIND_SYNC_FOR_PROJECT = "select sync from RemoteSynchronisation sync inner join sync.project p where p.id = :projectId and sync.kind = :pluginId";
    private static final String REFERENCE = "REFERENCE";
    private static final String LABEL = "LABEL";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CRITICALITY = "CRITICALITY";
    private static final List<String> UNDELETABLE_FIELDS = Arrays.asList("REFERENCE", "LABEL", "DESCRIPTION", "CRITICALITY");
    private static final List<String> UNEDITABLE_FIELDS = Arrays.asList("REFERENCE", "LABEL", "DESCRIPTION");
    @PersistenceContext
    private EntityManager em;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private ObjectMapper jsonifier;
    @Inject
    private DSLContext dslContext;
    @Inject
    private SquashRequirementVersionLinkTypeHelper linkTypeHelper;

    public void flush() {
        this.getSession().flush();
    }

    public Map<Long, String> findActiveRemoteSyncIdsAndLastSyncStatusByPluginId() {
        return this.remoteSynchronisationDao.findActiveRemoteSyncIdsAndLastSyncStatusByPluginId("squash.tm.plugin.jirasync");
    }

    public List<Long> findAllNotJiraLinkedRVIds(long versionId, List<String> linkedJiraKeys) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID).from((TableLike)Tables.REQUIREMENT_VERSION_LINK).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).where(Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID.eq((Object)versionId)).and(Tables.REQUIREMENT_VERSION.REFERENCE.notIn(linkedJiraKeys)).fetchInto(Long.class);
    }

    public void storeConfigurationForProject(Long projectId, Configuration configuration) {
        HashMap<String, String> storageConf = new HashMap<String, String>(5);
        List<FieldMapping> fieldMappings = configuration.getFieldMappings();
        String strMappings = JsonHelper.serialize(fieldMappings);
        storageConf.put("attributeMappings", strMappings);
        List<FieldLink> fieldLinks = configuration.getFieldLinks();
        String strLinks = JsonHelper.serialize(fieldLinks);
        storageConf.put("linkMappings", strLinks);
        String valueMapping = configuration.getYamlFieldvalueMapping();
        storageConf.put("valuesMapping", valueMapping);
        storageConf.put("jiraTestingStatusField", configuration.getStatusField());
        storageConf.put("jiraRedactionProgressField", configuration.getRedactionProgressField());
        storageConf.put("jiraVerificationProgressField", configuration.getVerificationProgressField());
        storageConf.put("jiraValidationProgressField", configuration.getValidationProgressField());
        storageConf.put("jiraRedactionRatioField", configuration.getRedactionRatioField());
        storageConf.put("jiraVerificationRatioField", configuration.getVerificationRatioField());
        storageConf.put("jiraValidationRatioField", configuration.getValidationRatioField());
        this.projectManager.setPluginConfiguration(projectId.longValue(), WorkspaceType.REQUIREMENT_WORKSPACE, "squash.tm.plugin.jirasync", storageConf);
    }

    public Configuration getConfigurationForProject(Long projectId) {
        Configuration configuration;
        block11: {
            Map conf;
            block10: {
                block9: {
                    conf = this.projectManager.getPluginConfiguration(projectId.longValue(), WorkspaceType.REQUIREMENT_WORKSPACE, "squash.tm.plugin.jirasync");
                    configuration = new Configuration();
                    configuration.setStatusField((String)conf.get("jiraTestingStatusField"));
                    configuration.setRedactionProgressField((String)conf.get("jiraRedactionProgressField"));
                    configuration.setVerificationProgressField((String)conf.get("jiraVerificationProgressField"));
                    configuration.setValidationProgressField((String)conf.get("jiraValidationProgressField"));
                    configuration.setRedactionRatioField((String)conf.get("jiraRedactionRatioField"));
                    configuration.setVerificationRatioField((String)conf.get("jiraVerificationRatioField"));
                    configuration.setValidationRatioField((String)conf.get("jiraValidationRatioField"));
                    String strMappings = (String)conf.get("attributeMappings");
                    if (strMappings == null) {
                        strMappings = "[]";
                    }
                    try {
                        configuration = this.restoreMappings(configuration, strMappings);
                    }
                    catch (IOException e) {
                        if (!LOGGER.isErrorEnabled()) break block9;
                        LOGGER.error("could not parse field mapping {} for project", (Object)strMappings, (Object)e);
                    }
                }
                String strValMappings = (String)conf.get("valuesMapping");
                if (strValMappings == null) {
                    strValMappings = "";
                }
                try {
                    configuration = this.restoreValueMappings(configuration, strValMappings);
                }
                catch (ScannerException ex) {
                    if (!LOGGER.isErrorEnabled()) break block10;
                    LOGGER.error("could not parse field value mapping " + strValMappings + " for project ", (Throwable)ex);
                }
            }
            String strLinkMappings = (String)conf.get("linkMappings");
            if (strLinkMappings == null) {
                strLinkMappings = "[]";
            }
            try {
                configuration = this.restoreFieldLinksMapping(configuration, strLinkMappings);
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block11;
                LOGGER.error("could not parse field link " + strLinkMappings + " for project ", (Throwable)e);
            }
        }
        return configuration;
    }

    private void updateLinksMapping(List<FieldLink> links, Map<Long, String> allLinkTypes) {
        for (FieldLink currentLink : links) {
            String correspondingLinkType = allLinkTypes.get(currentLink.getSquashLinkTypeId());
            if (correspondingLinkType == null || currentLink.getSquashField().equals(correspondingLinkType)) continue;
            currentLink.setSquashField(correspondingLinkType);
        }
    }

    private Configuration restoreFieldLinksMapping(Configuration configuration, String strLinkMappings) throws IOException {
        List links = (List)this.jsonifier.readValue(strLinkMappings, (TypeReference)new TypeReference<List<FieldLink>>(){});
        Map<Long, String> allLinkTypes = this.linkTypeHelper.createLinkTypeMap();
        this.updateLinksMapping(links, allLinkTypes);
        Map configured = links.stream().collect(Collectors.toMap(FieldLink::getSquashLinkTypeId, Function.identity()));
        List<FieldLink> finalLinks = allLinkTypes.entrySet().stream().map(entry -> configured.getOrDefault(entry.getKey(), FieldLink.byId((String)entry.getValue(), (Long)entry.getKey()))).toList();
        configuration.setFieldLinks(finalLinks);
        return configuration;
    }

    public List<JiraRemoteSynchronisation> findJiraRemoteSyncForProject(Long projectId, String pluginId) {
        Query query = this.em.createQuery(FIND_SYNC_FOR_PROJECT);
        query.setParameter("projectId", (Object)projectId);
        query.setParameter("pluginId", (Object)pluginId);
        List remoteSynchronisations = query.getResultList();
        return remoteSynchronisations.stream().map(JiraRemoteSynchronisation::new).toList();
    }

    private Configuration restoreMappings(Configuration conf, String strMappings) throws IOException {
        List mappings = (List)this.jsonifier.readValue(strMappings, (TypeReference)new TypeReference<List<FieldMapping>>(){});
        List<FieldMapping> basicMapping = FieldMapping.getBuiltinMapping();
        for (FieldMapping m : basicMapping) {
            boolean exists = mappings.contains((Object)m);
            if (exists) continue;
            mappings.add(m);
        }
        for (FieldMapping mapping : mappings) {
            String squashField;
            mapping.setDeletable(!UNDELETABLE_FIELDS.contains(mapping.getSquashField()));
            mapping.setLocked(UNEDITABLE_FIELDS.contains(mapping.getSquashField()));
            switch (squashField = mapping.getSquashField()) {
                case "REFERENCE": {
                    mapping.setJiraField("issuekey");
                    break;
                }
                case "LABEL": {
                    mapping.setJiraField("summary");
                    break;
                }
                case "DESCRIPTION": {
                    mapping.setJiraField("description");
                    break;
                }
            }
        }
        conf.setFieldMappings(mappings);
        return conf;
    }

    private Configuration restoreValueMappings(Configuration conf, String stryaml) throws ScannerException {
        Yaml yaml = new Yaml();
        yaml.load(stryaml);
        conf.setYamlFieldvalueMapping(stryaml);
        return conf;
    }

    public Map<String, RequirementReference> findKnownRequirements(Collection<String> keys, RemoteSynchronisation remoteSynchronisation) {
        Session session = this.getSession();
        HashMap<String, RequirementReference> result = new HashMap<String, RequirementReference>();
        if (keys.isEmpty()) {
            return result;
        }
        List idsList = this.em.createQuery(ID_AND_KEY_BY_KEY).setParameter("keys", keys).setParameter("remoteSyncId", (Object)remoteSynchronisation.getId()).getResultList();
        Map<Long, String> idsMap = this.tupleToMap(idsList);
        if (idsMap.keySet().isEmpty()) {
            return result;
        }
        List pathList = session.getNamedQuery("RequirementPathEdge.findPathsByIds").setParameterList("nodeIds", idsMap.keySet()).list();
        Map<Long, String> pathById = this.tupleToMap(pathList);
        for (Map.Entry<Long, String> entry : pathById.entrySet()) {
            Long id = entry.getKey();
            String path = entry.getValue();
            path = path.replace("/", "\\/").replace("\u001f", "/");
            String key = idsMap.get(id);
            result.put(key, new RequirementReference(id, path));
        }
        return result;
    }

    public Map<Long, Set<Long>> versionAndMilestoneIdsByRemoteKeys(Collection<String> remoteKeys, Long projectId) {
        if (remoteKeys.isEmpty()) {
            return new HashMap<Long, Set<Long>>();
        }
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createTupleQuery();
        Root syncRoot = query.from(RequirementSyncExtender.class);
        Join reqJoin = syncRoot.join("requirement");
        Join versJoin = reqJoin.join("resource");
        Join projJoin = reqJoin.join("project");
        Join mileJoin = versJoin.join("milestones");
        query.multiselect(new Selection[]{versJoin.get("id").alias("versionId"), mileJoin.get("id").alias("milestoneId")}).where((Expression)cb.and((Expression)cb.equal((Expression)projJoin.get("id"), (Object)projectId), (Expression)syncRoot.get("remoteReqId").in(remoteKeys))).groupBy(new Expression[]{versJoin.get("id"), mileJoin.get("id")});
        List results = this.em.createQuery(query).getResultList();
        return results.stream().collect(Collectors.groupingBy(tuple -> (Long)tuple.get("versionId"), Collectors.mapping(tuple -> (Long)tuple.get("milestoneId"), Collectors.toSet())));
    }

    public Map<String, Date> findKnownIssueKeyAndDate(JiraRemoteSynchronisation remoteSynchronisation) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisation.getId())).fetch().stream().collect(Collectors.toMap(r -> (String)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID), r -> (Date)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED)));
    }

    public Map<String, Date> findSprintRequirementKnownIssueKeyAndDate(JiraRemoteSynchronisation remoteSynchronisation, long sprintId) {
        return this.dslContext.select((SelectField)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED).from((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID)).where(Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisation.getId())).and(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Object)sprintId)).fetch().stream().collect(Collectors.toMap(r -> (String)r.get((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID), r -> (Date)r.get((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED)));
    }

    public void deleteLinkedRequirementVersion(Long requirementVersionId, List<String> linkedJiraKeys, Long synchronizationId) {
        List<Long> notJiraLinkedRVIds = this.findAllNotJiraLinkedRVIds(requirementVersionId, linkedJiraKeys);
        SelectConditionStep obsoleteReqVersionIds = this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.REQUIREMENT_VERSION).where(Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.eq((Object)"OBSOLETE"));
        SelectConditionStep sameSynchronizationRVIds = this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)synchronizationId));
        this.dslContext.deleteFrom((Table)Tables.REQUIREMENT_VERSION_LINK).where(Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID.notIn((Select)obsoleteReqVersionIds).and(Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID.notIn((Select)obsoleteReqVersionIds)).and(Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID.eq((Object)requirementVersionId).and(Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID.in(notJiraLinkedRVIds).or(Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID.notIn((Select)sameSynchronizationRVIds))).or(Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID.eq((Object)requirementVersionId).and(Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID.in(notJiraLinkedRVIds).or(Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID.notIn((Select)sameSynchronizationRVIds)))))).execute();
    }

    public void removeAllCreationEvent(Collection<Long> versionIds) {
        if (versionIds.isEmpty()) {
            return;
        }
        Query q = this.em.createQuery(RMV_CREAT_EVT);
        q.setParameter("vIds", versionIds);
        q.executeUpdate();
    }

    public void persist(RequirementAuditEvent event) {
        this.getSession().persist((Object)event);
    }

    private Map<Long, String> tupleToMap(List<Object[]> tuples) {
        return tuples.stream().collect(Collectors.toMap(tuple -> (Long)tuple[0], tuple -> (String)tuple[1]));
    }

    private Session getSession() {
        return (Session)this.em.unwrap(Session.class);
    }

    public Long findTargetFolderId(Long remoteSynchronisationId) {
        this.em.flush();
        return (Long)this.dslContext.select((SelectField)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID).from((TableLike)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER).where(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).and(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.TYPE.eq((Object)RequirementFolderSyncExtenderType.TARGET.name())).fetchOne((Field)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID);
    }

    public boolean isRequirementInSynchronizedFolder(long remoteSynchronisationId, String issueKey, long requirementFolderId) {
        this.em.flush();
        Integer count = (Integer)this.dslContext.selectCount().from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)issueKey)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)requirementFolderId)).fetchOneInto(Integer.class);
        return count > 0;
    }

    public Map<String, Long> findReqIdAndJiraKeyInSynchronizedFolder(long remoteSynchronisationId, List<String> issueKeys, long synchronizedFolderId) {
        this.em.flush();
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(issueKeys)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)synchronizedFolderId)).fetchMap((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID);
    }

    public Map<Long, List<String>> findSubtaskToMove(Long remoteSyncId, Set<String> issueKey) {
        this.em.flush();
        RequirementSyncExtender subtask = Tables.REQUIREMENT_SYNC_EXTENDER.as("subtask");
        RequirementSyncExtender parent = Tables.REQUIREMENT_SYNC_EXTENDER.as("parent");
        return this.dslContext.select((SelectField)parent.REQUIREMENT_ID, (SelectField)subtask.REMOTE_REQ_ID).from((TableLike)subtask).innerJoin((TableLike)parent).on(subtask.REMOTE_PARENT_ID.eq((Field)parent.REMOTE_REQ_ID)).and(subtask.REMOTE_SYNCHRONISATION_ID.eq((Field)parent.REMOTE_SYNCHRONISATION_ID)).leftAntiJoin((TableLike)Tables.RLN_RELATIONSHIP).on(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)parent.REQUIREMENT_ID)).and(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)subtask.REQUIREMENT_ID)).where(parent.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSyncId)).and(subtask.REMOTE_REQ_ID.in(issueKey)).fetch().stream().collect(Collectors.groupingBy(r -> (Long)r.get((Field)requirementSyncExtender.REQUIREMENT_ID), Collectors.mapping(r -> (String)r.get((Field)requirementSyncExtender.REMOTE_REQ_ID), Collectors.toList())));
    }

    public Set<String> findIssueKeyInSprintSubFolder(Long remoteSynchronisationId, Long squashFolderSprintId) {
        this.em.flush();
        List keys = this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).and(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)squashFolderSprintId)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).fetch((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID);
        return new HashSet<String>(keys);
    }

    public Set<Long> findReqIdEligibleToBeMoved(long remoteSynchronisationId, Collection<String> issuesThatShouldMoveToSprintFolder, Long targetFolderId) {
        Map<String, Long> jiraKeyByReqId = this.findReqIdAndJiraKeyEligibleToBeMoved(remoteSynchronisationId, issuesThatShouldMoveToSprintFolder, targetFolderId);
        return new HashSet<Long>(jiraKeyByReqId.values());
    }

    public Map<String, Long> findReqIdAndJiraKeyEligibleToBeMoved(long remoteSynchronisationId, Collection<String> issuesThatShouldMoveToSprintFolder, Long targetFolderId) {
        this.em.flush();
        RequirementSyncExtender subtask = Tables.REQUIREMENT_SYNC_EXTENDER.as("subtask");
        RequirementSyncExtender parent = Tables.REQUIREMENT_SYNC_EXTENDER.as("parent");
        return this.dslContext.select((SelectField)subtask.REMOTE_REQ_ID, (SelectField)subtask.REQUIREMENT_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)subtask).on(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)subtask.REQUIREMENT_ID)).and(subtask.REMOTE_REQ_ID.in(issuesThatShouldMoveToSprintFolder)).and(subtask.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).leftAntiJoin((TableLike)parent).on(parent.REMOTE_REQ_ID.eq((Field)subtask.REMOTE_PARENT_ID)).and(parent.REMOTE_SYNCHRONISATION_ID.eq((Field)subtask.REMOTE_SYNCHRONISATION_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)targetFolderId)).fetchMap((Field)subtask.REMOTE_REQ_ID, (Field)subtask.REQUIREMENT_ID);
    }

    public List<String> getHighLevelIssueKeys(Set<String> jiraKeys, Long remoteSynchronizationId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(jiraKeys).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronizationId))).fetchInto(String.class);
    }

    public List<String> findKnownEpicKeys(Long remoteSynchronizationId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronizationId)).fetchInto(String.class);
    }

    public Long getHighLevelRequirementIdByJiraEpicKey(String epicKey, Long remoteSynchronizationId) {
        Long highLevelRequirementInSynchro = (Long)this.dslContext.select((SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)epicKey).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronizationId))).fetchOneInto(Long.class);
        if (Objects.nonNull(highLevelRequirementInSynchro)) {
            return highLevelRequirementInSynchro;
        }
        return this.searchAnExistingHighLevelIdByEpicKey(epicKey);
    }

    private Long searchAnExistingHighLevelIdByEpicKey(String epicKey) {
        return (Long)this.dslContext.select((SelectField)DSL.max((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)epicKey)).fetchOneInto(Long.class);
    }

    public List<SquashIssueLink> searchLinkedIssuesInSquashSynchros(String epicKey, Long remoteSynchronizationId, List<String> issueKeys) {
        Long serverId = (Long)this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.SERVER_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)epicKey).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronizationId))).fetchOneInto(Long.class);
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.as("JIRA_KEY"), (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID, (SelectField)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID, (SelectField)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.SERVER_ID.eq((Object)serverId).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(issueKeys))).fetchInto(SquashIssueLink.class);
    }

    public void appendHighLevelRequirementIfExist(String issueKey, Map<Long, List<Long>> requirementIdsToLinkByHighLevelMap, String epicKey, JiraRemoteSynchronisation remoteSynchronization, Set<String> linkedKeys, Long requirementId) {
        Long serverId = remoteSynchronization.getServer().getId();
        Long highLevelRequirementId = (Long)this.dslContext.select((SelectField)DSL.max((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)epicKey)).and(Tables.REQUIREMENT_SYNC_EXTENDER.SERVER_ID.eq((Object)serverId)).fetchOneInto(Long.class);
        if (Objects.nonNull(highLevelRequirementId)) {
            requirementIdsToLinkByHighLevelMap.computeIfAbsent(highLevelRequirementId, k -> new ArrayList()).add(requirementId);
            linkedKeys.add(issueKey);
        }
    }

    public Map<String, List<Long>> getRequirementIdsByIssueKeyLinkedToHLR(List<String> issueKeys, JiraRemoteSynchronisation remoteSynchronisation) {
        Long serverId = remoteSynchronisation.getServer().getId();
        Long synchronizationId = remoteSynchronisation.getId();
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(issueKeys).and(Tables.REQUIREMENT_SYNC_EXTENDER.SERVER_ID.eq((Object)serverId)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)synchronizationId)).and(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.isNotNull())).fetchGroups((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID);
    }

    public Map<String, String> getEpicKeyByIssueKeyInSquash(Map<String, String> jiraEpicKeyByIssueKey, JiraRemoteSynchronisation remoteSynchronisation) {
        Set<String> issueKeys = jiraEpicKeyByIssueKey.keySet();
        RequirementSyncExtender highLeveRequirementSyncExtender = Tables.REQUIREMENT_SYNC_EXTENDER.as("highLevelRequirementSyncExtender");
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)highLeveRequirementSyncExtender.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).innerJoin((TableLike)highLeveRequirementSyncExtender).on(highLeveRequirementSyncExtender.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(issueKeys).and(Tables.REQUIREMENT_SYNC_EXTENDER.SERVER_ID.eq((Object)remoteSynchronisation.getServer().getId())).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisation.getId()))).fetchMap((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (Field)highLeveRequirementSyncExtender.REMOTE_REQ_ID);
    }

    public String getEpicKeyByHighLevelId(Long associatedHighLevelRequirementId) {
        return (String)this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Object)associatedHighLevelRequirementId)).fetchOneInto(String.class);
    }

    public boolean isEpicKeyPresentInSynchro(String jiraKey, Long remoteSynchronizationId) {
        return Objects.nonNull(this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)jiraKey).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronizationId))).fetchOneInto(Long.class));
    }

    public boolean isRequirementLinkedHighLevel(String issueKey, long synchronisationId) {
        return (Boolean)this.dslContext.select((SelectField)DSL.when((Condition)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.isNotNull(), (Object)true).otherwise((Object)false)).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)issueKey).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)synchronisationId))).fetchOneInto(Boolean.class);
    }

    public String getHighLevelKeyByRequirementId(Long requirementId) {
        return (String)this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).where(Tables.REQUIREMENT.RLN_ID.eq((Object)requirementId)).fetchOneInto(String.class);
    }

    public Long getRequirementIdByJiraKeyAndServerId(String issueKey, long synchronisationId) {
        return (Long)this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)issueKey).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)synchronisationId))).fetchOneInto(Long.class);
    }

    public Map<String, Map<Long, String>> getIssueKeyByRequirementIdFromEpicKey(List<String> epicKeys, long synchronisationId) {
        RequirementSyncExtender highLevelRequirementSyncExtender = Tables.REQUIREMENT_SYNC_EXTENDER.as("highLevelRequirementSyncExtender");
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)highLevelRequirementSyncExtender.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)highLevelRequirementSyncExtender).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.eq((Field)highLevelRequirementSyncExtender.REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(highLevelRequirementSyncExtender.REMOTE_REQ_ID.in(epicKeys).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)synchronisationId))).fetch().stream().collect(Collectors.groupingBy(r -> (String)r.get((Field)requirementSyncExtender.REMOTE_REQ_ID), Collectors.toMap(r -> (Long)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID), r -> (String)r.get((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID))));
    }

    public List<RequirementExtenderFolderDto> getReqFolderExtenderDtoBySprints(Long synchronisationId, Set<String> sprintIds) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.RF_SYNC_EXTENDER_ID, (SelectField)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID, (SelectField)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REMOTE_FOLDER_ID, (SelectField)Tables.RESOURCE.NAME.as("name")).from((TableLike)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER).innerJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_FOLDER.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).where(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)synchronisationId).and(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REMOTE_FOLDER_ID.in(sprintIds)).and(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.TYPE.eq((Object)RequirementFolderSyncExtenderType.SPRINT.name()))).fetchInto(RequirementExtenderFolderDto.class);
    }
}

