/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol;

import java.io.IOException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.Header;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpEntity;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpRequest;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpResponse;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpResponseInterceptor;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpVersion;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.ProtocolVersion;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.HttpContext;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.HttpCoreContext;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequest request;
        Args.notNull(response, "HTTP response");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        int status = response.getStatusLine().getStatusCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response.setHeader("Connection", "Close");
            return;
        }
        Header explicit = response.getFirstHeader("Connection");
        if (explicit != null && "Close".equalsIgnoreCase(explicit.getValue())) {
            return;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
            if (entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals(HttpVersion.HTTP_1_0))) {
                response.setHeader("Connection", "Close");
                return;
            }
        }
        if ((request = corecontext.getRequest()) != null) {
            Header header = request.getFirstHeader("Connection");
            if (header != null) {
                response.setHeader("Connection", header.getValue());
            } else if (request.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                response.setHeader("Connection", "Close");
            }
        }
    }
}

