/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol;

import java.io.IOException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpEntityEnclosingRequest;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpRequest;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpRequestInterceptor;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.HttpContext;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.HttpDateGenerator;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

