/*
 * Decompiled with CFR 0.152.
 */
package jirarest.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import jirarest.org.apache.http.HttpConnection;
import jirarest.org.apache.http.HttpException;
import jirarest.org.apache.http.HttpHost;
import jirarest.org.apache.http.HttpInetConnection;
import jirarest.org.apache.http.HttpRequest;
import jirarest.org.apache.http.HttpRequestInterceptor;
import jirarest.org.apache.http.HttpVersion;
import jirarest.org.apache.http.ProtocolException;
import jirarest.org.apache.http.ProtocolVersion;
import jirarest.org.apache.http.annotation.Contract;
import jirarest.org.apache.http.annotation.ThreadingBehavior;
import jirarest.org.apache.http.protocol.HttpContext;
import jirarest.org.apache.http.protocol.HttpCoreContext;
import jirarest.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

