/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.httpclient.apache.httpcomponents;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jirarest.com.atlassian.httpclient.apache.httpcomponents.EntityByteArrayInputStream;
import jirarest.com.atlassian.httpclient.api.Request;
import jirarest.io.atlassian.fugue.Effect;
import jirarest.org.apache.http.HttpEntity;
import jirarest.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import jirarest.org.apache.http.client.methods.HttpRequestBase;
import jirarest.org.apache.http.entity.AbstractHttpEntity;
import jirarest.org.apache.http.entity.ByteArrayEntity;
import jirarest.org.apache.http.entity.InputStreamEntity;

public class RequestEntityEffect
implements Effect<HttpRequestBase> {
    private final Request request;

    public RequestEntityEffect(Request request) {
        this.request = request;
    }

    @Override
    public void apply(HttpRequestBase httpRequestBase) {
        if (!(httpRequestBase instanceof HttpEntityEnclosingRequestBase)) {
            throw new UnsupportedOperationException("HTTP method " + (Object)((Object)this.request.getMethod()) + " does not support sending an entity");
        }
        ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity(this.getHttpEntity(this.request));
    }

    private HttpEntity getHttpEntity(Request request) {
        AbstractHttpEntity entity = null;
        if (request.hasEntity()) {
            InputStream entityStream = request.getEntityStream();
            if (entityStream instanceof ByteArrayInputStream) {
                byte[] bytes;
                if (entityStream instanceof EntityByteArrayInputStream) {
                    bytes = ((EntityByteArrayInputStream)entityStream).getBytes();
                } else {
                    try {
                        bytes = ByteStreams.toByteArray((InputStream)entityStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                entity = new ByteArrayEntity(bytes);
            } else {
                long contentLength = request.getContentLength().getOrElse(-1L);
                entity = new InputStreamEntity(entityStream, contentLength);
            }
        }
        return entity;
    }
}

