/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.importer;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.TimeEntry;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.event.SyncRequirementCreation;
import org.squashtest.tm.domain.event.SyncRequirementUpdate;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.redminereq.client.RedmineClient;
import org.squashtest.tm.plugin.redminereq.domain.Configuration;
import org.squashtest.tm.plugin.redminereq.domain.FieldMapping;
import org.squashtest.tm.plugin.redminereq.domain.FilterBinding;
import org.squashtest.tm.plugin.redminereq.helpers.SquashHelper;
import org.squashtest.tm.plugin.redminereq.importer.ImporterState;
import org.squashtest.tm.plugin.redminereq.service.ConfigurationService;
import org.squashtest.tm.plugin.redminereq.service.EffectiveConfiguration;
import org.squashtest.tm.plugin.redminereq.service.PluginDao;
import org.squashtest.tm.plugin.redminereq.service.ValueMappings;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.container.RequirementVersionInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.deletion.RequirementDeletionHandlerImpl;
import org.squashtest.tm.service.internal.importer.ExcelRowReaderUtils;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component(value="squash.tm.plugin.redminereq.importer")
@Scope(value="prototype")
public class RedmineRequirementImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedmineRequirementImporter.class);
    private static final Integer REQ_VERSION_NUMBER = 1;
    private static final String CATEGORY = "category";
    private static final String STATUS = "status";
    @Inject
    private PluginDao pluginDao;
    @Inject
    private FacilityImpl importer;
    @Inject
    private RequirementSyncExtenderDao reqsyncDao;
    @Inject
    private SquashHelper squashHelper;
    @Inject
    private InternationalizationHelper lang;
    @Inject
    private RequirementDeletionHandlerImpl deleter;
    @Inject
    private RequirementVersionManagerService managService;
    @Inject
    private ActiveMilestoneHolder milestoneHolder;
    @Inject
    private RequirementVersionManagerService versionService;
    @Inject
    private ConfigurationService confService;
    @Inject
    private ProjectDao projectDao;
    private BugTracker server;
    private EffectiveConfiguration conf;
    private Project project;
    private ImporterState state;
    private Locale locale;
    private Map<String, String> knownRequirements;
    private Map<Long, Set<Long>> versionAndMilestoneIds;
    private Map<String, RequirementSyncExtender> extenderByKey;

    public void setServer(BugTracker server) {
        this.server = server;
    }

    public void setProject(Project p) {
        this.project = p;
    }

    public void setState(ImporterState state) {
        this.state = state;
    }

    public void setConfiguration(EffectiveConfiguration conf) {
        this.conf = conf;
    }

    public void configure() {
        this.locale = LocaleContextHolder.getLocale();
        this.squashHelper.initForProject(this.project, this.conf.getValueMappings());
    }

    public Map<Issue, RequirementVersionInstruction> importRedmineTickets(Iterable<Issue> redmineIssues, FilterBinding filter, Long projectId, RedmineClient client, List<ExtendedCustomField> allRedmineCufs, List<CustomFieldBinding> cufsForProjectReq) {
        Set<String> keys = this.collectRedmineIssueKeys(redmineIssues);
        this.cacheKnownRequirementsData(keys);
        HashMap<RequirementVersionInstruction, Issue> instructionIssueMap = new HashMap<RequirementVersionInstruction, Issue>();
        for (Issue issue : redmineIssues) {
            if (this.state.hasProcessedAlready(issue.getId().toString())) continue;
            RequirementVersionInstruction instruction = this.buildInstruction(issue, filter, projectId, client, allRedmineCufs, cufsForProjectReq);
            instructionIssueMap.put(instruction, issue);
        }
        Map<Issue, RequirementVersionInstruction> squashReqs = this.processInstructions(filter, instructionIssueMap);
        this.postProcess(squashReqs.values());
        this.state.addProcessedReqs(keys);
        return squashReqs;
    }

    private Map<Issue, RequirementVersionInstruction> processInstructions(FilterBinding filter, Map<RequirementVersionInstruction, Issue> instructionIssueMap) {
        HashMap<Issue, RequirementVersionInstruction> squashReqs = new HashMap<Issue, RequirementVersionInstruction>();
        RequirementVersionInstructionContainer container = new RequirementVersionInstructionContainer(new ArrayList<RequirementVersionInstruction>(instructionIssueMap.keySet()));
        container.executeInstructions((Facility)this.importer, this.project);
        for (Map.Entry<RequirementVersionInstruction, Issue> entry : instructionIssueMap.entrySet()) {
            RequirementVersionInstruction instruction = entry.getKey();
            Issue issue = entry.getValue();
            LogTrain logs = instruction.getLogTrain();
            if (logs.hasCriticalErrors()) {
                this.logCriticalErrors(logs);
                this.state.setHadFailureOnFieldImport(true);
                continue;
            }
            if (instruction.getMode() == ImportMode.CREATE) {
                this.processExtenderCreation(filter, logs, instruction, issue);
            } else {
                this.processExtenderUpdate(filter, logs, issue);
            }
            squashReqs.put(issue, instruction);
        }
        return squashReqs;
    }

    private void processExtenderUpdate(FilterBinding filter, LogTrain logs, Issue issue) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("import went with no critical errors " + logs.getEntries().size());
        }
        RequirementSyncExtender extender = this.extenderByKey.get(issue.getId().toString());
        this.updateExtender(extender, issue, filter);
    }

    private void processExtenderCreation(FilterBinding filter, LogTrain logs, RequirementVersionInstruction instruction, Issue issue) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("import went with no critical errors " + logs.getEntries().size());
        }
        Requirement req = instruction.getRequirementVersion().getRequirement();
        RequirementSyncExtender extender = new RequirementSyncExtender();
        this.updateExtender(extender, issue, filter);
        if (req.getSyncExtender() != null) {
            throw new IllegalArgumentException("this was supposed to be a new requirement !");
        }
        req.setSyncExtender(extender);
        extender.setRequirement(req);
        this.reqsyncDao.save((Object)extender);
    }

    public void setUntouchables(FilterBinding binding) {
        List<String> untouchableKeys = this.pluginDao.findKeysForBinding(binding);
        this.state.addUntouchableReqs(untouchableKeys);
    }

    public void deleteLeftoverRequirements(Long projectId) {
        Set<String> nonDeletableKeys = this.state.getNonDeletableReqs();
        List<Long> deletableIds = this.pluginDao.retrieveAllDeletableInProject(this.project.getId(), nonDeletableKeys);
        Configuration config = this.pluginDao.getConfigurationForProject(projectId);
        if (config.getAllowToDeleteReq().booleanValue()) {
            this.deleter.deleteNodes(deletableIds);
        } else {
            for (Long reqId : deletableIds) {
                Long reqVersionId = this.versionService.findReqVersionIdByRequirementAndVersionNumber(reqId.longValue(), REQ_VERSION_NUMBER);
                this.versionService.findById(reqVersionId.longValue()).setStatus(RequirementStatus.OBSOLETE);
            }
        }
    }

    public ImporterState getState() {
        return this.state;
    }

    private RequirementVersionInstruction buildInstruction(Issue issue, FilterBinding filter, Long projectId, RedmineClient client, List<ExtendedCustomField> allRedmineCufs, List<CustomFieldBinding> cufsForProjectReq) {
        RequirementVersionInstruction instruction = this.createInstruction(issue, filter, projectId, client, allRedmineCufs, cufsForProjectReq);
        if (this.knows(issue.getId().toString())) {
            instruction.setMode(ImportMode.UPDATE);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("attempting to update requirement version '" + ((RequirementVersionTarget)instruction.getTarget()).getPath() + "' with new data");
            }
        } else {
            instruction.setMode(ImportMode.CREATE);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("attempting to create requirement version '" + ((RequirementVersionTarget)instruction.getTarget()).getPath() + "'");
            }
        }
        return instruction;
    }

    private RequirementVersionInstruction createInstruction(Issue issue, FilterBinding filter, Long projectId, RedmineClient client, List<ExtendedCustomField> allRedmineCufs, List<CustomFieldBinding> cufsForProjectReq) {
        RequirementVersion version = new RequirementVersion();
        version.setVersionNumber(1);
        new Requirement(version);
        HashMap<String, String> customFields = new HashMap<String, String>();
        this.populate(version, customFields, issue, projectId, client, filter, allRedmineCufs, cufsForProjectReq);
        String issueKey = issue.getId().toString();
        StringBuilder path = new StringBuilder();
        if (this.knows(issueKey)) {
            path.append(this.knownRequirements.get(issueKey));
            if (!issue.getSubject().equals(version.getName())) {
                version.setName(issue.getSubject());
            }
        } else {
            String escpname = this.project.getName().replace("/", "\\/");
            String escvname = issue.getSubject();
            version.setName(escvname);
            escvname = version.getName().replace("/", "\\/");
            String filterPath = filter.getPath();
            if (filterPath.length() == 0) {
                path.append("/").append(escpname).append("/").append(escvname);
            } else {
                path.append("/").append(escpname).append("/").append(filterPath).append("/").append(escvname);
            }
        }
        return this.wrapAsInstruction(version, customFields, path.toString(), issue.getId().toString());
    }

    private void populate(RequirementVersion version, Map<String, String> cufs, Issue issue, Long projectId, RedmineClient client, FilterBinding filter, List<ExtendedCustomField> allRedmineCufs, List<CustomFieldBinding> cufsForProjectReq) {
        Configuration configuration = this.confService.getConfigurationForProject(projectId);
        List<FieldMapping> mappings = configuration.getFieldMappings();
        mappings.remove((Object)FieldMapping.byId("LABEL"));
        version.setDescription(ExcelRowReaderUtils.escapeHTMLInsideTags((String)issue.getDescription()));
        mappings.remove((Object)FieldMapping.byId("DESCRIPTION"));
        version.setReference(issue.getId().toString());
        mappings.remove((Object)FieldMapping.byId("REFERENCE"));
        ValueMappings valueMappings = client.getValueMappings(configuration);
        if (valueMappings.size() != 0 && valueMappings.get(CATEGORY) != null) {
            String trackerName = issue.getTracker().getName();
            this.synchronizeCategories(projectId, trackerName, version, valueMappings);
            mappings.remove((Object)FieldMapping.byId(CATEGORY.toUpperCase()));
        }
        if (valueMappings.size() != 0 && valueMappings.get("criticality") != null) {
            String priorityText = issue.getPriorityText();
            this.synchronizeCriticalities(valueMappings, priorityText, version);
            mappings.remove((Object)FieldMapping.byId("CRITICALITY"));
        }
        List redmineCufs = issue.getCustomFields();
        for (FieldMapping f : mappings) {
            int i;
            Object redmineValue;
            block25: {
                redmineValue = "";
                if (mappings.isEmpty() || STATUS.equals(f.getRedmineField())) continue;
                boolean noRedmineCuf = "done ratio".equals(f.getRedmineField()) || CATEGORY.equals(f.getRedmineField()) || "target version".equals(f.getRedmineField()) || "spent hours".equals(f.getRedmineField());
                i = 0;
                while (i < cufsForProjectReq.size() && !f.getSquashField().equals(cufsForProjectReq.get(i).getCustomField().getCode())) {
                    ++i;
                }
                if (i >= cufsForProjectReq.size()) continue;
                if (!noRedmineCuf) break block25;
                switch (f.getRedmineField()) {
                    case "done ratio": {
                        redmineValue = String.valueOf(issue.getDoneRatio()) + "%";
                        break;
                    }
                    case "category": {
                        if (issue.getCategory() == null) break;
                        redmineValue = issue.getCategory().getName();
                        break;
                    }
                    case "target version": {
                        if (issue.getTargetVersion() == null) break;
                        redmineValue = issue.getTargetVersion().getName();
                        break;
                    }
                    case "spent hours": {
                        List<TimeEntry> entries = client.getTimeEntriesForIssue(issue.getId());
                        StringBuilder spentHoursDetails = new StringBuilder();
                        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                        for (TimeEntry entry : entries) {
                            spentHoursDetails.append(entry.getHours()).append(" h : ").append(entry.getActivityName()).append(" (").append(formatter.format(entry.getSpentOn())).append(")").append("</br>");
                        }
                        redmineValue = spentHoursDetails.toString();
                    }
                }
                cufs.put(cufsForProjectReq.get(i).getCustomField().getCode(), (String)redmineValue);
                continue;
            }
            if (redmineCufs == null) continue;
            int j = 0;
            while (j < redmineCufs.size() && !f.getRedmineField().equals(((CustomField)redmineCufs.get(j)).getName())) {
                ++j;
            }
            if (j >= redmineCufs.size()) continue;
            String value = "";
            ArrayList<String> values = new ArrayList();
            if (((CustomField)redmineCufs.get(j)).getValue() != null) {
                value = ((CustomField)redmineCufs.get(j)).getValue();
            }
            if (((CustomField)redmineCufs.get(j)).getValues() != null) {
                values = ((CustomField)redmineCufs.get(j)).getValues();
            }
            redmineValue = this.squashHelper.getCustomfieldValue(f.getSquashField(), value, values, cufsForProjectReq.get(i).getCustomField(), client, (CustomField)redmineCufs.get(j), this.server, filter, allRedmineCufs);
            cufs.put(cufsForProjectReq.get(i).getCustomField().getCode(), (String)redmineValue);
        }
        if (valueMappings.size() != 0 && valueMappings.get(STATUS) != null) {
            String statusName = issue.getStatusName();
            this.synchronizeStatuses(valueMappings, statusName, version);
            mappings.remove((Object)FieldMapping.byId(STATUS.toUpperCase()));
        }
    }

    private RequirementVersionInstruction wrapAsInstruction(RequirementVersion version, Map<String, String> cufs, String path, String key) {
        RequirementTarget treq = new RequirementTarget(path);
        treq.setRemoteKey(key);
        RequirementVersionTarget tversion = new RequirementVersionTarget(treq, null);
        RequirementVersionInstruction instr = new RequirementVersionInstruction(tversion, version);
        tversion.setVersion(Integer.valueOf(1));
        for (Map.Entry<String, String> cuf : cufs.entrySet()) {
            instr.addCustomField(cuf.getKey(), cuf.getValue());
        }
        return instr;
    }

    private void updateExtender(RequirementSyncExtender ext, Issue issue, FilterBinding binding) {
        ext.setServer(this.server);
        ext.setRemoteProjectId(binding.getKey());
        ext.setRemoteFilterName(binding.getFilter());
        ext.setRemoteReqId(issue.getId().toString());
        String url = StringUtils.appendIfMissing((String)this.server.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "issues/" + String.valueOf(issue.getId());
        try {
            ext.setRemoteUrl(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("could not set url correctly for issue '" + String.valueOf(issue.getId()) + "', offending url being '" + url + "'");
        }
    }

    public void postProcess(Collection<RequirementVersionInstruction> instructions) {
        this.processMilestones(instructions);
        this.processAudit(instructions);
    }

    private void processMilestones(Collection<RequirementVersionInstruction> instructions) {
        if (this.isMilestoneMode()) {
            for (RequirementVersionInstruction instr : instructions) {
                Long versId = instr.getRequirementVersion().getId();
                Set<Long> milesIds = this.versionAndMilestoneIds.get(versId);
                if (milesIds == null) {
                    milesIds = new HashSet<Long>();
                }
                milesIds.add(this.getActiveMilestoneId());
                this.managService.bindMilestones(versId.longValue(), milesIds);
            }
        }
    }

    private void processAudit(Collection<RequirementVersionInstruction> instructions) {
        this.pluginDao.flush();
        String login = UserContextHolder.getUsername();
        HashSet<Long> versionIds = new HashSet<Long>();
        for (RequirementVersionInstruction instr : instructions) {
            SyncRequirementCreation evt;
            ImportMode mode = instr.getMode();
            RequirementVersion version = instr.getRequirementVersion();
            versionIds.add(version.getId());
            if (mode == ImportMode.CREATE) {
                evt = new SyncRequirementCreation(version, login);
                evt.setSource(version.getRequirement().getSyncExtender().getRemoteUrl().toString());
                this.pluginDao.persist((RequirementAuditEvent)evt);
                continue;
            }
            evt = new SyncRequirementUpdate(version, login);
            evt.setSource(version.getRequirement().getSyncExtender().getRemoteUrl().toString());
            this.pluginDao.persist((RequirementAuditEvent)evt);
        }
        this.pluginDao.removeAllCreationEvent(versionIds);
    }

    private void synchronizeStatuses(ValueMappings valueMappings, String statusName, RequirementVersion version) {
        block16: {
            block13: {
                block14: {
                    Map statutes = (Map)valueMappings.get(STATUS);
                    if (statutes.size() == 0) break block13;
                    String squashStatus = (String)statutes.get(statusName);
                    if (squashStatus == null) break block14;
                    switch (squashStatus) {
                        case "obsolete": {
                            version.setStatus(RequirementStatus.OBSOLETE);
                            break;
                        }
                        case "approved": {
                            version.setStatus(RequirementStatus.UNDER_REVIEW);
                            version.setStatus(RequirementStatus.APPROVED);
                            break;
                        }
                        case "under_review": {
                            version.setStatus(RequirementStatus.UNDER_REVIEW);
                            break;
                        }
                        default: {
                            version.setStatus(RequirementStatus.WORK_IN_PROGRESS);
                            break;
                        }
                    }
                    break block16;
                }
                version.setStatus(RequirementStatus.WORK_IN_PROGRESS);
                break block16;
            }
            version.setStatus(RequirementStatus.WORK_IN_PROGRESS);
        }
    }

    private void synchronizeCriticalities(ValueMappings valueMappings, String priorityText, RequirementVersion version) {
        block16: {
            block13: {
                block14: {
                    Map criticalities = (Map)valueMappings.get("criticality");
                    if (criticalities.size() == 0) break block13;
                    String squashCriticality = (String)criticalities.get(priorityText);
                    if (squashCriticality == null) break block14;
                    switch (squashCriticality) {
                        case "minor": {
                            version.setCriticality(RequirementCriticality.MINOR);
                            break;
                        }
                        case "major": {
                            version.setCriticality(RequirementCriticality.MAJOR);
                            break;
                        }
                        case "critical": {
                            version.setCriticality(RequirementCriticality.CRITICAL);
                            break;
                        }
                        default: {
                            version.setCriticality(RequirementCriticality.UNDEFINED);
                            break;
                        }
                    }
                    break block16;
                }
                version.setCriticality(RequirementCriticality.UNDEFINED);
                break block16;
            }
            version.setCriticality(RequirementCriticality.UNDEFINED);
        }
    }

    private void synchronizeCategories(Long projectId, String trackerName, RequirementVersion version, ValueMappings valueMappings) {
        InfoList categoriesList = ((Project)this.projectDao.getReferenceById((Object)projectId)).getRequirementCategories();
        InfoListItem defaultCategory = categoriesList.getDefaultItem();
        Map categories = (Map)valueMappings.get(CATEGORY);
        if (categories.size() != 0) {
            String squashCategory = (String)categories.get(trackerName);
            if (squashCategory != null) {
                for (InfoListItem category : categoriesList.getItems()) {
                    if (!category.getCode().equalsIgnoreCase(squashCategory)) continue;
                    version.setCategory(category);
                }
            } else {
                version.setCategory(defaultCategory);
            }
        } else {
            version.setCategory(defaultCategory);
        }
    }

    private void logCriticalErrors(LogTrain logs) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("some critical errors occured when importing that requirement :");
            for (LogEntry log : logs.getEntries()) {
                if (log.getStatus() != ImportStatus.FAILURE) continue;
                RequirementVersionTarget target = (RequirementVersionTarget)log.getTarget();
                LOGGER.trace(target.getPath() + " : " + this.lang.getMessage(log.getI18nError(), log.getErrorArgs(), log.getI18nError(), this.locale));
            }
        }
    }

    private Set<String> collectRedmineIssueKeys(Iterable<Issue> redmineIssues) {
        HashSet<String> issueKeys = new HashSet<String>();
        for (Issue iss : redmineIssues) {
            issueKeys.add(iss.getId().toString());
        }
        return issueKeys;
    }

    private void cacheKnownRequirementsData(Set<String> keys) {
        this.knownRequirements = this.pluginDao.findKnownRequirements(keys, this.project.getId());
        this.versionAndMilestoneIds = this.pluginDao.versionAndMilestoneIdsByRemoteKeys(keys, this.project.getId());
        this.extenderByKey = this.knownRequirements.isEmpty() ? Collections.emptyMap() : this.reqsyncDao.findByRemoteKeysAndProjectId(this.knownRequirements.keySet(), this.project.getId());
    }

    private boolean knows(String issueKey) {
        return this.knownRequirements.containsKey(issueKey);
    }

    private boolean isMilestoneMode() {
        return this.milestoneHolder.getActiveMilestone().isPresent();
    }

    private Long getActiveMilestoneId() {
        return ((Milestone)this.milestoneHolder.getActiveMilestone().get()).getId();
    }
}

