/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;

public final class DelegateCommands {
    private static final String SEARCH_ASSIGNABLE_COMMAND = "searchassignable:";
    private static final Pattern GET_ASSIGNABLE_PROJECT = Pattern.compile("searchassignable:(.*)");
    private static final String SEARCH_REPORTER_COMMAND = "searchreporter:";
    private static final Pattern GET_EPIC_PROJECT = Pattern.compile("searchepic:(.*)");
    private static final String SEARCH_EPIC_COMMAND = "searchepic:";

    private DelegateCommands() {
    }

    public static DelegateCommand buildSearchAssignableCommand(String projectKey) {
        return new DelegateCommand(SEARCH_ASSIGNABLE_COMMAND + projectKey, (Object)"");
    }

    public static DelegateCommand buildSearchReporterCommand() {
        return new DelegateCommand(SEARCH_REPORTER_COMMAND, (Object)"");
    }

    public static DelegateCommand buildSeachEpicCommand(String projectKey) {
        return new DelegateCommand(SEARCH_EPIC_COMMAND + projectKey, (Object)"");
    }

    public static boolean isSearchAssignableCommand(DelegateCommand command) {
        return command.getCommand().startsWith(SEARCH_ASSIGNABLE_COMMAND);
    }

    public static boolean isSearchReporterCommand(DelegateCommand command) {
        return command.getCommand().startsWith(SEARCH_REPORTER_COMMAND);
    }

    public static boolean isSearchEpicsCommand(DelegateCommand command) {
        return command.getCommand().startsWith(SEARCH_EPIC_COMMAND);
    }

    public static String getSearchAssignableProject(DelegateCommand command) {
        String allcommand = command.getCommand();
        Matcher matcher = GET_ASSIGNABLE_PROJECT.matcher(allcommand);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("JIRA REST client : DelegateCommand '" + allcommand + "' doesn't specify a project");
    }

    public static String getSearchEpicProject(DelegateCommand command) {
        String allcommand = command.getCommand();
        Matcher matcher = GET_EPIC_PROJECT.matcher(allcommand);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("JIRA REST client : DelegateCommand '" + allcommand + "' doesn't specify a project");
    }
}

