-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-5xym9kpn (100.64.5.63)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-9.0.0.xml
-- Ran at: 04/12/2025 15:52
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.31.1
-- *********************************************************************

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-remove-oauth1a-cred-and-conf::jprioux
-- Remove OAUTH_1A stored credentials and configuration
DELETE FROM STORED_CREDENTIALS WHERE AUTHENTICATED_SERVER IN (SELECT SERVER_ID FROM THIRD_PARTY_SERVER WHERE AUTH_PROTOCOL = 'OAUTH_1A');

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-remove-oauth1a-cred-and-conf', 'jprioux', 'tm/tm.changelog-9.0.0.xml', NOW(), 1, '9:e5564512878f47076d46caa26b1894de', 'delete tableName=STORED_CREDENTIALS', 'Remove OAUTH_1A stored credentials and configuration', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-migrate-oauth1a-to-oauth2::jprioux
-- Migrate OAUTH_1A third party servers to OAUTH_2
UPDATE THIRD_PARTY_SERVER SET AUTH_PROTOCOL = 'OAUTH_2' WHERE AUTH_PROTOCOL = 'OAUTH_1A';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-migrate-oauth1a-to-oauth2', 'jprioux', 'tm/tm.changelog-9.0.0.xml', NOW(), 2, '9:517426670e824e2bb8b64483158764fc', 'update tableName=THIRD_PARTY_SERVER', 'Migrate OAUTH_1A third party servers to OAUTH_2', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-remove-active-column-in-project-table::jmarque
-- Remove column active in project table
ALTER TABLE PROJECT DROP COLUMN ACTIVE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-remove-active-column-in-project-table', 'jmarque', 'tm/tm.changelog-9.0.0.xml', NOW(), 3, '9:878da21f351724b52376b7dcbb6666c4', 'dropColumn columnName=ACTIVE, tableName=PROJECT', 'Remove column active in project table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-add-index-on-execution-last-executed-on-to-improve-performance::mbrugniere
-- Add index on the last_executed_on column of the execution table
CREATE INDEX idx_execution_last_executed_on ON EXECUTION(LAST_EXECUTED_ON);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-add-index-on-execution-last-executed-on-to-improve-performance', 'mbrugniere', 'tm/tm.changelog-9.0.0.xml', NOW(), 4, '9:371c76a95979c6912b07e2088d702abe', 'createIndex indexName=idx_execution_last_executed_on, tableName=EXECUTION', 'Add index on the last_executed_on column of the execution table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-create-failure-detail-table::fahadi
-- Create the failure detail table
CREATE TABLE FAILURE_DETAIL (FAILURE_DETAIL_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, MESSAGE TEXT, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON TIMESTAMP WITHOUT TIME ZONE NOT NULL, ITEM_TEST_PLAN_ID BIGINT NOT NULL, ISSUE_LIST_ID BIGINT, CONSTRAINT pk_failure_detail PRIMARY KEY (FAILURE_DETAIL_ID), CONSTRAINT fk_failure_detail_itpi_id FOREIGN KEY (ITEM_TEST_PLAN_ID) REFERENCES ITERATION_TEST_PLAN_ITEM(ITEM_TEST_PLAN_ID), CONSTRAINT fk_failure_detail_issue_list FOREIGN KEY (ISSUE_LIST_ID) REFERENCES ISSUE_LIST(ISSUE_LIST_ID));

COMMENT ON COLUMN FAILURE_DETAIL.FAILURE_DETAIL_ID IS 'primary key for FAILURE_DETAIL';

COMMENT ON COLUMN FAILURE_DETAIL.ITEM_TEST_PLAN_ID IS 'foreign key to ITPI';

COMMENT ON COLUMN FAILURE_DETAIL.ISSUE_LIST_ID IS 'Foreign key to issue list';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-create-failure-detail-table', 'fahadi', 'tm/tm.changelog-9.0.0.xml', NOW(), 5, '9:0036b4bb74ec666d47923bac270cb15e', 'createTable tableName=FAILURE_DETAIL', 'Create the failure detail table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-create-failure-detail-indexes::fahadi
-- Create indexes for failure detail table
CREATE INDEX idx_failure_detail_item_test_plan_id ON FAILURE_DETAIL(ITEM_TEST_PLAN_ID);

CREATE INDEX idx_failure_detail_created_by ON FAILURE_DETAIL(CREATED_BY);

CREATE INDEX idx_fk_failure_detail_issue_list_id ON FAILURE_DETAIL(ISSUE_LIST_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-create-failure-detail-indexes', 'fahadi', 'tm/tm.changelog-9.0.0.xml', NOW(), 6, '9:38ae23a75910b0e4ad869e3fffb2dbdc', 'createIndex indexName=idx_failure_detail_item_test_plan_id, tableName=FAILURE_DETAIL; createIndex indexName=idx_failure_detail_created_by, tableName=FAILURE_DETAIL; createIndex indexName=idx_fk_failure_detail_issue_list_id, tableName=FAILURE_DETAIL', 'Create indexes for failure detail table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-create-automated-execution-failure-detail-table::fahadi
-- Create the automated execution failure detail table
CREATE TABLE AUTOMATED_EXECUTION_FAILURE_DETAIL (FAILURE_DETAIL_ID BIGINT NOT NULL, EXECUTION_EXTENDER_ID BIGINT NOT NULL);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-create-automated-execution-failure-detail-table', 'fahadi', 'tm/tm.changelog-9.0.0.xml', NOW(), 7, '9:61d3d5b12bd8a66a092f8b5383675f2d', 'createTable tableName=AUTOMATED_EXECUTION_FAILURE_DETAIL', 'Create the automated execution failure detail table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-create-automated-execution-failure-detail-indexes::fahadi
-- Create indexes for automated execution failure detail table
CREATE INDEX idx_automated_execution_failure_detail_execution_extender_id ON AUTOMATED_EXECUTION_FAILURE_DETAIL(EXECUTION_EXTENDER_ID);

CREATE INDEX idx_automated_execution_failure_detail_failure_detail_id ON AUTOMATED_EXECUTION_FAILURE_DETAIL(FAILURE_DETAIL_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-create-automated-execution-failure-detail-indexes', 'fahadi', 'tm/tm.changelog-9.0.0.xml', NOW(), 8, '9:b4787ada82d7bd9a892e7d1f5a653392', 'createIndex indexName=idx_automated_execution_failure_detail_execution_extender_id, tableName=AUTOMATED_EXECUTION_FAILURE_DETAIL; createIndex indexName=idx_automated_execution_failure_detail_failure_detail_id, tableName=AUTOMATED_EXECUTION_FAILURE...', 'Create indexes for automated execution failure detail table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-add-automated-execution-failure-detail-foreign-keys::fahadi
-- Add foreign key constraints for automated execution failure detail table
ALTER TABLE AUTOMATED_EXECUTION_FAILURE_DETAIL ADD CONSTRAINT fk_automated_execution_failure_detail_failure_detail_id FOREIGN KEY (FAILURE_DETAIL_ID) REFERENCES FAILURE_DETAIL (FAILURE_DETAIL_ID);

ALTER TABLE AUTOMATED_EXECUTION_FAILURE_DETAIL ADD CONSTRAINT fk_automated_execution_failure_detail_execution_id FOREIGN KEY (EXECUTION_EXTENDER_ID) REFERENCES AUTOMATED_EXECUTION_EXTENDER (EXTENDER_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-add-automated-execution-failure-detail-foreign-keys', 'fahadi', 'tm/tm.changelog-9.0.0.xml', NOW(), 9, '9:b5de3bfafdf2b9808d24039f1d55263b', 'addForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_FAILURE_DETAIL, constraintName=fk_automated_execution_failure_detail_failure_detail_id, referencedTableName=FAILURE_DETAIL; addForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_FAILURE...', 'Add foreign key constraints for automated execution failure detail table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-add-remote_req_state-column-in-sprint_requirement_sync_extender-table::mbrugniere
-- Add remote_req_state column in SPRINT_REQUIREMENT_SYNC_EXTENDER
ALTER TABLE SPRINT_REQUIREMENT_SYNC_EXTENDER ADD REMOTE_REQ_STATE VARCHAR(20);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-add-remote_req_state-column-in-sprint_requirement_sync_extender-table', 'mbrugniere', 'tm/tm.changelog-9.0.0.xml', NOW(), 10, '9:6deed4ac1dd631803d529b8270377ff9', 'addColumn tableName=SPRINT_REQUIREMENT_SYNC_EXTENDER', 'Add remote_req_state column in SPRINT_REQUIREMENT_SYNC_EXTENDER', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0-add-column-flag-in-automated-execution-extender-table::xzhao
-- Add column flag in automated execution extender table to store test execution indicators
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD FLAG VARCHAR(50);

COMMENT ON COLUMN AUTOMATED_EXECUTION_EXTENDER.FLAG IS 'Indicates the status of the automated test (e.g., To be analysed, Flaky, Fixed)';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0-add-column-flag-in-automated-execution-extender-table', 'xzhao', 'tm/tm.changelog-9.0.0.xml', NOW(), 11, '9:2a1fd202beaa54f6b65f29dfddecd8a4', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', 'Add column flag in automated execution extender table to store test execution indicators', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset tm/tm.changelog-9.0.0.xml::tm-9.0.0::jprioux
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '9.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-9.0.0', 'jprioux', 'tm/tm.changelog-9.0.0.xml', NOW(), 12, '9:68af7a8fe46929e1344fe06a77d92845', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

