-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-5xym9kpn (100.64.5.63)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-6.0.0.xml
-- Ran at: 04/12/2025 15:52
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.31.1
-- *********************************************************************

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0::lmurat
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '6.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0', 'lmurat', '../tm/tm.changelog-6.0.0.xml', NOW(), 1, '9:1da4622fdd60568c4f980c199ec81cdc', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-SQUASH-6260-cleanup-core-party-authority-table::lmurat
-- Remove ROLE_TM_USER from CORE_PARTY_AUTHORITY
DELETE FROM CORE_PARTY_AUTHORITY
    WHERE AUTHORITY = 'ROLE_TM_USER';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-SQUASH-6260-cleanup-core-party-authority-table', 'lmurat', '../tm/tm.changelog-6.0.0.xml', NOW(), 2, '9:a90e3537426c6ad8ccfe2cbe2b20016b', 'sql', 'Remove ROLE_TM_USER from CORE_PARTY_AUTHORITY', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-SQUASH-6284-login-up-to-100-characters::mbrugniere
-- Update login maxlength for all tables concerned (from 50 to 100)
ALTER TABLE ACTION_WORD ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE ACTION_WORD ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE ACTION_WORD ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE AUTH_USER ALTER COLUMN LOGIN TYPE VARCHAR(100) USING (LOGIN::VARCHAR(100));

ALTER TABLE AUTH_USER ALTER COLUMN  LOGIN SET NOT NULL;

ALTER TABLE AUTOMATED_SUITE ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE AUTOMATED_SUITE ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE AUTOMATED_SUITE ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE CAMPAIGN_LIBRARY_NODE ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE CAMPAIGN_LIBRARY_NODE ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE CAMPAIGN_LIBRARY_NODE ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE CHART_DEFINITION ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE CHART_DEFINITION ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE CHART_DEFINITION ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE CONNECTION_ATTEMPT_LOG ALTER COLUMN LOGIN TYPE VARCHAR(100) USING (LOGIN::VARCHAR(100));

ALTER TABLE CORE_TEAM ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE CORE_TEAM ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE CORE_TEAM ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE CORE_USER ALTER COLUMN LOGIN TYPE VARCHAR(100) USING (LOGIN::VARCHAR(100));

ALTER TABLE CORE_USER ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE CORE_USER ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE CORE_USER ALTER COLUMN  LOGIN SET NOT NULL;

ALTER TABLE CORE_USER ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE CUSTOM_REPORT_DASHBOARD ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE CUSTOM_REPORT_DASHBOARD ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE CUSTOM_REPORT_DASHBOARD ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE EXECUTION ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE EXECUTION ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE EXECUTION ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE EXECUTION_STEP ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE EXECUTION_STEP ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE EXECUTION_STEP ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE INFO_LIST ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE INFO_LIST ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE INFO_LIST ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE ITERATION ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE ITERATION ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE ITERATION ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE ITERATION_TEST_PLAN_ITEM ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE ITERATION_TEST_PLAN_ITEM ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE ITERATION_TEST_PLAN_ITEM ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE MILESTONE ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE MILESTONE ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE MILESTONE ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE PROJECT ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE PROJECT ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE PROJECT ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE REPORT_DEFINITION ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE REPORT_DEFINITION ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE REPORT_DEFINITION ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE REQUIREMENT_LIBRARY_NODE ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE REQUIREMENT_LIBRARY_NODE ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE REQUIREMENT_LIBRARY_NODE ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER ALTER COLUMN LAST_SYNCHRONIZED_BY TYPE VARCHAR(100) USING (LAST_SYNCHRONIZED_BY::VARCHAR(100));

ALTER TABLE RESOURCE ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE RESOURCE ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE RESOURCE ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE TEST_AUTOMATION_SERVER ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE TEST_AUTOMATION_SERVER ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE TEST_AUTOMATION_SERVER ALTER COLUMN  CREATED_BY SET DEFAULT '(nobody)';

ALTER TABLE TEST_CASE_LIBRARY_NODE ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE TEST_CASE_LIBRARY_NODE ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE TEST_CASE_LIBRARY_NODE ALTER COLUMN  CREATED_BY SET NOT NULL;

ALTER TABLE TEST_SUITE ALTER COLUMN CREATED_BY TYPE VARCHAR(100) USING (CREATED_BY::VARCHAR(100));

ALTER TABLE TEST_SUITE ALTER COLUMN LAST_MODIFIED_BY TYPE VARCHAR(100) USING (LAST_MODIFIED_BY::VARCHAR(100));

ALTER TABLE TEST_SUITE ALTER COLUMN  CREATED_BY SET NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-SQUASH-6284-login-up-to-100-characters', 'mbrugniere', '../tm/tm.changelog-6.0.0.xml', NOW(), 3, '9:4da72f9cd6af85d1618faaabd82056a9', 'modifyDataType columnName=CREATED_BY, tableName=ACTION_WORD; addNotNullConstraint columnName=CREATED_BY, tableName=ACTION_WORD; modifyDataType columnName=LAST_MODIFIED_BY, tableName=ACTION_WORD; modifyDataType columnName=LOGIN, tableName=AUTH_USER...', 'Update login maxlength for all tables concerned (from 50 to 100)', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-exploratory-test-case::pckerneis
-- Create the exploratory test case table
CREATE TABLE EXPLORATORY_TEST_CASE (TCLN_ID BIGINT NOT NULL, CHARTER TEXT DEFAULT null, SESSION_DURATION INTEGER DEFAULT null, CONSTRAINT pk_exploratory_test_case PRIMARY KEY (TCLN_ID), CONSTRAINT fk_exploratory_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID));

COMMENT ON COLUMN EXPLORATORY_TEST_CASE.TCLN_ID IS 'primary key shared with TEST_CASE';

COMMENT ON COLUMN EXPLORATORY_TEST_CASE.CHARTER IS 'the charter for an exploratory test_case';

COMMENT ON COLUMN EXPLORATORY_TEST_CASE.SESSION_DURATION IS 'the test session planned duration in minutes';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-exploratory-test-case', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 4, '9:b5c6f62ab4203dbe7033067a329f17a6', 'createTable tableName=EXPLORATORY_TEST_CASE', 'Create the exploratory test case table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-exploratory-execution::pckerneis
-- Create the exploratory execution table
CREATE TABLE EXPLORATORY_EXECUTION (EXECUTION_ID BIGINT NOT NULL, ASSIGNEE_ID BIGINT DEFAULT null, TASK_DIVISION VARCHAR(255) DEFAULT null, REVIEWED BOOLEAN DEFAULT FALSE NOT NULL, CONSTRAINT pk_exploratory_execution PRIMARY KEY (EXECUTION_ID), CONSTRAINT fk_exploratory_execution_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID), CONSTRAINT fk_exploratory_execution_core_user FOREIGN KEY (ASSIGNEE_ID) REFERENCES CORE_USER(PARTY_ID));

COMMENT ON COLUMN EXPLORATORY_EXECUTION.EXECUTION_ID IS 'primary key shared with EXECUTION';

CREATE INDEX idx_fk_exploratory_execution_assignee ON EXPLORATORY_EXECUTION(ASSIGNEE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-exploratory-execution', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 5, '9:9f79c8d818b4b6e706a6535a3d569b6e', 'createTable tableName=EXPLORATORY_EXECUTION; createIndex indexName=idx_fk_exploratory_execution_assignee, tableName=EXPLORATORY_EXECUTION', 'Create the exploratory execution table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-session-note-for-exploratory-execution::mbrugniere
-- Create the session note table
CREATE TABLE SESSION_NOTE (NOTE_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, EXECUTION_ID BIGINT NOT NULL, KIND VARCHAR(30) DEFAULT 'COMMENT' NOT NULL, CONTENT TEXT DEFAULT '' NOT NULL, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON TIMESTAMP WITHOUT TIME ZONE NOT NULL, LAST_MODIFIED_BY VARCHAR(100) DEFAULT null, LAST_MODIFIED_ON TIMESTAMP WITHOUT TIME ZONE DEFAULT null, ATTACHMENT_LIST_ID BIGINT, ISSUE_LIST_ID BIGINT, NOTE_ORDER INTEGER, CONSTRAINT pk_session_note PRIMARY KEY (NOTE_ID), CONSTRAINT fk_session_note_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID), CONSTRAINT fk_session_note_issue_list FOREIGN KEY (ISSUE_LIST_ID) REFERENCES ISSUE_LIST(ISSUE_LIST_ID), CONSTRAINT fk_session_note_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID));

COMMENT ON COLUMN SESSION_NOTE.NOTE_ID IS 'primary key for SESSION_NOTE';

COMMENT ON COLUMN SESSION_NOTE.EXECUTION_ID IS 'foreign key to EXECUTION';

COMMENT ON COLUMN SESSION_NOTE.ATTACHMENT_LIST_ID IS 'Foreign key to attachment list';

COMMENT ON COLUMN SESSION_NOTE.ISSUE_LIST_ID IS 'Foreign key to issue list';

COMMENT ON COLUMN SESSION_NOTE.NOTE_ORDER IS 'Order in the note list';

CREATE INDEX idx_fk_session_note_execution ON SESSION_NOTE(EXECUTION_ID);

CREATE INDEX idx_fk_session_note_issue_list_id ON SESSION_NOTE(ISSUE_LIST_ID);

CREATE INDEX idx_session_note_created_by ON SESSION_NOTE(CREATED_BY);

CREATE INDEX idx_session_note_last_modified_by ON SESSION_NOTE(LAST_MODIFIED_BY);

CREATE INDEX idx_fk_session_note_attachment_list ON SESSION_NOTE(ATTACHMENT_LIST_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-session-note-for-exploratory-execution', 'mbrugniere', '../tm/tm.changelog-6.0.0.xml', NOW(), 6, '9:430bad4060599f6c2b1d586f9946cf5e', 'createTable tableName=SESSION_NOTE; createIndex indexName=idx_fk_session_note_execution, tableName=SESSION_NOTE; createIndex indexName=idx_fk_session_note_issue_list_id, tableName=SESSION_NOTE; createIndex indexName=idx_session_note_created_by, ta...', 'Create the session note table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-ISSUE-269-increase-max-size-for-test-reference::dclaerhout
-- Increase max size for automated test reference in test case table
ALTER TABLE TEST_CASE ALTER COLUMN AUTOMATED_TEST_REFERENCE TYPE VARCHAR(512) USING (AUTOMATED_TEST_REFERENCE::VARCHAR(512));

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-ISSUE-269-increase-max-size-for-test-reference', 'dclaerhout', '../tm/tm.changelog-6.0.0.xml', NOW(), 7, '9:0bd157b42a4f46da8a7356cf1193ea0b', 'modifyDataType columnName=AUTOMATED_TEST_REFERENCE, tableName=TEST_CASE', 'Increase max size for automated test reference in test case table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-issue-368-add-additional-configuration-to-test-automation-server::fahadi
-- Add additional configuration to the test automation server
ALTER TABLE TEST_AUTOMATION_SERVER ADD ADDITIONAL_CONFIGURATION TEXT;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-issue-368-add-additional-configuration-to-test-automation-server', 'fahadi', '../tm/tm.changelog-6.0.0.xml', NOW(), 8, '9:358d02ec3170595bc7c24c2dbc276ba3', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add additional configuration to the test automation server', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-update-execution_issues_closure::mbrugniere
-- Consider session notes to get all known issues for an execution
DROP VIEW EXECUTION_ISSUES_CLOSURE;

CREATE VIEW EXECUTION_ISSUES_CLOSURE AS select exec.execution_id, issue.issue_id
      from EXECUTION exec
         inner join ISSUE issue on exec.issue_list_id = issue.issue_list_id
      UNION
      select eesteps.execution_id, issue.issue_id
      from EXECUTION_EXECUTION_STEPS eesteps
             inner join EXECUTION_STEP estep on eesteps.execution_step_id = estep.execution_step_id
             inner join ISSUE issue on estep.issue_list_id = issue.issue_list_id
      UNION
      select sn.execution_id, ISSUE.issue_id
      from SESSION_NOTE sn
             inner join ISSUE on ISSUE.issue_list_id = sn.issue_list_id;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-update-execution_issues_closure', 'mbrugniere', '../tm/tm.changelog-6.0.0.xml', NOW(), 9, '9:4386a6d83560f0de3ee87cb09071285e', 'dropView viewName=EXECUTION_ISSUES_CLOSURE; createView viewName=EXECUTION_ISSUES_CLOSURE', 'Consider session notes to get all known issues for an execution', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-grid-column-display-reference-table::jmarque
-- Create the grid reference table
CREATE TABLE GRID_COLUMN_DISPLAY_REFERENCE (GCDR_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, PARTY_ID BIGINT NOT NULL, GRID_ID VARCHAR(100) NOT NULL, PROJECT_ID BIGINT, CONSTRAINT pk_grid_column_display_reference PRIMARY KEY (GCDR_ID), CONSTRAINT fk_grid_column_display_reference_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID), CONSTRAINT fk_grid_column_display_reference_core_user FOREIGN KEY (PARTY_ID) REFERENCES CORE_USER(PARTY_ID));

COMMENT ON COLUMN GRID_COLUMN_DISPLAY_REFERENCE.GCDR_ID IS 'primary key for GRID_COLUMN_DISPLAY_REFERENCE';

COMMENT ON COLUMN GRID_COLUMN_DISPLAY_REFERENCE.PARTY_ID IS 'foreign key to CORE_USER';

COMMENT ON COLUMN GRID_COLUMN_DISPLAY_REFERENCE.PROJECT_ID IS 'foreign key to PROJECT';

CREATE INDEX idx_fk_grid_column_display_reference_party_id ON GRID_COLUMN_DISPLAY_REFERENCE(PARTY_ID);

CREATE INDEX idx_fk_grid_column_display_reference_project_id ON GRID_COLUMN_DISPLAY_REFERENCE(PROJECT_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-grid-column-display-reference-table', 'jmarque', '../tm/tm.changelog-6.0.0.xml', NOW(), 10, '9:cc3e54db447d7e213e3739d5e29f9d82', 'createTable tableName=GRID_COLUMN_DISPLAY_REFERENCE; createIndex indexName=idx_fk_grid_column_display_reference_party_id, tableName=GRID_COLUMN_DISPLAY_REFERENCE; createIndex indexName=idx_fk_grid_column_display_reference_project_id, tableName=GRI...', 'Create the grid reference table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-grid-column-display-configuration-table::jmarque
-- Create the grid configuration table
CREATE TABLE GRID_COLUMN_DISPLAY_CONFIGURATION (GCDC_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, GCDR_ID BIGINT NOT NULL, ACTIVE_COLUMN_ID VARCHAR(100) NOT NULL, CONSTRAINT pk_grid_column_display_configuration PRIMARY KEY (GCDC_ID), CONSTRAINT fk_grid_col_display_config_grid_col_display_ref FOREIGN KEY (GCDR_ID) REFERENCES GRID_COLUMN_DISPLAY_REFERENCE(GCDR_ID));

COMMENT ON COLUMN GRID_COLUMN_DISPLAY_CONFIGURATION.GCDC_ID IS 'primary key for GRID_COLUMN_DISPLAY_CONFIGURATION';

COMMENT ON COLUMN GRID_COLUMN_DISPLAY_CONFIGURATION.GCDR_ID IS 'foreign key to GRID_COLUMN_DISPLAY_REFERENCE';

CREATE INDEX idx_fk_grid_column_display_configuration_gcdr_id ON GRID_COLUMN_DISPLAY_CONFIGURATION(GCDR_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-grid-column-display-configuration-table', 'jmarque', '../tm/tm.changelog-6.0.0.xml', NOW(), 11, '9:55d28e6951c7a21c366de060c1c9c2cf', 'createTable tableName=GRID_COLUMN_DISPLAY_CONFIGURATION; createIndex indexName=idx_fk_grid_column_display_configuration_gcdr_id, tableName=GRID_COLUMN_DISPLAY_CONFIGURATION', 'Create the grid configuration table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-create-exploratory-execution-event-table::pckerneis
-- Create the exploratory session event table
CREATE TABLE EXPLORATORY_EXECUTION_EVENT (EVENT_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, EXECUTION_ID BIGINT NOT NULL, EVENT_DATE TIMESTAMP(3) WITHOUT TIME ZONE NOT NULL, AUTHOR VARCHAR(100) NOT NULL, EVENT_TYPE VARCHAR(30) NOT NULL, CONSTRAINT pk_exploratory_execution_event PRIMARY KEY (EVENT_ID), CONSTRAINT fk_exploratory_execution_event_execution FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID));

COMMENT ON COLUMN EXPLORATORY_EXECUTION_EVENT.EVENT_ID IS 'primary key for EXPLORATORY_EXECUTION_EVENT';

COMMENT ON COLUMN EXPLORATORY_EXECUTION_EVENT.EXECUTION_ID IS 'foreign key to EXECUTION';

ALTER TABLE EXPLORATORY_EXECUTION_EVENT ADD CONSTRAINT uc_exploratory_execution_event_execution_id_event_date UNIQUE (EXECUTION_ID, EVENT_DATE);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-create-exploratory-execution-event-table', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 12, '9:71be01a045aaef62c9c8f54a56402fa6', 'createTable tableName=EXPLORATORY_EXECUTION_EVENT; addUniqueConstraint constraintName=uc_exploratory_execution_event_execution_id_event_date, tableName=EXPLORATORY_EXECUTION_EVENT', 'Create the exploratory session event table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-dataset-parameter-order::pckerneis
-- add an order to parameters
ALTER TABLE PARAMETER ADD PARAM_ORDER INTEGER;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-dataset-parameter-order', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 13, '9:639dadfddd2529e96a51722a5a0fa8d5', 'addColumn tableName=PARAMETER', 'add an order to parameters', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-dataset-parameter-order-generation::pckerneis
create table PARAM_TEMP (id bigint, cnt int);

insert into PARAM_TEMP
      select param_id as id,
             ROW_NUMBER() over (PARTITION BY TEST_CASE_ID ORDER BY PARAM_ID) as cnt from PARAMETER;

update PARAMETER
      set param_order=cnt-1
      from PARAM_TEMP
      where param_id=id;

drop table PARAM_TEMP;

ALTER TABLE PARAMETER ALTER COLUMN PARAM_ORDER SET NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-dataset-parameter-order-generation', 'pckerneis', '../tm/tm.changelog-6.0.0.xml', NOW(), 14, '9:ce26bdca61165e40fdbbc754010577d6', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-add-exploratory-session-overview::mbrugniere
-- Create the exploratory session overview table
CREATE TABLE EXPLORATORY_SESSION_OVERVIEW (OVERVIEW_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, ITEM_TEST_PLAN_ID BIGINT NOT NULL, CHARTER TEXT DEFAULT null, SESSION_DURATION INTEGER DEFAULT null, NAME VARCHAR(255) NOT NULL, REFERENCE VARCHAR(50) DEFAULT '' NOT NULL, DUE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT null, SESSION_STATUS VARCHAR(50) DEFAULT 'TO_DO' NOT NULL, COMMENTS TEXT DEFAULT null, ATTACHMENT_LIST_ID BIGINT, CONSTRAINT pk_exploratory_session_overview PRIMARY KEY (OVERVIEW_ID), CONSTRAINT fk_exploratory_session_overview FOREIGN KEY (ITEM_TEST_PLAN_ID) REFERENCES ITERATION_TEST_PLAN_ITEM(ITEM_TEST_PLAN_ID), CONSTRAINT fk_exploratory_session_overview_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID));

COMMENT ON COLUMN EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID IS 'foreign key to ITERATION_TEST_PLAN_ITEM';

COMMENT ON COLUMN EXPLORATORY_SESSION_OVERVIEW.CHARTER IS 'the charter for an exploratory session overview';

COMMENT ON COLUMN EXPLORATORY_SESSION_OVERVIEW.SESSION_DURATION IS 'the test session planned duration in minutes';

COMMENT ON COLUMN EXPLORATORY_SESSION_OVERVIEW.ATTACHMENT_LIST_ID IS 'Foreign key to attachment list';

CREATE INDEX idx_fk_exploratory_session_overview_itpi ON EXPLORATORY_SESSION_OVERVIEW(ITEM_TEST_PLAN_ID);

CREATE INDEX idx_fk_exploratory_session_overview_attachment_list ON EXPLORATORY_SESSION_OVERVIEW(ATTACHMENT_LIST_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-add-exploratory-session-overview', 'mbrugniere', '../tm/tm.changelog-6.0.0.xml', NOW(), 15, '9:82e7bfed7a0aac520250fd073c73be7a', 'createTable tableName=EXPLORATORY_SESSION_OVERVIEW; createIndex indexName=idx_fk_exploratory_session_overview_itpi, tableName=EXPLORATORY_SESSION_OVERVIEW; createIndex indexName=idx_fk_exploratory_session_overview_attachment_list, tableName=EXPLOR...', 'Create the exploratory session overview table', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-squash-remove-resultpublisher-plugin-binding::bms
DELETE FROM LIBRARY_PLUGIN_BINDING_PROPERTY
      WHERE PLUGIN_BINDING_ID IN (
        SELECT PLUGIN_BINDING_ID
        FROM LIBRARY_PLUGIN_BINDING WHERE PLUGIN_ID = 'squash.tm.plugin.resultpublisher'
      );

DELETE FROM LIBRARY_PLUGIN_BINDING WHERE PLUGIN_ID = 'squash.tm.plugin.resultpublisher';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-squash-remove-resultpublisher-plugin-binding', 'bms', '../tm/tm.changelog-6.0.0.xml', NOW(), 16, '9:534e9059223d07ff643a368807ac1d8c', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Changeset ../tm/tm.changelog-6.0.0.xml::tm-6.0.0-667-rename-squashautom-ta-server-kind::jprioux
UPDATE TEST_AUTOMATION_SERVER SET KIND = 'squashOrchestrator' WHERE KIND = 'squashAutom';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-6.0.0-667-rename-squashautom-ta-server-kind', 'jprioux', '../tm/tm.changelog-6.0.0.xml', NOW(), 17, '9:dcca6dbc5f5d66e58fb4a015318ffc08', 'update tableName=TEST_AUTOMATION_SERVER', '', 'EXECUTED', NULL, NULL, '4.31.1', '4859932189');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

