/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.squashtest.tm.domain.promptset.Prompt;

public class PromptSerializer
extends StdSerializer<Collection<Prompt>> {
    public static final Comparator<Prompt> ID_COMPARATOR = new Comparator<Prompt>(){

        @Override
        public int compare(Prompt p, Prompt q) {
            if (p.getId() == q.getId()) {
                return p.getName().compareTo(q.getName());
            }
            if (p.getId() > q.getId()) {
                return 1;
            }
            return -1;
        }
    };

    public PromptSerializer() {
        super(TypeFactory.defaultInstance().constructType(Collection.class));
    }

    private void doSerialize(Collection<Prompt> prompts, JsonGenerator gen) throws IOException {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        ArrayList<Prompt> listPrompt = new ArrayList<Prompt>(prompts);
        Collections.sort(listPrompt, ID_COMPARATOR);
        gen.writeStartArray();
        for (Prompt prompt : prompts) {
            attributes.put("_type", "prompt");
            attributes.put("id", prompt.getId());
            attributes.put("name", prompt.getName());
            attributes.put("system_prompt_template", prompt.getSystemPromptTemplate());
            attributes.put("user_prompt_template", prompt.getUserPromptTemplate());
            attributes.put("_links", this.createLinksMap(prompt));
            gen.writeObject(attributes);
        }
        gen.writeEndArray();
    }

    private Map<String, Object> createLinksMap(Prompt prompt) {
        HashMap<String, Object> links = new HashMap<String, Object>();
        HashMap<String, CallSite> selfLink = new HashMap<String, CallSite>();
        selfLink.put("href", (CallSite)((Object)("http://localhost:8080/api/rest/latest/prompts/" + String.valueOf(prompt.getId()))));
        links.put("self", selfLink);
        return links;
    }

    public void serialize(Collection<Prompt> prompts, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this.doSerialize(prompts, jsonGenerator);
    }
}

