/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import java.util.List;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.promptset.Prompt;
import org.squashtest.tm.plugin.rest.admin.jackson.model.PromptDto;
import org.squashtest.tm.plugin.rest.admin.service.RestPromptService;
import org.squashtest.tm.plugin.rest.admin.validators.PromptValidator;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController(value=Prompt.class)
@UseDefaultRestApiConfiguration
public class RestPromptController
extends BaseRestController {
    private final RestPromptService restPromptService;
    private final PromptValidator promptValidator;

    public RestPromptController(RestPromptService restPromptService, PromptValidator promptValidator) {
        this.restPromptService = restPromptService;
        this.promptValidator = promptValidator;
    }

    @GetMapping(value={"/prompts/{id}"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression(value="*,prompt_set[*,-prompts]")
    public ResponseEntity<EntityModel<Prompt>> findPromptById(@PathVariable(value="id") Long promptId) {
        Prompt prompt = this.restPromptService.findPromptById(promptId);
        EntityModel res = this.toEntityModel((Identified)prompt);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/prompts"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @DynamicFilterExpression(value="*,prompt_set[*,-prompts]")
    public ResponseEntity<EntityModel<Prompt>> addPrompt(@RequestBody PromptDto promptDto) throws BindException {
        this.promptValidator.promptPostValidator(promptDto);
        Prompt prompt = this.restPromptService.addPrompt(promptDto);
        EntityModel res = this.toEntityModel((Identified)prompt);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/prompts/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*,prompt_set[*,-prompts]")
    public ResponseEntity<EntityModel<Prompt>> patchPrompt(@PathVariable(value="id") Long promptId, @RequestBody PromptDto promptDto) throws BindException {
        this.promptValidator.promptPatchValidator(promptId, promptDto);
        Prompt prompt = this.restPromptService.updatePrompt(promptId, promptDto);
        EntityModel res = this.toEntityModel((Identified)prompt);
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @DeleteMapping(value={"/prompts/{ids}"})
    public ResponseEntity<Void> deletePrompts(@PathVariable(value="ids") List<Long> promptIds) {
        this.restPromptService.deletePrompts(promptIds);
        return ResponseEntity.noContent().build();
    }
}

