/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.jvnet.mimepull;

import java.util.Iterator;
import java.util.ServiceLoader;

class FactoryFinder {
    FactoryFinder() {
    }

    static <T> T find(Class<T> factoryId) throws ClassNotFoundException, ReflectiveOperationException {
        String systemProp = System.getProperty(factoryId.getName());
        if (systemProp != null) {
            return FactoryFinder.newInstance(factoryId, systemProp);
        }
        Iterator<T> loader = ServiceLoader.load(factoryId).iterator();
        if (loader.hasNext()) {
            return loader.next();
        }
        return null;
    }

    static <T> T newInstance(Class<T> cls, String className) throws ClassNotFoundException, ReflectiveOperationException {
        Class<?> providerClass = FactoryFinder.class.getClassLoader().loadClass(className);
        Object instance = providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        return (T)instance;
    }
}

