/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.message.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class HttpDateFormat {
    private static final boolean USE_SIMPLE_DATE_FORMAT_OVER_DATE_TIME_FORMATTER = true;
    private static final String RFC1123_DATE_FORMAT_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String RFC1036_DATE_FORMAT_PATTERN = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final String ANSI_C_ASCTIME_DATE_FORMAT_PATTERN = "EEE MMM d HH:mm:ss yyyy";
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final List<HttpDateFormatter> dateFormats = HttpDateFormat.createDateFormats();
    private static final Queue<List<HttpDateFormatter>> simpleDateFormats = new ConcurrentLinkedQueue<List<HttpDateFormatter>>();

    private HttpDateFormat() {
    }

    private static List<HttpDateFormatter> createDateFormats() {
        HttpDateFormatter[] formats = new HttpDateFormatter[]{new HttpDateFormatterFromDateTimeFormatter(DateTimeFormatter.ofPattern(RFC1123_DATE_FORMAT_PATTERN, Locale.US).withZone(GMT_TIME_ZONE.toZoneId())), new HttpDateFormatterFromDateTimeFormatter(DateTimeFormatter.ofPattern(RFC1123_DATE_FORMAT_PATTERN.replace("zzz", "ZZZ"), Locale.US).withZone(GMT_TIME_ZONE.toZoneId())), new HttpDateFormatterFromDateTimeFormatter(DateTimeFormatter.ofPattern(RFC1036_DATE_FORMAT_PATTERN, Locale.US).withZone(GMT_TIME_ZONE.toZoneId())), new HttpDateFormatterFromDateTimeFormatter(DateTimeFormatter.ofPattern(RFC1036_DATE_FORMAT_PATTERN.replace("zzz", "ZZZ"), Locale.US).withZone(GMT_TIME_ZONE.toZoneId())), new HttpDateFormatterFromDateTimeFormatter(DateTimeFormatter.ofPattern(ANSI_C_ASCTIME_DATE_FORMAT_PATTERN, Locale.US).withZone(GMT_TIME_ZONE.toZoneId()))};
        return Collections.unmodifiableList(Arrays.asList(formats));
    }

    private static List<HttpDateFormatter> createSimpleDateFormats() {
        HttpDateFormatterFromSimpleDateTimeFormat[] formats = new HttpDateFormatterFromSimpleDateTimeFormat[]{new HttpDateFormatterFromSimpleDateTimeFormat(new SimpleDateFormat(RFC1123_DATE_FORMAT_PATTERN, Locale.US)), new HttpDateFormatterFromSimpleDateTimeFormat(new SimpleDateFormat(RFC1036_DATE_FORMAT_PATTERN, Locale.US)), new HttpDateFormatterFromSimpleDateTimeFormat(new SimpleDateFormat(ANSI_C_ASCTIME_DATE_FORMAT_PATTERN, Locale.US))};
        formats[0].simpleDateFormat.setTimeZone(GMT_TIME_ZONE);
        formats[1].simpleDateFormat.setTimeZone(GMT_TIME_ZONE);
        formats[2].simpleDateFormat.setTimeZone(GMT_TIME_ZONE);
        return Collections.unmodifiableList(Arrays.asList(formats));
    }

    public static HttpDateFormatter getPreferredDateFormatter() {
        List<HttpDateFormatter> list = simpleDateFormats.poll();
        if (list == null) {
            list = HttpDateFormat.createSimpleDateFormats();
        }
        SimpleDateFormat sdf = (SimpleDateFormat)((HttpDateFormatterFromSimpleDateTimeFormat)list.get((int)0)).simpleDateFormat.clone();
        simpleDateFormats.add(list);
        return new HttpDateFormatterFromSimpleDateTimeFormat(sdf);
    }

    @Deprecated(forRemoval=true)
    public static SimpleDateFormat getPreferredDateFormat() {
        List<HttpDateFormatter> list = simpleDateFormats.poll();
        if (list == null) {
            list = HttpDateFormat.createSimpleDateFormats();
        }
        SimpleDateFormat sdf = (SimpleDateFormat)((HttpDateFormatterFromSimpleDateTimeFormat)list.get((int)0)).simpleDateFormat.clone();
        simpleDateFormats.add(list);
        return sdf;
    }

    public static Date readDate(String date) throws ParseException {
        return HttpDateFormat.readDateSDF(date);
    }

    private static Date readDateDTF(String date) throws ParseException {
        List<HttpDateFormatter> list = dateFormats;
        return HttpDateFormat.readDate(date, list);
    }

    private static Date readDateSDF(String date) throws ParseException {
        List<HttpDateFormatter> list = simpleDateFormats.poll();
        if (list == null) {
            list = HttpDateFormat.createSimpleDateFormats();
        }
        Date ret = HttpDateFormat.readDate(date, list);
        simpleDateFormats.add(list);
        return ret;
    }

    private static Date readDate(String date, List<HttpDateFormatter> formatters) throws ParseException {
        Throwable pe = null;
        for (HttpDateFormatter f : formatters) {
            try {
                return f.toDate(date);
            }
            catch (Exception e) {
                pe = pe == null ? e : pe;
            }
        }
        throw ParseException.class.isInstance(pe) ? (ParseException)pe : new ParseException(pe.getMessage(), DateTimeParseException.class.isInstance(pe) ? ((DateTimeParseException)pe).getErrorIndex() : 0);
    }

    private static class HttpDateFormatterFromSimpleDateTimeFormat
    implements HttpDateFormatter {
        private final SimpleDateFormat simpleDateFormat;

        private HttpDateFormatterFromSimpleDateTimeFormat(SimpleDateFormat simpleDateFormat) {
            this.simpleDateFormat = simpleDateFormat;
        }

        @Override
        public Date toDate(String date) {
            Date result;
            try {
                result = this.simpleDateFormat.parse(date);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            this.simpleDateFormat.setTimeZone(GMT_TIME_ZONE);
            return result;
        }

        @Override
        public LocalDateTime toDateTime(String date) {
            return Instant.from(this.toDate(date).toInstant()).atZone(GMT_TIME_ZONE.toZoneId()).toLocalDateTime();
        }

        @Override
        public String format(Date date) {
            return this.simpleDateFormat.format(date);
        }

        @Override
        public String format(LocalDateTime dateTime) {
            return this.simpleDateFormat.format(Date.from(dateTime.atZone(GMT_TIME_ZONE.toZoneId()).toInstant()));
        }
    }

    private static class HttpDateFormatterFromDateTimeFormatter
    implements HttpDateFormatter {
        private final DateTimeFormatter dateTimeFormatter;

        private HttpDateFormatterFromDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        @Override
        public Date toDate(String date) {
            return new Date(Instant.from(this.dateTimeFormatter.parse(date)).toEpochMilli());
        }

        @Override
        public LocalDateTime toDateTime(String date) {
            return Instant.from(this.dateTimeFormatter.parse(date)).atZone(GMT_TIME_ZONE.toZoneId()).toLocalDateTime();
        }

        @Override
        public String format(Date date) {
            return this.dateTimeFormatter.format(date.toInstant());
        }

        @Override
        public String format(LocalDateTime dateTime) {
            return this.dateTimeFormatter.format(dateTime);
        }
    }

    public static interface HttpDateFormatter {
        public Date toDate(String var1);

        public LocalDateTime toDateTime(String var1);

        public String format(Date var1);

        public String format(LocalDateTime var1);
    }
}

