/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Package;
import gitlabbt.org.gitlab4j.api.models.PackageFile;
import gitlabbt.org.gitlab4j.api.models.PackageFilter;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Stream;

public class PackagesApi
extends AbstractApi {
    public PackagesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Package> getPackages(Object projectIdOrPath) throws GitLabApiException {
        return this.getPackages(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Package> getPackages(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "packages");
        return response.readEntity(new GenericType<List<Package>>(){});
    }

    public Pager<Package> getPackages(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getPackages(projectIdOrPath, null, itemsPerPage);
    }

    public Pager<Package> getPackages(Object projectIdOrPath, PackageFilter filter, int itemsPerPage) throws GitLabApiException {
        MultivaluedMap<String, String> query = filter != null ? new GitLabApiForm(filter.getQueryParams()).asMap() : null;
        return new Pager<Package>(this, Package.class, itemsPerPage, query, "projects", this.getProjectIdOrPath(projectIdOrPath), "packages");
    }

    public Stream<Package> getPackagesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getPackages(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Stream<Package> getPackagesStream(Object projectIdOrPath, PackageFilter filter) throws GitLabApiException {
        return this.getPackages(projectIdOrPath, filter, this.getDefaultPerPage()).stream();
    }

    public Package getPackage(Object projectIdOrPath, Long packageId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "packages", packageId);
        return response.readEntity(Package.class);
    }

    public List<PackageFile> getPackageFiles(Object projectIdOrPath, Long packageId) throws GitLabApiException {
        return this.getPackageFiles(projectIdOrPath, packageId, this.getDefaultPerPage()).all();
    }

    public List<PackageFile> getPackageFiles(Object projectIdOrPath, Long packageId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "packages", packageId, "package_files");
        return response.readEntity(new GenericType<List<PackageFile>>(){});
    }

    public Pager<PackageFile> getPackageFiles(Object projectIdOrPath, Long packageId, int itemsPerPage) throws GitLabApiException {
        return new Pager<PackageFile>(this, PackageFile.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "packages", packageId, "package_files");
    }

    public Stream<PackageFile> getPackagesStream(Object projectIdOrPath, Long packageId) throws GitLabApiException {
        return this.getPackageFiles(projectIdOrPath, packageId, this.getDefaultPerPage()).stream();
    }

    public void deletePackage(Object projectIdOrPath, Long packageId) throws GitLabApiException {
        if (packageId == null) {
            throw new RuntimeException("packageId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "packages", packageId);
    }
}

