/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.cookie;

import jirasync.org.apache.http.annotation.Contract;
import jirasync.org.apache.http.annotation.ThreadingBehavior;
import jirasync.org.apache.http.cookie.ClientCookie;
import jirasync.org.apache.http.cookie.CommonCookieAttributeHandler;
import jirasync.org.apache.http.cookie.Cookie;
import jirasync.org.apache.http.cookie.CookieOrigin;
import jirasync.org.apache.http.cookie.CookieRestrictionViolationException;
import jirasync.org.apache.http.cookie.MalformedCookieException;
import jirasync.org.apache.http.cookie.SetCookie;
import jirasync.org.apache.http.cookie.SetCookie2;
import jirasync.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

