/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import jiracloud.com.atlassian.jira.rest.client.api.domain.RoleActor;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jiracloud.com.sun.ws.rs.core.UriBuilder;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;

public class RoleActorJsonParser
implements JsonObjectParser<RoleActor> {
    private final URI baseJiraUri;

    public RoleActorJsonParser(URI baseJiraUri) {
        this.baseJiraUri = baseJiraUri;
    }

    @Override
    public RoleActor parse(JSONObject json) throws JSONException {
        Long id = JsonParseUtil.getOptionalLong(json, "id");
        String displayName = json.getString("displayName");
        String type = json.getString("type");
        String name = json.getString("name");
        return new RoleActor(id, displayName, type, name, this.parseAvatarUrl(json));
    }

    private URI parseAvatarUrl(JSONObject json) {
        String pathToAvatar = JsonParseUtil.getOptionalString(json, "avatarUrl");
        if (pathToAvatar != null) {
            URI avatarUri = UriBuilder.fromUri(pathToAvatar).build(new Object[0]);
            return avatarUri.isAbsolute() ? avatarUri : this.baseJiraUri.resolve(pathToAvatar);
        }
        return null;
    }
}

