/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.lang.reflect.Type;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonInputMessage;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;
import org.squashtest.tm.plugin.rest.core.web.DeserializationConfigurationInputMessage;

public class PersistentEntityJacksonHttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(clazz, null);
        return this.readJavaType(javaType, inputMessage);
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(type, contextClass);
        return this.readJavaType(javaType, inputMessage);
    }

    private Object readJavaType(JavaType javaType, HttpInputMessage inputMessage) {
        try {
            Class deserializationView;
            if (inputMessage instanceof DeserializationConfigurationInputMessage) {
                DeserializationHints hints = ((DeserializationConfigurationInputMessage)inputMessage).getHints();
                return this.getObjectMapper().reader().withAttribute((Object)"deserialization_hints", (Object)hints).forType(javaType).readValue(inputMessage.getBody());
            }
            if (inputMessage instanceof MappingJacksonInputMessage && (deserializationView = ((MappingJacksonInputMessage)inputMessage).getDeserializationView()) != null) {
                return this.getObjectMapper().readerWithView(deserializationView).forType(javaType).readValue(inputMessage.getBody());
            }
            return this.getObjectMapper().readValue(inputMessage.getBody(), javaType);
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("Could not read document: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

