/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["jquery", "backbone", "underscore", "handlebars", "./abstractStepView", "search/SearchDateWidget", "search/SearchMultiAutocompleteWidget"],
	function($, backbone, _, Handlebars, AbstractStepView) {
	"use strict";

	var sourceIterationStepView = AbstractStepView.extend({

		initialize : function(data, wizrouter) {
			this.tmpl = "#source-iteration-step-tpl";
			this.model = data;
			data.name = "sourceIterationStep";
			this._initialize(data, wizrouter);
		},

        events: {
            "click .criteria-option": "_clickOnCriteriaRadio"
        },

		updateModel : function() {

			var iterationId = this.$el.find("#source-iteration").val();
            var keepTestSuites = this.$el.find("#keep-suites").is(":checked");
            var keepAssignees = this.$el.find("#keep-assignees").is(":checked");
            var criteriaType = this.$el.find("input:radio:checked").val();

			this.model.set({
                replicationParameters: {
                    iterationId: iterationId,
                    keepTestSuites: keepTestSuites,
                    keepAssignees: keepAssignees
                },
                criteriaType: criteriaType
			});
		},

		prepareUI: function() {

		    this._initIterationComboBox();
		},

        reloadDataInView: function() {
            // NOOP
        },
        /**
        * Since prepareUI() is asynchronous here, we must call reloadData() after prepareUI() has finished.
        * So we can't implement reloadDataInView() which is called by abstractStep.
        */
        _reloadDataInView: function() {

            var iterationId;
            if(this.model.get("selectedNode").type === "ITERATION") {
                iterationId = this.model.get("selectedNode").id;
            } else {
                iterationId = this.$el.find("#source-iteration").find("option").first().val();
            }

            var emptyReplicationParameters = {
                iterationId: iterationId,
                keepTestSuites: true,
                keepAssignees: true
            };
            var emptyCriteriaType = "simple";

            var replicationParameters = this.model.get("replicationParameters") || emptyReplicationParameters;
            /* Avoid model update problems in case of refresh. */
            if(replicationParameters.iterationId === undefined) replicationParameters = emptyReplicationParameters;
            var criteriaType = this.model.get("criteriaType") || emptyCriteriaType;

            // Update the View here.
            $("#source-iteration").val(replicationParameters.iterationId);

            $("#keep-suites").prop('checked', replicationParameters.keepTestSuites);
            $("#keep-assignees").prop('checked', replicationParameters.keepAssignees);

            $("input:radio[name=criteriaTypeChoice]").prop("checked", false);
            $("input:radio[name=criteriaTypeChoice][value='" + criteriaType + "']").prop("checked", true);
        },

		_initIterationComboBox: function() {
            var self = this;
            var availableIterations = self.model.get("availableIterations");

            if(!!availableIterations) {
                self._fillIterationComboBox(availableIterations);
                self._reloadDataInView();
            } else {
                self._fetchAvailableIterations()
                    .done(function(fetchedAvailableIterations) {
                        self.model.set({"availableIterations": fetchedAvailableIterations});
                        self._fillIterationComboBox(fetchedAvailableIterations);
                        self._reloadDataInView();
                    });
            }
		},

        _fillIterationComboBox: function(availableIterations) {
            var availableIterationsListBox = this.$el.find("#source-iteration");
            _.each(availableIterations, function(iteration) {
                    availableIterationsListBox.append("<option value='" + iteration.id + "'></option>");
                    var iterationOption = $('option[value=' + iteration.id + ']');
                    iterationOption.html(iteration.name);
                });
        },

        _fetchAvailableIterations: function() {

            var selectedNode = this.model.get("selectedNode");
            var selectedNodeId = selectedNode.id;
            var selectedNodeType = selectedNode.type;

            return $.ajax({
                method: "GET",
                contentType: "application/json",
                url: squashtm.app.contextRoot + "campaign-assistant/iteration-replication/available-iterations",
                data: {
                    entityId: selectedNodeId,
                    entityType: selectedNodeType
                }
            });
        },

        _clickOnCriteriaRadio: function(event) {
            var optionPanel = event.currentTarget;
            var radioButton = $(optionPanel).find("input[type='radio']");
            radioButton.prop('checked', true);
        }
	});

	return sourceIterationStepView;

});
