--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-egfwvcju (100.64.9.17)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-3.0.0.xml
--  Ran at: 20/11/2025 15:24
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.31.1
--  *********************************************************************

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-3.0.0.xml', NOW(), 1, '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0::jprioux
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '3.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0', 'jprioux', '../tm/tm.changelog-3.0.0.xml', NOW(), 2, '9:1432664a1cf5c0c9f2dde5334eb7eccc', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4293-update-execution-nat-and-typ-icon-name::jprioux
--  Update nature and type icon name for execution with native info list
CREATE INDEX idx_exec_tc_nat_code_temp ON EXECUTION(TC_NAT_CODE);

CREATE INDEX idx_exec_tc_typ_code_temp ON EXECUTION(TC_TYP_CODE);

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'user'
      WHERE TC_NAT_CODE = 'NAT_USER_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'dashboard'
      WHERE TC_NAT_CODE = 'NAT_PERFORMANCE_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'protect'
      WHERE TC_NAT_CODE = 'NAT_SECURITY_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'circular_arrows'
      WHERE TC_NAT_CODE = 'NAT_ATDD';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'indeterminate_checkbox_empty'
      WHERE TC_NAT_CODE = 'NAT_UNDEFINED';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'monitor'
      WHERE TC_NAT_CODE = 'NAT_FUNCTIONAL_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'server'
      WHERE TC_NAT_CODE = 'NAT_NON_FUNCTIONAL_TESTING';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'briefcase'
      WHERE TC_NAT_CODE = 'NAT_BUSINESS_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'indeterminate_checkbox_empty'
      WHERE TC_TYP_CODE = 'TYP_UNDEFINED';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'task_completed'
      WHERE TC_TYP_CODE = 'TYP_COMPLIANCE_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'bug'
      WHERE TC_TYP_CODE = 'TYP_CORRECTION_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'circled_up_right'
      WHERE TC_TYP_CODE = 'TYP_EVOLUTION_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'circular_arrows'
      WHERE TC_TYP_CODE = 'TYP_REGRESSION_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'journey'
      WHERE TC_TYP_CODE = 'TYP_END_TO_END_TESTING';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'handshake'
      WHERE TC_TYP_CODE = 'TYP_PARTNER_TESTING';

DROP INDEX idx_exec_tc_nat_code_temp ON EXECUTION;

DROP INDEX idx_exec_tc_typ_code_temp ON EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4293-update-execution-nat-and-typ-icon-name', 'jprioux', '../tm/tm.changelog-3.0.0.xml', NOW(), 3, '9:f80675767f7e7ff73160dded4b3b2cf1', 'createIndex indexName=idx_exec_tc_nat_code_temp, tableName=EXECUTION; createIndex indexName=idx_exec_tc_typ_code_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_nat_code_temp, tableName=EXECUTION; dropIndex indexName=idx_exec_tc_ty...', 'Update nature and type icon name for execution with native info list', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-increase-varchar-number-for-dataset-param-value::dclaerhout
--  Change varchar from 255 to 1024 for dataset param value
ALTER TABLE DATASET_PARAM_VALUE MODIFY PARAM_VALUE VARCHAR(1024);

ALTER TABLE DATASET_PARAM_VALUE MODIFY PARAM_VALUE VARCHAR(1024) NOT NULL;

ALTER TABLE DATASET_PARAM_VALUE ALTER PARAM_VALUE SET DEFAULT '';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-increase-varchar-number-for-dataset-param-value', 'dclaerhout', '../tm/tm.changelog-3.0.0.xml', NOW(), 4, '9:945b2bb2e639983975e8f835208eac87', 'modifyDataType columnName=PARAM_VALUE, tableName=DATASET_PARAM_VALUE; addNotNullConstraint columnName=PARAM_VALUE, tableName=DATASET_PARAM_VALUE; addDefaultValue columnName=PARAM_VALUE, tableName=DATASET_PARAM_VALUE', 'Change varchar from 255 to 1024 for dataset param value', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4299-update-def-icon-name-001::jprioux
--  Update all def icon name when used in info list item
CREATE INDEX idx_info_list_item_icon_name_temp ON INFO_LIST_ITEM(ICON_NAME);

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'monitor'
      WHERE ICON_NAME = 'def_cat_functional';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'server'
      WHERE ICON_NAME = 'def_cat_non-functional';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'read'
      WHERE ICON_NAME = 'def_cat_use-case';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'briefcase'
      WHERE ICON_NAME = 'def_cat_business';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'checked_checkbox'
      WHERE ICON_NAME in ('def_cat_test-requirement', 'def_cat_noicon');

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'checkmark'
      WHERE ICON_NAME = 'def_cat_undefined';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'puzzle'
      WHERE ICON_NAME = 'def_cat_ergonomic';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'dashboard'
      WHERE ICON_NAME = 'def_cat_performance';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'key'
      WHERE ICON_NAME in ('def_cat_technical', 'def_cat_technic');

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'bookmark'
      WHERE ICON_NAME = 'def_cat_user-story';

UPDATE INFO_LIST_ITEM
      SET ICON_NAME = 'protect'
      WHERE ICON_NAME = 'def_cat_security';

DROP INDEX idx_info_list_item_icon_name_temp ON INFO_LIST_ITEM;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4299-update-def-icon-name-001', 'jprioux', '../tm/tm.changelog-3.0.0.xml', NOW(), 5, '9:d3cd3f57339feb2572f8b4bb15fee5ee', 'createIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM; sql; dropIndex indexName=idx_info_list_item_icon_name_temp, tableName=INFO_LIST_ITEM', 'Update all def icon name when used in info list item', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4299-update-def-icon-name-002::jprioux
--  Update all def icon name when used in tc nat execution
CREATE INDEX idx_exec_tc_nat_icon_name_temp ON EXECUTION(TC_NAT_ICON_NAME);

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'monitor'
      WHERE TC_NAT_ICON_NAME = 'def_cat_functional';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'server'
      WHERE TC_NAT_ICON_NAME = 'def_cat_non-functional';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'read'
      WHERE TC_NAT_ICON_NAME = 'def_cat_use-case';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'briefcase'
      WHERE TC_NAT_ICON_NAME = 'def_cat_business';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'checked_checkbox'
      WHERE TC_NAT_ICON_NAME in ('def_cat_test-requirement', 'def_cat_noicon');

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'checkmark'
      WHERE TC_NAT_ICON_NAME = 'def_cat_undefined';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'puzzle'
      WHERE TC_NAT_ICON_NAME = 'def_cat_ergonomic';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'dashboard'
      WHERE TC_NAT_ICON_NAME = 'def_cat_performance';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'key'
      WHERE TC_NAT_ICON_NAME in ('def_cat_technical', 'def_cat_technic');

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'bookmark'
      WHERE TC_NAT_ICON_NAME = 'def_cat_user-story';

UPDATE EXECUTION
      SET TC_NAT_ICON_NAME = 'protect'
      WHERE TC_NAT_ICON_NAME = 'def_cat_security';

DROP INDEX idx_exec_tc_nat_icon_name_temp ON EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4299-update-def-icon-name-002', 'jprioux', '../tm/tm.changelog-3.0.0.xml', NOW(), 6, '9:e92ff959f05e4c02e2b1a65cf4078e3f', 'createIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_nat_icon_name_temp, tableName=EXECUTION', 'Update all def icon name when used in tc nat execution', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4299-update-def-icon-name-003::jprioux
--  Update all def icon name when used in tc type execution
CREATE INDEX idx_exec_tc_typ_icon_name_temp ON EXECUTION(TC_TYP_ICON_NAME);

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'monitor'
      WHERE TC_TYP_ICON_NAME = 'def_cat_functional';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'server'
      WHERE TC_TYP_ICON_NAME = 'def_cat_non-functional';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'read'
      WHERE TC_TYP_ICON_NAME = 'def_cat_use-case';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'briefcase'
      WHERE TC_TYP_ICON_NAME = 'def_cat_business';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'checked_checkbox'
      WHERE TC_TYP_ICON_NAME in ('def_cat_test-requirement', 'def_cat_noicon');

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'checkmark'
      WHERE TC_TYP_ICON_NAME = 'def_cat_undefined';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'puzzle'
      WHERE TC_TYP_ICON_NAME = 'def_cat_ergonomic';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'dashboard'
      WHERE TC_TYP_ICON_NAME = 'def_cat_performance';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'key'
      WHERE TC_TYP_ICON_NAME in ('def_cat_technical', 'def_cat_technic');

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'bookmark'
      WHERE TC_TYP_ICON_NAME = 'def_cat_user-story';

UPDATE EXECUTION
      SET TC_TYP_ICON_NAME = 'protect'
      WHERE TC_TYP_ICON_NAME = 'def_cat_security';

DROP INDEX idx_exec_tc_typ_icon_name_temp ON EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4299-update-def-icon-name-003', 'jprioux', '../tm/tm.changelog-3.0.0.xml', NOW(), 7, '9:ed6b5aa1182eee7569f9e1c8a822d88a', 'createIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION; sql; dropIndex indexName=idx_exec_tc_typ_icon_name_temp, tableName=EXECUTION', 'Update all def icon name when used in tc type execution', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQMAP-636-add-new-attributes-to-custom-chart::dclaerhout
--  Add new attributes concerning test cases to generate custom charts
UPDATE QUERY_COLUMN_PROTOTYPE SET BUSINESS = 1 WHERE LABEL = 'TEST_CASE_AUTOMATABLE';

UPDATE QUERY_COLUMN_PROTOTYPE SET BUSINESS = 1 WHERE LABEL = 'AUTOMATION_REQUEST_STATUS';

INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) VALUES ('TEST_CASE_HAS_BOUND_SCM_REPOSITORY_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_COLUMN_PROTOTYPE(COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE,
                                         DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      VALUES ('ENTITY', FALSE, 'SCM_REPOSITORY_ENTITY', 'SCM_REPOSITORY', null, 'ENTITY', null, null),
             ('ATTRIBUTE', FALSE, 'SCM_REPOSITORY_ID', 'SCM_REPOSITORY', null, 'NUMERIC', 'id', null),
             ('ATTRIBUTE', FALSE, 'TEST_CASE_AUTOMATED_TEST_REFERENCE', 'TEST_CASE', null, 'STRING',
              'automatedTestReference', null),
             ('CALCULATED', TRUE, 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY', 'TEST_CASE', null, 'BOOLEAN',
              'notnull(scmRepository)', (select max(QUERY_MODEL_ID) from QUERY_MODEL));

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_COLUMN_ID, QUERY_MODEL_ID, LABEL, PROJECTION_OPERATION, PROJECTION_RANK, CUF_ID)
      VALUES (
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'SCM_REPOSITORY_ID'),
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        null, 'NOT_NULL', 0, null
      );

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, LABEL, AGGREGATION_OPERATION,
      AGGREGATION_RANK, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
        null, 'NONE', 0, null
      );

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
        'NONE', 0, 'ASC', null
      );

INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) VALUES ('TEST_CASE_HAS_BOUND_AUTOMATED_TEST_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_COLUMN_PROTOTYPE(COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE,
      DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      VALUES
      ('CALCULATED', TRUE, 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE', 'TEST_CASE', null, 'BOOLEAN',
      'notnull(automatedTestReference)', (select max(QUERY_MODEL_ID) from QUERY_MODEL)),
      ('ATTRIBUTE', TRUE, 'TEST_CASE_AUTOMATED_TEST_TECHNOLOGY', 'TEST_CASE', null,
      'AUTOMATED_TEST_TECHNOLOGY', 'automatedTestTechnology.name', null),
      ('ATTRIBUTE', TRUE, 'AUTOMATION_REQUEST_TRANSMISSION_DATE', 'AUTOMATION_REQUEST', null, 'DATE',
      'transmissionDate', null),
      ('ATTRIBUTE', TRUE, 'AUTOMATION_REQUEST_AUTOMATION_PRIORITY', 'AUTOMATION_REQUEST', null, 'NUMERIC',
      'automationPriority', null);

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_COLUMN_ID, QUERY_MODEL_ID, LABEL, PROJECTION_OPERATION, PROJECTION_RANK, CUF_ID)
       VALUES (
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_REFERENCE'),
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        null, 'NOT_NULL', 0, null
       );

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, LABEL, AGGREGATION_OPERATION, AGGREGATION_RANK, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
        null, 'NONE', 0, null
      );

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_REFERENCE'),
        'NONE', 0, 'ASC', null
      );

INSERT INTO CHART_COLUMN_ROLE(CHART_COLUMN_ID, ROLE)
      VALUES ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_STATUS'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_STATUS'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_STATUS'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATABLE'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATABLE'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATABLE'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_SCM_REPOSITORY'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_HAS_BOUND_AUTOMATED_TEST_REFERENCE'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_TECHNOLOGY'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_TECHNOLOGY'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_AUTOMATED_TEST_TECHNOLOGY'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_TRANSMISSION_DATE'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_TRANSMISSION_DATE'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_TRANSMISSION_DATE'), 'FILTER'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_AUTOMATION_PRIORITY'), 'MEASURE'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_AUTOMATION_PRIORITY'), 'AXIS'),
             ((select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'AUTOMATION_REQUEST_AUTOMATION_PRIORITY'), 'FILTER');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQMAP-636-add-new-attributes-to-custom-chart', 'dclaerhout', '../tm/tm.changelog-3.0.0.xml', NOW(), 8, '9:1639fff5d946cf08980fb25f9b9e495d', 'update tableName=QUERY_COLUMN_PROTOTYPE; update tableName=QUERY_COLUMN_PROTOTYPE; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql', 'Add new attributes concerning test cases to generate custom charts', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4310-create-delete-working-table::jthebault
CREATE TABLE WORK_DELETE_ENTITIES (ENTITY_ID BIGINT NOT NULL, ENTITY_TYPE VARCHAR(100) NOT NULL, OPERATION_ID VARCHAR(50) NOT NULL);

CREATE INDEX work_delete_entities_entity_type_idx ON WORK_DELETE_ENTITIES(ENTITY_TYPE);

CREATE INDEX work_delete_entities_entity_id_idx ON WORK_DELETE_ENTITIES(ENTITY_ID);

CREATE INDEX work_delete_entities_operation_id_idx ON WORK_DELETE_ENTITIES(OPERATION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4310-create-delete-working-table', 'jthebault', '../tm/tm.changelog-3.0.0.xml', NOW(), 9, '9:2873a9a32cc4a12fce5b529e9f734152', 'createTable tableName=WORK_DELETE_ENTITIES; createIndex indexName=work_delete_entities_entity_type_idx, tableName=WORK_DELETE_ENTITIES; createIndex indexName=work_delete_entities_entity_id_idx, tableName=WORK_DELETE_ENTITIES; createIndex indexName...', '', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-add-bt-project-reference-in-issue::jthebault
--  Changing the type to allow storage of large jsonified object, without using jsonb for backward compat
ALTER TABLE ISSUE ADD ADDITIONAL_DATA TEXT NULL COMMENT 'Column for json info. Use it only when remote_key is not enough to fetch issue';

CREATE INDEX issue_remote_issue_id_idx ON ISSUE(REMOTE_ISSUE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-add-bt-project-reference-in-issue', 'jthebault', '../tm/tm.changelog-3.0.0.xml', NOW(), 10, '9:673ccc1ab4164e91506156e7047266e6', 'addColumn tableName=ISSUE; createIndex indexName=issue_remote_issue_id_idx, tableName=ISSUE', 'Changing the type to allow storage of large jsonified object, without using jsonb for backward compat', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-TM-632-01-add-high-lvl-req-table::jthebault
CREATE TABLE HIGH_LEVEL_REQUIREMENT (RLN_ID BIGINT NOT NULL, CONSTRAINT pk_high_lvl_requirement PRIMARY KEY (RLN_ID), CONSTRAINT fk_high_lvl_requirement_requirement FOREIGN KEY (RLN_ID) REFERENCES REQUIREMENT(RLN_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-TM-632-01-add-high-lvl-req-table', 'jthebault', '../tm/tm.changelog-3.0.0.xml', NOW(), 11, '9:39cc419818cf805b2fd45bb1c1128945', 'createTable tableName=HIGH_LEVEL_REQUIREMENT', '', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-TM-632-02-add-query-column-proto::jthebault
--  Inserting column proto for high level requirements
INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, ENTITY_TYPE, ENTITY_ROLE, LABEL, ATTRIBUTE_NAME,
                                          DATA_TYPE, BUSINESS)
      VALUES ('ENTITY', 'REQUIREMENT', NULL, 'REQUIREMENT_KIND', NULL, 'ENTITY', FALSE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-TM-632-02-add-query-column-proto', 'jthebault', '../tm/tm.changelog-3.0.0.xml', NOW(), 12, '9:16f01f4ae7b9a7bc4a25069cb0520dd4', 'sql', 'Inserting column proto for high level requirements', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-TM-632-03-add-high-lvl-req-reference::jthebault
--  add reference column to allow requirement to be linked to high level requirements
ALTER TABLE REQUIREMENT ADD HIGH_LEVEL_REQUIREMENT_ID BIGINT NULL;

ALTER TABLE REQUIREMENT ADD CONSTRAINT fk_requirement_high_lvl_requirement FOREIGN KEY (HIGH_LEVEL_REQUIREMENT_ID) REFERENCES HIGH_LEVEL_REQUIREMENT (RLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-TM-632-03-add-high-lvl-req-reference', 'jthebault', '../tm/tm.changelog-3.0.0.xml', NOW(), 13, '9:79d583cc9be73d976a20e758d279e56f', 'addColumn tableName=REQUIREMENT', 'add reference column to allow requirement to be linked to high level requirements', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4196-add-new-attributes-to-requirement-search::dclaerhout
--  Add new attributes for high level requirement in search
INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE) VALUES ('REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_COLUMN_PROTOTYPE(COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE,
                                         DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      VALUES ('CALCULATED', FALSE, 'REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT', 'REQUIREMENT', null, 'BOOLEAN',
              'notnull(highLevelRequirement)', (select max(QUERY_MODEL_ID) from QUERY_MODEL)),
             ('ENTITY', FALSE, 'HIGH_LEVEL_REQUIREMENT_ENTITY', 'HIGH_LEVEL_REQUIREMENT', null, 'ENTITY', null,
              null),
             ('ATTRIBUTE', FALSE, 'HIGH_LEVEL_REQUIREMENT_ID', 'HIGH_LEVEL_REQUIREMENT', null, 'NUMERIC', 'id',
              null);

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_COLUMN_ID, QUERY_MODEL_ID, LABEL, PROJECTION_OPERATION, PROJECTION_RANK, CUF_ID)
      VALUES (
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'HIGH_LEVEL_REQUIREMENT_ID'),
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        null, 'NOT_NULL', 0, null
      );

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, LABEL, AGGREGATION_OPERATION,
                                           AGGREGATION_RANK, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'REQUIREMENT_ID'),
        null, 'NONE', 0, null);

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'REQUIREMENT_ID'),
        'NONE', 0, 'ASC', null
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4196-add-new-attributes-to-requirement-search', 'dclaerhout', '../tm/tm.changelog-3.0.0.xml', NOW(), 14, '9:31ef963c9c781d7167233439f8ea92ff', 'sql; sql; sql; sql; sql', 'Add new attributes for high level requirement in search', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4436-add-automated_test_technologies::pckerneis
--  Add automated test technologies (Cucumber 5+ and Postman)
insert into AUTOMATED_TEST_TECHNOLOGY(NAME, ACTION_PROVIDER_KEY)
      values ('Postman', 'postman/execute@v1'),
             ('Cucumber 5+', 'cucumber5/execute@v1'),
             ('Katalon', 'katalon/execute@v1');

update AUTOMATED_TEST_TECHNOLOGY
      set NAME = 'Cucumber 4'
      where ACTION_PROVIDER_KEY = 'cucumber/execute@v1';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4436-add-automated_test_technologies', 'pckerneis', '../tm/tm.changelog-3.0.0.xml', NOW(), 15, '9:3c1cf1c950b572b4bdca2f2f72b7152d', 'sql; sql', 'Add automated test technologies (Cucumber 5+ and Postman)', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4584-apply_InfoList_default_value::cduvigneau
--  Set InfoList default value for old Test Case and Requirement
UPDATE TEST_CASE CDT
        JOIN TEST_CASE_LIBRARY_NODE TCLN ON CDT.TCLN_ID = TCLN.TCLN_ID
        JOIN PROJECT P ON TCLN.PROJECT_ID = P.PROJECT_ID
        JOIN INFO_LIST_ITEM ILI ON CDT.TC_NATURE = ILI.ITEM_ID AND ILI.LIST_ID != P.TC_NATURES_LIST
        JOIN INFO_LIST_ITEM VAL ON VAL.LIST_ID = P.TC_NATURES_LIST AND VAL.IS_DEFAULT = 1
        SET CDT.TC_NATURE = VAL.ITEM_ID;

UPDATE TEST_CASE CDT
        JOIN TEST_CASE_LIBRARY_NODE TCLN ON CDT.TCLN_ID = TCLN.TCLN_ID
        JOIN PROJECT P ON TCLN.PROJECT_ID = P.PROJECT_ID
        JOIN INFO_LIST_ITEM ILI ON CDT.TC_TYPE = ILI.ITEM_ID AND ILI.LIST_ID != P.TC_TYPES_LIST
        JOIN INFO_LIST_ITEM VAL ON VAL.LIST_ID = P.TC_TYPES_LIST AND VAL.IS_DEFAULT = 1
        SET CDT.TC_TYPE = VAL.ITEM_ID;

UPDATE REQUIREMENT_VERSION RV
        JOIN REQUIREMENT_LIBRARY_NODE RLN ON RV.REQUIREMENT_ID = RLN.RLN_ID
        JOIN PROJECT P ON RLN.PROJECT_ID = P.PROJECT_ID
        JOIN INFO_LIST_ITEM ILI ON RV.CATEGORY = ILI.ITEM_ID AND ILI.LIST_ID != P.REQ_CATEGORIES_LIST
        JOIN INFO_LIST_ITEM VAL ON VAL.LIST_ID = P.REQ_CATEGORIES_LIST AND VAL.IS_DEFAULT = 1
        SET RV.CATEGORY = VAL.ITEM_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4584-apply_InfoList_default_value', 'cduvigneau', '../tm/tm.changelog-3.0.0.xml', NOW(), 16, '9:e63adabd9809b08bf5f8a9b9de7bb11b', 'sql', 'Set InfoList default value for old Test Case and Requirement', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-3.0.0.xml::tm-3.0.0-SQUASH-4436-add-premium-column::pckerneis
--  Add 'premium' column for test technologies
ALTER TABLE AUTOMATED_TEST_TECHNOLOGY ADD PREMIUM TINYINT(1) DEFAULT 0 NOT NULL;

UPDATE AUTOMATED_TEST_TECHNOLOGY SET PREMIUM = 1 WHERE NAME='Agilitest';

UPDATE AUTOMATED_TEST_TECHNOLOGY SET PREMIUM = 1 WHERE NAME='Katalon';

UPDATE AUTOMATED_TEST_TECHNOLOGY SET PREMIUM = 1 WHERE NAME='Ranorex';

UPDATE AUTOMATED_TEST_TECHNOLOGY SET PREMIUM = 1 WHERE NAME='UFT';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-3.0.0-SQUASH-4436-add-premium-column', 'pckerneis', '../tm/tm.changelog-3.0.0.xml', NOW(), 17, '9:08e88d54dbd91962ae86aeef35195b79', 'addColumn tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY; update tableName=AUTOMATED_TEST_TECHNOLOGY', 'Add ''premium'' column for test technologies', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

