--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-egfwvcju (100.64.9.17)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-1.22.0.xml
--  Ran at: 20/11/2025 15:24
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.31.1
--  *********************************************************************

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-1.22.0.xml', NOW(), 1, '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0::jthebault
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.22.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0', 'jthebault', '../tm/tm.changelog-1.22.0.xml', NOW(), 2, '9:62759562f0d6afca99eed7d2ad44113b', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-167-test-it-uuid-for-tf-side-trigger::edegenetais
ALTER TABLE ITERATION ADD UUID VARCHAR(36) NULL;

ALTER TABLE ITERATION ADD CONSTRAINT uc_iteration_uuid UNIQUE (UUID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-167-test-it-uuid-for-tf-side-trigger', 'edegenetais', '../tm/tm.changelog-1.22.0.xml', NOW(), 3, '9:b7215ba389d09c347bca022f46791f4b', 'addColumn tableName=ITERATION; addUniqueConstraint constraintName=uc_iteration_uuid, tableName=ITERATION', '', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-167-update-iteration-uuid-mysql::edegenetais
--  Created missing UUIDs on upgrade to add the not-null constraint.
UPDATE ITERATION SET UUID = uuid() WHERE UUID is NULL;

ALTER TABLE ITERATION MODIFY UUID VARCHAR(36) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-167-update-iteration-uuid-mysql', 'edegenetais', '../tm/tm.changelog-1.22.0.xml', NOW(), 4, '9:123a98731efc7d16c0e1941291230db3', 'sql', 'Created missing UUIDs on upgrade to add the not-null constraint.', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-174-action-word-table::jlor
--  Add action word table
CREATE TABLE ACTION_WORD (ACTION_WORD_ID BIGINT AUTO_INCREMENT NOT NULL, `DESCRIPTION` LONGTEXT NULL, CREATED_BY VARCHAR(50) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, TOKEN VARCHAR(766) NOT NULL, PROJECT_ID BIGINT NOT NULL, CONSTRAINT PK_ACTION_WORD PRIMARY KEY (ACTION_WORD_ID), CONSTRAINT fk_action_word_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID));

CREATE INDEX idx_fk_action_word_project ON ACTION_WORD(PROJECT_ID);

ALTER TABLE ACTION_WORD ADD CONSTRAINT uc_aw_token_project_id UNIQUE (TOKEN, PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-174-action-word-table', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 5, '9:e6cdc96b53c8cf351e456169fb4e42a2', 'createTable tableName=ACTION_WORD; createIndex indexName=idx_fk_action_word_project, tableName=ACTION_WORD; addUniqueConstraint constraintName=uc_aw_token_project_id, tableName=ACTION_WORD', 'Add action word table', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-174-keyword-test-step-table::jlor
--  Add keyword test step table
CREATE TABLE KEYWORD_TEST_STEP (TEST_STEP_ID BIGINT NOT NULL COMMENT 'Shared key with TEST_STEP table', ACTION_WORD_ID BIGINT NOT NULL COMMENT 'The action word which this test step uses', KEYWORD VARCHAR(20) NOT NULL COMMENT 'A keyword test step keyword', DATATABLE TEXT NULL COMMENT 'A keyword test step datatable', DOCSTRING TEXT NULL COMMENT 'A keyword test step docstring', COMMENT TEXT NULL COMMENT 'A keyword test step comment', CONSTRAINT pk_keyword_test_step PRIMARY KEY (TEST_STEP_ID), CONSTRAINT fk_keyword_test_step_test_step FOREIGN KEY (TEST_STEP_ID) REFERENCES TEST_STEP(TEST_STEP_ID), CONSTRAINT fk_keyword_test_step_action_word_id FOREIGN KEY (ACTION_WORD_ID) REFERENCES ACTION_WORD (ACTION_WORD_ID));

CREATE INDEX idx_fk_keyword_test_step_action_word ON KEYWORD_TEST_STEP(ACTION_WORD_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-174-keyword-test-step-table', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 6, '9:8ced82bc52ab71112da0e77be8c8d633', 'createTable tableName=KEYWORD_TEST_STEP; createIndex indexName=idx_fk_keyword_test_step_action_word, tableName=KEYWORD_TEST_STEP', 'Add keyword test step table', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-174-update-query-filter::jlor
--  Changes in QueryBuilder related tables concerning TEST_CASE_CALLSTEPCOUNT prototype column: adding a new subclass of TestStep (KeywordTestStep) broke the QueryBuilder
update QUERY_FILTER_VALUES set FILTER_VALUE='org.squashtest.tm.domain.testcase.CallTestStep' where QUERY_FILTER_ID=1;

update QUERY_FILTER_COLUMN set QUERY_COLUMN_ID=134, FILTER_OPERATION='IS_CLASS' where QUERY_FILTER_ID=1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-174-update-query-filter', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 7, '9:5fe21caa0e8aa24b398e6ac74fd5a759', 'sql; sql', 'Changes in QueryBuilder related tables concerning TEST_CASE_CALLSTEPCOUNT prototype column: adding a new subclass of TestStep (KeywordTestStep) broke the QueryBuilder', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-TEST_CASE_HIERARCHY_MODIFICATION::jlor
--  Create KEYWORD_TEST_CASE table. Update SCRIPTED_TC_EXTENDER table/column
CREATE TABLE KEYWORD_TEST_CASE (TCLN_ID BIGINT NOT NULL, CONSTRAINT PK_KEYWORD_TEST_CASE PRIMARY KEY (TCLN_ID), CONSTRAINT fk_keyword_tc_tc FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID));

ALTER TABLE SCRIPTED_TC_EXTENDER DROP COLUMN SCRIPTED_TC_EXTENDER_ID;

ALTER TABLE SCRIPTED_TC_EXTENDER RENAME SCRIPTED_TEST_CASE;

ALTER TABLE SCRIPTED_TEST_CASE DROP FOREIGN KEY fk_scripted_extender_test_case;

ALTER TABLE SCRIPTED_TEST_CASE CHANGE TEST_CASE_ID TCLN_ID BIGINT;

ALTER TABLE SCRIPTED_TEST_CASE ADD CONSTRAINT fk_scripted_extender_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE (TCLN_ID);

ALTER TABLE SCRIPTED_TEST_CASE ADD PRIMARY KEY (TCLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-TEST_CASE_HIERARCHY_MODIFICATION', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 8, '9:c74f1ea4cb5782f3d541255150f38f0f', 'createTable tableName=KEYWORD_TEST_CASE; dropColumn columnName=SCRIPTED_TC_EXTENDER_ID, tableName=SCRIPTED_TC_EXTENDER; renameTable newTableName=SCRIPTED_TEST_CASE, oldTableName=SCRIPTED_TC_EXTENDER; dropForeignKeyConstraint baseTableName=SCRIPTED...', 'Create KEYWORD_TEST_CASE table. Update SCRIPTED_TC_EXTENDER table/column', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-update-tc-kind-column-prototype::jlor
--  In QueryColumnPrototype table, at TestCaseKind line, change data_type column value from Level_enum to Entity
update QUERY_COLUMN_PROTOTYPE set DATA_TYPE='ENTITY', COLUMN_TYPE='ENTITY' where QUERY_COLUMN_ID=184;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-update-tc-kind-column-prototype', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 9, '9:0a61b4c479ece519eee7f65b118a2feb', 'sql', 'In QueryColumnPrototype table, at TestCaseKind line, change data_type column value from Level_enum to Entity', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-drop-tc-kind-column::jlor
ALTER TABLE TEST_CASE DROP COLUMN TC_KIND;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-drop-tc-kind-column', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 10, '9:60629453425541d620f70bb91a1b99e8', 'dropColumn columnName=TC_KIND, tableName=TEST_CASE', '', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-drop-language-column-in-scripted-tc::jlor
--  LANGUAGE is no longer necessary for ScriptedTestCase, as it is always GHERKIN.
ALTER TABLE SCRIPTED_TEST_CASE DROP COLUMN LANGUAGE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-drop-language-column-in-scripted-tc', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 11, '9:d346ee208b4f61c931926dabf0d0396a', 'dropColumn columnName=LANGUAGE, tableName=SCRIPTED_TEST_CASE', 'LANGUAGE is no longer necessary for ScriptedTestCase, as it is always GHERKIN.', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-421-add-test-suite-uuid::aguilhem
ALTER TABLE TEST_SUITE ADD UUID VARCHAR(36) NULL;

ALTER TABLE TEST_SUITE ADD CONSTRAINT uc_test_suite_uuid UNIQUE (UUID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-421-add-test-suite-uuid', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 12, '9:e37baaf5af294fd04449392a9aff7dad', 'addColumn tableName=TEST_SUITE; addUniqueConstraint constraintName=uc_test_suite_uuid, tableName=TEST_SUITE', '', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-squash-421-update-test-suite-uuid-mysql::aguilhem
--  Created missing UUIDs on upgrade to add the not-null constraint.
UPDATE TEST_SUITE SET UUID = uuid() WHERE UUID is NULL;

ALTER TABLE TEST_SUITE MODIFY UUID VARCHAR(36) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-squash-421-update-test-suite-uuid-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 13, '9:fc3ed56768fcd95a60832e7a6759a405', 'sql', 'Created missing UUIDs on upgrade to add the not-null constraint.', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-325-EXECUTION_HIERARCHY_MODIFICATION::jlor
--  Create KEYWORD_EXECUTION table. Update SCRIPTED_EXECUTION_EXTENDER table/column.
ALTER TABLE SCRIPTED_EXECUTION_EXTENDER RENAME SCRIPTED_EXECUTION;

ALTER TABLE SCRIPTED_EXECUTION DROP COLUMN SCRIPTED_EXECUTION_EXTENDER_ID;

ALTER TABLE SCRIPTED_EXECUTION ADD PRIMARY KEY (EXECUTION_ID);

ALTER TABLE SCRIPTED_EXECUTION DROP COLUMN LANGUAGE;

CREATE TABLE KEYWORD_EXECUTION (EXECUTION_ID BIGINT NOT NULL, CONSTRAINT PK_KEYWORD_EXECUTION PRIMARY KEY (EXECUTION_ID), CONSTRAINT fk_keyword_exec_exec FOREIGN KEY (EXECUTION_ID) REFERENCES EXECUTION(EXECUTION_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-325-EXECUTION_HIERARCHY_MODIFICATION', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 14, '9:b1ef0ce7302559a5cbbeba997ec82e4e', 'renameTable newTableName=SCRIPTED_EXECUTION, oldTableName=SCRIPTED_EXECUTION_EXTENDER; dropColumn columnName=SCRIPTED_EXECUTION_EXTENDER_ID, tableName=SCRIPTED_EXECUTION; addPrimaryKey tableName=SCRIPTED_EXECUTION; dropColumn columnName=LANGUAGE, ...', 'Create KEYWORD_EXECUTION table. Update SCRIPTED_EXECUTION_EXTENDER table/column.', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-350-PARAMETER_IN_ACTION_WORD::qtran
--  Create ACTION_WORD_FRAGMENT table
--  Create new table for Action word text elements
--  Create new table for Action word parameter elements
--  Create new table for Action word parameter value
CREATE TABLE ACTION_WORD_FRAGMENT (ACTION_WORD_FRAGMENT_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key, auto-generated', ACTION_WORD_ID BIGINT NULL COMMENT 'Foreign key to the action word', FRAGMENT_ORDER INT NULL COMMENT 'the fragment order in action word fragment list', CONSTRAINT PK_ACTION_WORD_FRAGMENT PRIMARY KEY (ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_fragment_action_word_id FOREIGN KEY (ACTION_WORD_ID) REFERENCES ACTION_WORD(ACTION_WORD_ID)) COMMENT='base table for Action word fragments';

CREATE INDEX idx_fk_action_word_fragment_action_word_id ON ACTION_WORD_FRAGMENT(ACTION_WORD_ID);

ALTER TABLE ACTION_WORD_FRAGMENT ADD CONSTRAINT uc_action_word_fragment_order UNIQUE (ACTION_WORD_ID, FRAGMENT_ORDER);

CREATE TABLE ACTION_WORD_TEXT (ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL COMMENT 'Shared key with ACTION_WORD_FRAGMENT table', TEXT VARCHAR(255) NOT NULL COMMENT 'the content of the action word text', CONSTRAINT PK_ACTION_WORD_TEXT PRIMARY KEY (ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_text_action_word_fragment FOREIGN KEY (ACTION_WORD_FRAGMENT_ID) REFERENCES ACTION_WORD_FRAGMENT(ACTION_WORD_FRAGMENT_ID));

CREATE INDEX idx_fk_action_word_text_action_word_fragment ON ACTION_WORD_TEXT(ACTION_WORD_FRAGMENT_ID);

CREATE TABLE ACTION_WORD_PARAMETER (ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL COMMENT 'Shared key with ACTION_WORD_FRAGMENT table', NAME VARCHAR(255) NOT NULL COMMENT 'the name of the action word parameter', DEFAULT_VALUE VARCHAR(255) NOT NULL COMMENT 'the default value of the action word parameter', CONSTRAINT PK_ACTION_WORD_PARAMETER PRIMARY KEY (ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_parameter_action_word_fragment FOREIGN KEY (ACTION_WORD_FRAGMENT_ID) REFERENCES ACTION_WORD_FRAGMENT(ACTION_WORD_FRAGMENT_ID));

CREATE INDEX idx_fk_action_word_parameter_action_word_fragment ON ACTION_WORD_PARAMETER(ACTION_WORD_FRAGMENT_ID);

CREATE TABLE ACTION_WORD_PARAMETER_VALUE (ACTION_WORD_PARAMETER_VALUE_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'primary key, auto-generated', VALUE VARCHAR(255) NOT NULL COMMENT 'the value of the action word parameter value', ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL COMMENT 'the action word parameter by which this value replaces', KEYWORD_TEST_STEP_ID BIGINT NOT NULL COMMENT 'the keyword test step in which this value is used', CONSTRAINT PK_ACTION_WORD_PARAMETER_VALUE PRIMARY KEY (ACTION_WORD_PARAMETER_VALUE_ID), CONSTRAINT fk_action_word_parameter_value_action_word_fragment_id FOREIGN KEY (ACTION_WORD_FRAGMENT_ID) REFERENCES ACTION_WORD_PARAMETER(ACTION_WORD_FRAGMENT_ID), CONSTRAINT fk_action_word_parameter_value_keyword_test_step_id FOREIGN KEY (KEYWORD_TEST_STEP_ID) REFERENCES KEYWORD_TEST_STEP(TEST_STEP_ID));

CREATE INDEX idx_fk_action_word_parameter_value_action_word_fragment_id ON ACTION_WORD_PARAMETER_VALUE(ACTION_WORD_FRAGMENT_ID);

CREATE INDEX idx_fk_action_word_parameter_value_keyword_test_step_id ON ACTION_WORD_PARAMETER_VALUE(KEYWORD_TEST_STEP_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-350-PARAMETER_IN_ACTION_WORD', 'qtran', '../tm/tm.changelog-1.22.0.xml', NOW(), 15, '9:4f8c5e980692b63d79c357bc710f80dc', 'createTable tableName=ACTION_WORD_FRAGMENT; createIndex indexName=idx_fk_action_word_fragment_action_word_id, tableName=ACTION_WORD_FRAGMENT; addUniqueConstraint constraintName=uc_action_word_fragment_order, tableName=ACTION_WORD_FRAGMENT; createT...', 'Create ACTION_WORD_FRAGMENT table
Create new table for Action word text elements
Create new table for Action word parameter elements
Create new table for Action word parameter value', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-302-action-word-workspace::jlor
--  Create action word library table
--  Insert corresponding entries in ACL tables
--  Add foreign key to the library in a project
--  Create one action word library for each existing project
CREATE TABLE ACTION_WORD_LIBRARY (AWL_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id', ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'Foreign key to ATTACHMENT_LIST', CONSTRAINT PK_ACTION_WORD_LIBRARY PRIMARY KEY (AWL_ID), CONSTRAINT fk_awLib_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID));

CREATE INDEX idx_action_word_library ON ACTION_WORD_LIBRARY(AWL_ID);

CREATE INDEX idx_fk_awl_attachment_list ON ACTION_WORD_LIBRARY(ATTACHMENT_LIST_ID);

insert into ACL_CLASS(ID, CLASSNAME)
      values(8, 'org.squashtest.tm.domain.actionword.ActionWordLibrary');

insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      select AGP2.ACL_GROUP_ID, AGP2.PERMISSION_MASK, 8
      from ACL_GROUP_PERMISSION AGP2
      where CLASS_ID = 3;

ALTER TABLE PROJECT ADD AWL_ID BIGINT NULL;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_awl FOREIGN KEY (AWL_ID) REFERENCES ACTION_WORD_LIBRARY (AWL_ID);

CREATE INDEX idx_fk_project_awl ON PROJECT(AWL_ID);

-- Create the libraries --

      insert into ACTION_WORD_LIBRARY (AWL_ID)
        select p.PROJECT_ID
        from PROJECT p;

-- Attachments, Step 1 --
      -- Create a ranking table, akin to what would ROW_NUMBER() order by id desc would say --

      create table AWL_RANK as
        select awl.awl_id,
               count(awl2.awl_id) as ranking
        from ACTION_WORD_LIBRARY awl,
             ACTION_WORD_LIBRARY awl2
        where awl.awl_id <= awl2.awl_id
        group by awl.awl_id
        order by ranking asc;

-- Attachments, Step 2 --
      -- Create a table that pairs library ids with predictable, consecutive attachment_list_ids using the rank
      -- calculated earlier --

      create table AWL_ATTACHMENT_LIST_PAIRING as
        select awl_rank.awl_id,
               (select max(al.attachment_list_id) from ATTACHMENT_LIST al) + awl_rank.ranking as attachment_list_id
        from AWL_RANK awl_rank;

-- Attachments, Step 3 --
      -- Insert the attachment lists and update fk in the action word library --

      insert into ATTACHMENT_LIST(ATTACHMENT_LIST_ID)
        select pair.attachment_list_id
        from AWL_ATTACHMENT_LIST_PAIRING pair;

update ACTION_WORD_LIBRARY awl
      set ATTACHMENT_LIST_ID = (select pair.attachment_list_id
                                from AWL_ATTACHMENT_LIST_PAIRING pair
                                where pair.awl_id = awl.awl_id);

-- Attachments, Step 4 and final --
      -- Drop the temporary tables --

      drop table AWL_ATTACHMENT_LIST_PAIRING;

drop table AWL_RANK;

-- Bind the project to the AWL library --

      update PROJECT P
      set AWL_ID = PROJECT_ID;

-- Insert the acl object identities --

      insert into ACL_OBJECT_IDENTITY(IDENTITY, CLASS_ID)
        select awl.awl_id, 8 from ACTION_WORD_LIBRARY awl;

-- Add the user/team permissions in ACL_RESPONSIBILITY_SCOPE_ENTRY
      -- Each user will receive the same acl_group on each action word library than on the project it depends on
      -- (this last sentence is the idea behind the auto join on acl_object_identity in this query) --

      insert into ACL_RESPONSIBILITY_SCOPE_ENTRY(party_id, acl_group_id, object_identity_id)
        select distinct arse.party_id, arse.acl_group_id, awl_oid.id
        from ACL_RESPONSIBILITY_SCOPE_ENTRY arse
        inner join ACL_OBJECT_IDENTITY oid on (arse.object_identity_id = oid.id and oid.class_id = 1)
        inner join ACL_OBJECT_IDENTITY awl_oid on (oid.identity = awl_oid.identity and awl_oid.class_id = 8);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-302-action-word-workspace', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 16, '9:b0ef866f18cd3f9ae90111b476d0a2eb', 'createTable tableName=ACTION_WORD_LIBRARY; createIndex indexName=idx_action_word_library, tableName=ACTION_WORD_LIBRARY; createIndex indexName=idx_fk_awl_attachment_list, tableName=ACTION_WORD_LIBRARY; sql; addColumn tableName=PROJECT; createIndex...', 'Create action word library table
Insert corresponding entries in ACL tables
Add foreign key to the library in a project
Create one action word library for each existing project', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-302-action-word-workspace-2::jlor
--  Create action word library node table
--  Create one action word library node for each library created
--  Create action word library node relationship table
CREATE TABLE ACTION_WORD_LIBRARY_NODE (AWLN_ID BIGINT AUTO_INCREMENT NOT NULL COMMENT 'The auto-generated id', NAME VARCHAR(255) NULL, ENTITY_TYPE VARCHAR(50) NULL, ENTITY_ID BIGINT NULL, AWL_ID BIGINT NULL COMMENT 'Foreign key to the ACTION_WORD_LIBRARY', CONSTRAINT PK_ACTION_WORD_LIBRARY_NODE PRIMARY KEY (AWLN_ID), CONSTRAINT fk_awln_awl FOREIGN KEY (AWL_ID) REFERENCES ACTION_WORD_LIBRARY(AWL_ID));

CREATE INDEX idx_action_word_library_node ON ACTION_WORD_LIBRARY_NODE(AWLN_ID);

CREATE INDEX idx_fk_awln_awl ON ACTION_WORD_LIBRARY_NODE(AWL_ID);

insert into ACTION_WORD_LIBRARY_NODE (AWL_ID, ENTITY_ID, ENTITY_TYPE)
      select AWL_ID, AWL_ID, 'LIBRARY'
      from ACTION_WORD_LIBRARY;

update ACTION_WORD_LIBRARY_NODE
      set NAME = (select p.NAME from PROJECT p where ENTITY_ID = p.AWL_ID)
      where ENTITY_TYPE = 'LIBRARY';

CREATE TABLE AWLN_RELATIONSHIP (ANCESTOR_ID BIGINT NULL COMMENT 'Foreign key to parent node', DESCENDANT_ID BIGINT NOT NULL COMMENT 'Foreign key to child node', CONTENT_ORDER BIGINT NULL COMMENT 'Order in its parent node', CONSTRAINT fk_awln_relationship_descendant FOREIGN KEY (DESCENDANT_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID), CONSTRAINT fk_awln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID));

CREATE INDEX idx_awln_relationship_descendant ON AWLN_RELATIONSHIP(DESCENDANT_ID);

CREATE INDEX idx_awln_relationship_ancestor ON AWLN_RELATIONSHIP(ANCESTOR_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-302-action-word-workspace-2', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 17, '9:7b54cc30b5adc8b31ddd261641fd745b', 'createTable tableName=ACTION_WORD_LIBRARY_NODE; createIndex indexName=idx_action_word_library_node, tableName=ACTION_WORD_LIBRARY_NODE; createIndex indexName=idx_fk_awln_awl, tableName=ACTION_WORD_LIBRARY_NODE; sql; createTable tableName=AWLN_RELA...', 'Create action word library node table
Create one action word library node for each library created
Create action word library node relationship table', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-794-auditable-automated-suite::aguilhem
--  Make Automated Suite auditable
ALTER TABLE AUTOMATED_SUITE ADD CREATED_BY VARCHAR(50) NULL;

ALTER TABLE AUTOMATED_SUITE ADD CREATED_ON datetime NULL;

ALTER TABLE AUTOMATED_SUITE ADD LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL;

ALTER TABLE AUTOMATED_SUITE ADD LAST_MODIFIED_ON datetime DEFAULT null NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-794-auditable-automated-suite', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 18, '9:23dab011667ac08bdb3e28e83ee0354a', 'addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE', 'Make Automated Suite auditable', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-794-automated-suite-migration-mysql::aguilhem
--  Add audit data on automated suite for mysql
UPDATE AUTOMATED_SUITE asuite
      INNER JOIN (
        select ex.CREATED_ON, ex.CREATED_BY, ex.LAST_MODIFIED_BY, ex.LAST_MODIFIED_ON, ext.SUITE_ID
        from AUTOMATED_EXECUTION_EXTENDER ext
        inner join EXECUTION ex on ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
        order by ex.LAST_MODIFIED_ON desc
      ) AS exec
      ON exec.SUITE_ID = asuite.SUITE_ID
      SET asuite.CREATED_ON = exec.CREATED_ON,
          asuite.CREATED_BY = exec.CREATED_BY,
          asuite.LAST_MODIFIED_BY = exec.LAST_MODIFIED_BY,
          asuite.LAST_MODIFIED_ON = exec.LAST_MODIFIED_ON;

UPDATE AUTOMATED_SUITE
      SET CREATED_ON = '2000-01-01 00:00:00.0',
      CREATED_BY = 'admin'
      WHERE CREATED_ON IS NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_ON DATETIME NOT NULL;

ALTER TABLE AUTOMATED_SUITE MODIFY CREATED_BY VARCHAR(50) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-794-automated-suite-migration-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 19, '9:6c121dbf8dfe1e4b03e6a9666a5d2ffd', 'sql', 'Add audit data on automated suite for mysql', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-795::aguilhem
--  Adds a execution status field to the automated suites
ALTER TABLE AUTOMATED_SUITE ADD EXECUTION_STATUS VARCHAR(255) DEFAULT 'READY' NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-795', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 20, '9:e8637fb1882720c67d0cbeedf22a3d4d', 'addColumn tableName=AUTOMATED_SUITE', 'Adds a execution status field to the automated suites', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-795-migration-mysql::aguilhem
--  Compute preexisting automated suites status for mysql
UPDATE AUTOMATED_SUITE asuite
      INNER JOIN
      (
        SELECT automated_suite.SUITE_ID,
              blocked_count.counter as blocked_count,
              untestable_count.counter as untestable_count,
              settled_count.counter as settled_count,
              failure_count.counter as failure_count,
              success_count.counter as success_count,
              running_count.counter as running_count,
              total_count.counter as total_count
        FROM AUTOMATED_SUITE as automated_suite
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('BLOCKED', 'ERROR', 'NOT_RUN')
          GROUP BY ext.SUITE_ID) as blocked_count
        ON automated_suite.SUITE_ID = blocked_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('UNTESTABLE', 'NOT_FOUND')
          GROUP BY ext.SUITE_ID) as untestable_count
        ON automated_suite.SUITE_ID = untestable_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('SETTLED', 'UNTESTABLE', 'NOT_FOUND')
          GROUP BY ext.SUITE_ID) as settled_count
        ON automated_suite.SUITE_ID = settled_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS = 'FAILURE'
          GROUP BY ext.SUITE_ID) as failure_count
        ON automated_suite.SUITE_ID = failure_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('SUCCESS', 'UNTESTABLE', 'SETTLED', 'NOT_FOUND', 'WARNING')
          GROUP BY ext.SUITE_ID) as success_count
        ON automated_suite.SUITE_ID = success_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          AND ex.EXECUTION_STATUS IN ('SUCCESS', 'UNTESTABLE', 'SETTLED', 'NOT_FOUND', 'WARNING')
          GROUP BY ext.SUITE_ID) as running_count
        ON automated_suite.SUITE_ID = running_count.SUITE_ID
        LEFT JOIN
          (SELECT ext.SUITE_ID, count(ext.SUITE_ID) as counter
          FROM AUTOMATED_EXECUTION_EXTENDER ext
          INNER JOIN EXECUTION ex ON ext.MASTER_EXECUTION_ID = ex.EXECUTION_ID
          GROUP BY ext.SUITE_ID) as total_count
          ON automated_suite.SUITE_ID = total_count.SUITE_ID
      ) as count_table
      ON asuite.SUITE_ID = count_table.SUITE_ID
      SET asuite.EXECUTION_STATUS = (
        CASE
          WHEN (count_table.blocked_count IS NOT NULL AND count_table.blocked_count > 0) THEN 'BLOCKED'
          WHEN (count_table.untestable_count IS NOT NULL AND count_table.untestable_count = count_table.total_count) THEN 'UNTESTABLE'
          WHEN (count_table.settled_count IS NOT NULL AND count_table.settled_count = count_table.total_count) THEN 'SETTLED'
          WHEN (count_table.failure_count IS NOT NULL AND count_table.failure_count > 0) THEN 'FAILURE'
          WHEN (count_table.success_count IS NOT NULL AND count_table.success_count = count_table.total_count) THEN 'SUCCESS'
          WHEN (count_table.running_count IS NOT NULL AND count_table.running_count > 0) THEN 'RUNNING'
          ELSE 'READY'
        END
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-795-migration-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 21, '9:17bd1b18dd6972a75fb675f52141ac1a', 'sql', 'Compute preexisting automated suites status for mysql', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-896-add-indexes-for-search-sort-columns::jprioux
--  add indexes on default search sort columns
CREATE INDEX idx_project_name ON PROJECT(NAME);

CREATE INDEX idx_tc_reference ON TEST_CASE(`REFERENCE`);

CREATE INDEX idx_tc_importance ON TEST_CASE(IMPORTANCE);

CREATE INDEX idx_req_reference ON REQUIREMENT_VERSION(`REFERENCE`);

CREATE INDEX idx_req_status ON REQUIREMENT_VERSION(REQUIREMENT_STATUS);

CREATE INDEX idx_req_criticality ON REQUIREMENT_VERSION(CRITICALITY);

CREATE INDEX idx_iteration_name ON ITERATION(NAME);

CREATE INDEX idx_cln_name ON CAMPAIGN_LIBRARY_NODE(NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-896-add-indexes-for-search-sort-columns', 'jprioux', '../tm/tm.changelog-1.22.0.xml', NOW(), 22, '9:0a62011558dba9e39f86647cc88d72d7', 'createIndex indexName=idx_project_name, tableName=PROJECT; createIndex indexName=idx_tc_reference, tableName=TEST_CASE; createIndex indexName=idx_tc_importance, tableName=TEST_CASE; createIndex indexName=idx_req_reference, tableName=REQUIREMENT_VE...', 'add indexes on default search sort columns', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-891::aguilhem
--  Automated Suite can be directly linked to an iteration or a test suite
ALTER TABLE AUTOMATED_SUITE ADD ITERATION_ID BIGINT NULL, ADD TEST_SUITE_ID BIGINT NULL;

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT fk_automated_suite_iteration FOREIGN KEY (ITERATION_ID) REFERENCES ITERATION (ITERATION_ID);

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT fk_automated_suite_test_suite FOREIGN KEY (TEST_SUITE_ID) REFERENCES TEST_SUITE (ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-891', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 23, '9:e47b600027d3bad2d5e8e68aaee2b38b', 'addColumn tableName=AUTOMATED_SUITE', 'Automated Suite can be directly linked to an iteration or a test suite', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-291-bdd-impl-techno-and-language::jlor
ALTER TABLE PROJECT ADD BDD_IMPLEMENTATION_TECHNOLOGY VARCHAR(30) DEFAULT 'CUCUMBER' NOT NULL, ADD BDD_SCRIPT_LANGUAGE VARCHAR(30) DEFAULT 'ENGLISH' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-291-bdd-impl-techno-and-language', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 24, '9:9af863d1c2318872e6c8ca4642b5d0aa', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-306-create-closure-table::mqtran
--  closure table for action word library nodes. Its content is set and modified by 4 triggers
CREATE TABLE AWLN_RELATIONSHIP_CLOSURE (ANCESTOR_ID BIGINT NOT NULL COMMENT 'cle etrangere vers le noeud parent. La relation est parfois d''un noeud vers lui meme.', DESCENDANT_ID BIGINT NOT NULL COMMENT 'cle etrangere vers l''element fils. La relation est parfois d''un noeud vers lui meme.', DEPTH SMALLINT NOT NULL COMMENT 'stores how deep is the descendant element nested in the subtree of the ancestor element', CONSTRAINT fk_awln_relationship_clos_anc FOREIGN KEY (ANCESTOR_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID), CONSTRAINT fk_awln_relationship_clos_desc FOREIGN KEY (DESCENDANT_ID) REFERENCES ACTION_WORD_LIBRARY_NODE(AWLN_ID));

CREATE INDEX idx_awln_relationship_clos_desc ON AWLN_RELATIONSHIP_CLOSURE(DESCENDANT_ID);

CREATE INDEX idx_awln_relationship_clos_anc ON AWLN_RELATIONSHIP_CLOSURE(ANCESTOR_ID);

ALTER TABLE AWLN_RELATIONSHIP_CLOSURE ADD UNIQUE (ANCESTOR_ID, DESCENDANT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-306-create-closure-table', 'mqtran', '../tm/tm.changelog-1.22.0.xml', NOW(), 25, '9:c8a1f183bcab1b0930b08faf6dc6171e', 'createTable tableName=AWLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_awln_relationship_clos_desc, tableName=AWLN_RELATIONSHIP_CLOSURE; createIndex indexName=idx_awln_relationship_clos_anc, tableName=AWLN_RELATIONSHIP_CLOSURE; addUniqueConstr...', 'closure table for action word library nodes. Its content is set and modified by 4 triggers', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-306-closure-mysql-trigger::mqtran
--  mysql-triggers for AWLN_RELATIONSHIP_CLOSURE table
create trigger ins_awln_after after insert on
      ACTION_WORD_LIBRARY_NODE
      for each row insert ignore into
      AWLN_RELATIONSHIP_CLOSURE values (new.awln_id, new.awln_id, 0);

create trigger del_awln_before before delete on
      ACTION_WORD_LIBRARY_NODE
      for each row delete from
      AWLN_RELATIONSHIP_CLOSURE where ancestor_id=old.awln_id and
      descendant_id=old.awln_id;

create trigger attach_awln_after after insert on AWLN_RELATIONSHIP
      for each row insert ignore into AWLN_RELATIONSHIP_CLOSURE
      select
      c1.ancestor_id, c2.descendant_id, c1.depth+c2.depth+1
      from
      AWLN_RELATIONSHIP_CLOSURE c1
      cross join AWLN_RELATIONSHIP_CLOSURE c2
      where c1.descendant_id = new.ancestor_id
      and c2.ancestor_id = new.descendant_id;

create trigger detach_awln_before before delete on
      AWLN_RELATIONSHIP
      for each row delete clos1 from
      AWLN_RELATIONSHIP_CLOSURE clos1
      join AWLN_RELATIONSHIP_CLOSURE clos2
      on
      clos1.descendant_id=clos2.descendant_id
      left join
      AWLN_RELATIONSHIP_CLOSURE clos3
      on clos3.ancestor_id = clos2.ancestor_id
      and clos3.descendant_id = clos1.ancestor_id
      where
      clos2.ancestor_id = old.descendant_id
      and clos3.ancestor_id is null;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-306-closure-mysql-trigger', 'mqtran', '../tm/tm.changelog-1.22.0.xml', NOW(), 26, '9:05e375ec603a283f66935786b876a0e9', 'sql; sql; sql; sql', 'mysql-triggers for AWLN_RELATIONSHIP_CLOSURE table', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1107-aw-last-impl-techno-and-date::jlor
ALTER TABLE ACTION_WORD ADD LAST_IMPLEMENTATION_TECHNOLOGY VARCHAR(30) NULL COMMENT 'Technology used for last implementation' , ADD LAST_IMPLEMENTATION_DATE datetime NULL COMMENT 'Date of last implementation';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1107-aw-last-impl-techno-and-date', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 27, '9:d6596859ec8dbd5a07799c47358dbd1e', 'addColumn tableName=ACTION_WORD', '', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1284-migration-mysql::qtran
--  Remove all CUF values and CUF value options attaching to any deleted Test Case folder for postgresql
--  Remove all CUF values and CUF value options attaching to any deleted Campaign folder for postgresql
--  Remove all CUF values and CUF value options attaching to any deleted Requirement folder for postgresql
DELETE FROM CUSTOM_FIELD_VALUE_OPTION
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID FROM CUSTOM_FIELD_VALUE cfv
        LEFT JOIN TEST_CASE_FOLDER tcf
        ON cfv.BOUND_ENTITY_ID = tcf.TCLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'TESTCASE_FOLDER'
        AND tcf.TCLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID
        FROM (SELECT * FROM CUSTOM_FIELD_VALUE WHERE BOUND_ENTITY_TYPE = 'TESTCASE_FOLDER') AS cfv
        LEFT JOIN TEST_CASE_FOLDER tcf
        ON cfv.BOUND_ENTITY_ID = tcf.TCLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'TESTCASE_FOLDER'
        AND tcf.TCLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE_OPTION
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID FROM CUSTOM_FIELD_VALUE cfv
        LEFT JOIN CAMPAIGN_FOLDER cf
        ON cfv.BOUND_ENTITY_ID = cf.CLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'CAMPAIGN_FOLDER'
        AND cf.CLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID
        FROM (SELECT * FROM CUSTOM_FIELD_VALUE WHERE BOUND_ENTITY_TYPE = 'CAMPAIGN_FOLDER') AS cfv
        LEFT JOIN CAMPAIGN_FOLDER cf
        ON cfv.BOUND_ENTITY_ID = cf.CLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'CAMPAIGN_FOLDER'
        AND cf.CLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE_OPTION
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID FROM CUSTOM_FIELD_VALUE cfv
        LEFT JOIN REQUIREMENT_FOLDER rf
        ON cfv.BOUND_ENTITY_ID = rf.RLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'REQUIREMENT_FOLDER'
        AND rf.RLN_ID is null
      );

DELETE FROM CUSTOM_FIELD_VALUE
      WHERE CFV_ID in (
        SELECT cfv.CFV_ID
        FROM (SELECT * FROM CUSTOM_FIELD_VALUE WHERE BOUND_ENTITY_TYPE = 'REQUIREMENT_FOLDER') AS cfv
        LEFT JOIN REQUIREMENT_FOLDER rf
        ON cfv.BOUND_ENTITY_ID = rf.RLN_ID
        WHERE cfv.BOUND_ENTITY_TYPE = 'REQUIREMENT_FOLDER'
        AND rf.RLN_ID is null
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1284-migration-mysql', 'qtran', '../tm/tm.changelog-1.22.0.xml', NOW(), 28, '9:61e7b87a4a9ceb4bc5624c53b3824806', 'sql; sql; sql', 'Remove all CUF values and CUF value options attaching to any deleted Test Case folder for postgresql
Remove all CUF values and CUF value options attaching to any deleted Campaign folder for postgresql
Remove all CUF values and CUF value options at...', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1466-test-case-source-code-repository-url::akatz
ALTER TABLE TEST_CASE ADD SOURCE_CODE_REPOSITORY_URL VARCHAR(255) NULL COMMENT 'The url of the source code repository where the test lies' , ADD AUTOMATED_TEST_REFERENCE VARCHAR(255) NULL COMMENT 'The path to the test';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1466-test-case-source-code-repository-url', 'akatz', '../tm/tm.changelog-1.22.0.xml', NOW(), 29, '9:c22999d8ab6fd07c51128cf90f880479', 'addColumn tableName=TEST_CASE', '', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-1::aguilhem
--  Preparation for data migration
CREATE TABLE MIG_SQUASH_1975 (OLD_ID BIGINT NOT NULL, NEW_ID BIGINT NULL, CONSTRAINT PK_MIG_SQUASH_1975 PRIMARY KEY (OLD_ID));

ALTER TABLE TEST_AUTOMATION_PROJECT DROP FOREIGN KEY fk_ta_project_ta_server;

ALTER TABLE PROJECT DROP FOREIGN KEY tm_project_ta_server;

INSERT INTO MIG_SQUASH_1975 (OLD_ID, NEW_ID)
      SELECT TEST_AUTOMATION_SERVER.SERVER_ID, coalesce(max(THIRD_PARTY_SERVER.SERVER_ID),0) + TAS.TAS_MAX_ID + TEST_AUTOMATION_SERVER.SERVER_ID as NEW_ID
      FROM TEST_AUTOMATION_SERVER
      LEFT JOIN THIRD_PARTY_SERVER ON 1=1
      LEFT JOIN (SELECT coalesce(max(TEST_AUTOMATION_SERVER.SERVER_ID),0) AS TAS_MAX_ID FROM TEST_AUTOMATION_SERVER) AS TAS ON  1 = 1
      GROUP BY TEST_AUTOMATION_SERVER.SERVER_ID, TAS.TAS_MAX_ID
      ORDER BY TEST_AUTOMATION_SERVER.SERVER_ID;

INSERT INTO THIRD_PARTY_SERVER (SERVER_ID, NAME, URL, AUTH_POLICY, AUTH_PROTOCOL)
      SELECT MIG_SQUASH_1975.NEW_ID, TEST_AUTOMATION_SERVER.NAME, TEST_AUTOMATION_SERVER.BASE_URL, 'APP_LEVEL', 'BASIC_AUTH'
      FROM TEST_AUTOMATION_SERVER
      INNER JOIN MIG_SQUASH_1975 on MIG_SQUASH_1975.OLD_ID = TEST_AUTOMATION_SERVER.SERVER_ID
      ORDER BY TEST_AUTOMATION_SERVER.SERVER_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-1', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 30, '9:b4b8614f8ac2b2f5721e1dee34e9c66d', 'createTable tableName=MIG_SQUASH_1975; dropForeignKeyConstraint baseTableName=TEST_AUTOMATION_PROJECT, constraintName=fk_ta_project_ta_server; dropForeignKeyConstraint baseTableName=PROJECT, constraintName=tm_project_ta_server; sql', 'Preparation for data migration', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-2-mysql::aguilhem
--  Transform Test Automation Server to Third Party Server
UPDATE TEST_AUTOMATION_SERVER ta_server
      INNER JOIN MIG_SQUASH_1975 mig
      ON ta_server.SERVER_ID = mig.OLD_ID
      SET ta_server.SERVER_ID = mig.NEW_ID;

UPDATE TEST_AUTOMATION_PROJECT ta_proj
      INNER JOIN MIG_SQUASH_1975 mig
      ON ta_proj.SERVER_ID = mig.OLD_ID
      SET ta_proj.SERVER_ID = mig.NEW_ID;

UPDATE PROJECT proj
      INNER JOIN MIG_SQUASH_1975 mig
      ON proj.TA_SERVER_ID = mig.OLD_ID
      SET proj.TA_SERVER_ID = mig.NEW_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-2-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 31, '9:6dc28b899d4f6a5d81f974af22f0f6a2', 'sql', 'Transform Test Automation Server to Third Party Server', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-3::aguilhem
--  Finalisation of test automation server data migration
ALTER TABLE TEST_AUTOMATION_SERVER DROP KEY UNI_AUTOTEST_SERVER;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN NAME;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN BASE_URL;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN LOGIN;

ALTER TABLE TEST_AUTOMATION_SERVER DROP COLUMN PASSWORD;

ALTER TABLE TEST_AUTOMATION_PROJECT ADD CONSTRAINT fk_ta_project_ta_server FOREIGN KEY (SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER (SERVER_ID);

ALTER TABLE PROJECT ADD CONSTRAINT tm_project_ta_server FOREIGN KEY (TA_SERVER_ID) REFERENCES TEST_AUTOMATION_SERVER (SERVER_ID);

ALTER TABLE TEST_AUTOMATION_SERVER ADD CONSTRAINT fk_test_automation_server_third_party_server FOREIGN KEY (SERVER_ID) REFERENCES THIRD_PARTY_SERVER (SERVER_ID) ON DELETE CASCADE;

DROP TABLE MIG_SQUASH_1975;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-3', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 32, '9:3b5f5a4908971f92e106ae687a5bfa63', 'dropUniqueConstraint constraintName=UNI_AUTOTEST_SERVER, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=NAME, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=BASE_URL, tableName=TEST_AUTOMATION_SERVER; dropColumn columnName=LOGIN,...', 'Finalisation of test automation server data migration', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-1975-automation-server-migration-4-mysql::aguilhem
--  For Mysql / Maria DB, remove the autoincrement on server_id
set foreign_key_checks=0;

alter table TEST_AUTOMATION_SERVER modify column SERVER_ID BIGINT not null;

set foreign_key_checks=1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-1975-automation-server-migration-4-mysql', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 33, '9:07d1f7b65ab7ef317fe9bb7975e10f00', 'sql', 'For Mysql / Maria DB, remove the autoincrement on server_id', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-808-automated-suites-lifetime::jlor
ALTER TABLE PROJECT ADD AUTOMATED_SUITES_LIFETIME INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-808-automated-suites-lifetime', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 34, '9:0c792660b2692e6ffb971acc8b3f027c', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2032-fix-null-description-in-requirement::jlor
--  Replace null descriptions by empty strings in requirements
update RESOURCE
      set DESCRIPTION = ''
      where DESCRIPTION is NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2032-fix-null-description-in-requirement', 'jlor', '../tm/tm.changelog-1.22.0.xml', NOW(), 35, '9:7f22d4b69a71e66d14f2ef65164c2e19', 'sql', 'Replace null descriptions by empty strings in requirements', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2106-automated-suite-attachment::aguilhem
--  Give possibility to AUTOMATED_SUITE to have ATTACHMENT
ALTER TABLE AUTOMATED_SUITE ADD ATTACHMENT_LIST_ID BIGINT NULL COMMENT 'foreign key to ATTACHMENT_LIST, entity dealing with attachment.';

ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT fk_automated_suite_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST (ATTACHMENT_LIST_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2106-automated-suite-attachment', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 36, '9:04cd31e9b2ee57a4c5385586090abecd', 'addColumn tableName=AUTOMATED_SUITE', 'Give possibility to AUTOMATED_SUITE to have ATTACHMENT', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2106-automated-suite-attachment-2::aguilhem
--  Create one attachment list for each automated suite
-- attachments, step 1 :
      -- create a ranking table, akin to what would ROW_NUMBER() order by id desc would say

      create table ASUITE_RANK as
      select asuite.suite_id, count(asuite2.suite_id)  as ranking
      from AUTOMATED_SUITE asuite,
      AUTOMATED_SUITE asuite2
      where asuite.suite_id <= asuite2.suite_id
      group by asuite.suite_id
      order by ranking asc;

-- attachments, step 2 :
      -- create a table that pairs suite ids with predictable, consecutive attachment_list_ids using the rank
      -- calculated earlier

      create table ASUITE_ATTACHLIST_PAIRING as
      select asuite.suite_id, (select max(al.attachment_list_id) from ATTACHMENT_LIST al) + asuite.ranking as attachment_list_id
      from ASUITE_RANK asuite;

-- attachments, step 3 :
      -- insert the attachment lists and update fk in the automated suite
      insert into ATTACHMENT_LIST(ATTACHMENT_LIST_ID)
      select pair.attachment_list_id from ASUITE_ATTACHLIST_PAIRING pair;

update AUTOMATED_SUITE asuite
      set ATTACHMENT_LIST_ID = (select pair.attachment_list_id from ASUITE_ATTACHLIST_PAIRING pair where pair.suite_id = asuite.suite_id);

-- attachments, step 4 and final :
      -- drop the temporary tables

      drop table ASUITE_ATTACHLIST_PAIRING;

drop table ASUITE_RANK;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2106-automated-suite-attachment-2', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 37, '9:5bd93cdfb5ffd894252d494c596ba469', 'sql', 'Create one attachment list for each automated suite', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0-SQUASH-2141-automated-test-technology::aguilhem
--  create automated test technology table
CREATE TABLE AUTOMATED_TEST_TECHNOLOGY (AT_TECHNOLOGY_ID BIGINT AUTO_INCREMENT NOT NULL, NAME VARCHAR(50) NOT NULL, ACTION_PROVIDER_KEY VARCHAR(50) NOT NULL, CONSTRAINT PK_AUTOMATED_TEST_TECHNOLOGY PRIMARY KEY (AT_TECHNOLOGY_ID));

insert into AUTOMATED_TEST_TECHNOLOGY(NAME, ACTION_PROVIDER_KEY)
      values ('Robot Framework', 'robotframework/execute@v1'),
      ('Cypress', 'cypress/execute@v1'),
      ('JUnit', 'junit/execute@v1'),
      ('Cucumber', 'cucumber/execute@v1');

ALTER TABLE TEST_CASE ADD AUTOMATED_TEST_TECHNOLOGY BIGINT NULL COMMENT 'foreign key to AUTOMATED_TEST_TECHNOLOGY';

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_test_case_automated_test_technology FOREIGN KEY (AUTOMATED_TEST_TECHNOLOGY) REFERENCES AUTOMATED_TEST_TECHNOLOGY (AT_TECHNOLOGY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0-SQUASH-2141-automated-test-technology', 'aguilhem', '../tm/tm.changelog-1.22.0.xml', NOW(), 38, '9:22ffb3b6f7fbadb09405d72bec44e566', 'createTable tableName=AUTOMATED_TEST_TECHNOLOGY; sql; addColumn tableName=TEST_CASE', 'create automated test technology table', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Changeset ../tm/tm.changelog-1.22.0.xml::tm-1.22.0.SQUASH-1596-autocnnect-on-connection-config::jprioux
--  add system parameter for autoconnect on connection configuration
INSERT INTO CORE_CONFIG (STR_KEY, VALUE) VALUES ('autoconnect.on.connection.enabled', 'false');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.0.SQUASH-1596-autocnnect-on-connection-config', 'jprioux', '../tm/tm.changelog-1.22.0.xml', NOW(), 39, '9:37718dded95a240c958e0544b44fc3d8', 'insert tableName=CORE_CONFIG', 'add system parameter for autoconnect on connection configuration', 'EXECUTED', NULL, NULL, '4.31.1', '3648671888');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

