@REM
@REM     This file is part of the Squashtest platform.
@REM     Copyright (C) Henix, henix.fr
@REM
@REM     See the NOTICE file distributed with this work for additional
@REM     information regarding copyright ownership.
@REM
@REM     This is free software: you can redistribute it and/or modify
@REM     it under the terms of the GNU Lesser General Public License as published by
@REM     the Free Software Foundation, either version 3 of the License, or
@REM     (at your option) any later version.
@REM
@REM     this software is distributed in the hope that it will be useful,
@REM     but WITHOUT ANY WARRANTY; without even the implied warranty of
@REM     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
@REM     GNU Lesser General Public License for more details.
@REM
@REM     You should have received a copy of the GNU Lesser General Public License
@REM     along with this software.  If not, see <http://www.gnu.org/licenses/>.
@REM

@echo off

IF "%SQUASH_TM_HOME%" == "" set SQUASH_TM_HOME=..

REM Default variables
set JAR_NAME=%SQUASH_TM_HOME%/bundles/squash-tm.war
REM Set directory variables
set TMP_DIR=%SQUASH_TM_HOME%\tmp
IF NOT EXIST %TMP_DIR% MKDIR %TMP_DIR%
set CONF_DIR=%SQUASH_TM_HOME%/conf
set LOG_DIR=%SQUASH_TM_HOME%\logs
IF NOT EXIST %LOG_DIR% MKDIR %LOG_DIR%\service
REM Extra Java args
set JAVA_ARGS=-Xms128m -Xmx2048m

REM Only indicate the major version, do not indicate a minor version
SET JAVA_REQUIRED_VERSION=21

REM Test if java exists
echo  checking java environment...
java -version >nul 2>&1
if %ERRORLEVEL% NEQ 0 (
    echo.
    echo %0 : Error : Java not found. Please ensure that Java is installed and in the PATH.
    exit /b -1
)
echo Done.

rem Test if the version is high enough
echo Checking version...

for /f "tokens=3 delims= " %%v in ('java -version 2^>^&1 ^| findstr "version"') do (
    for /f "tokens=1 delims=." %%a in ("%%~v") do set "JAVA_VERSION=%%a"
)

if %JAVA_VERSION% LSS %JAVA_REQUIRED_VERSION% (
    echo Error : Your JRE does not meet the requirements.
    echo Required version: %JAVA_REQUIRED_VERSION%.
    exit /b -1
)

set ARGS=%JAVA_ARGS% -Duser.language=en %JAVA_TOOL_OPTIONS% -Djava.io.tmpdir=%TMP_DIR% -Dlogging.dir=%LOG_DIR% %SQUASH_JAVA_ARGS% -jar %JAR_NAME% --spring.config.additional-location=file:%CONF_DIR%/ --spring.config.name=application,squash.tm.cfg --logging.config=%CONF_DIR%/log4j2.xml

REM Start java process
echo Cleaning temporary files...
FOR /D %%d IN (%TMP_DIR%\*) DO @rmdir /S /Q %%d
DEL /S /Q %TMP_DIR%\*

echo Starting Squash TM...
java %ARGS%

