/*
 *     This file is part of the Jira Automation Workflow for Squash TM (automation-workflow-automjira) project.
 *     Copyright (C) 2019 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
require(['common'], function () {
    require(["jquery", "app/pubsub", "app/ws/squashtm.notification", "underscore", "squash.configmanager",
                "squash.basicwidgets", "squash.translator", "app/util/PathUtils",  "app/util/StringUtil", "jeditable.datepicker", "jquery.timepicker",
                "app/ws/squashtm.workspace", "jquery.squash.togglepanel", "squashtable", "jquery.squash.formdialog"],

        function ($, pubsub, notification, _, confman, basic, translator, pathUtils, StringUtils) {

               var divOpen = '<div class="display-table-row">';
               var divClose = '</div>';

            // *********** Prefiling the ajax with the required token (Squash 1.18+) ***********

            if ($("meta[name='_csrf']").length > 0){
                $.ajaxPrefilter(function (options, originalOptions, jqXHR) {
                    var token = $("meta[name='_csrf']").attr("content");
                    var header = $("meta[name='_csrf_header']").attr("content");
                    jqXHR.setRequestHeader(header, token);
                });
            }

            // ********* events subscription *********************

            pubsub.subscribe("workflowautomjira.configuration.configfields", configureFields);
            pubsub.subscribe("workflowautomjira.configuration.complete", complete);
            pubsub.subscribe("workflowautomjira.configuration.initListDeroulante", initListDeroulante);
            pubsub.subscribe("workflowautomjira.configuration.initCustomsFields", initCustomsFields);
             // ********* jira fields configuration ***********

             /**/
            function initListDeroulante(){

                function selectedElement(fieldId, dropList){

                     var list =  $("#" + dropList);
                     var field=$('#'+fieldId).val()

                     if(field!=null)
                     {
                         var dropList =  list.selector + ' option[value="'+field.toString()+'"]';
                         if ($(dropList).length !== 0) {
                            $(dropList).attr("selected", "selected");
                         } else {
                            if (fieldId === 'projectJiraproject') {
                                $('#list-projects').append('<option value="0" selected>'+ translator.get('label.none') +'</option>');
                                $(list.selector + ' option[value="0"]').attr("selected", "selected");
                            }
                            if (fieldId === 'requestType4project') {
                                $('#request-type').append('<option value="0" selected>'+ translator.get('label.none') +'</option>');
                                $(list.selector + ' option[value="0"]').attr("selected", "selected");
                            }
                         }
                     }
                }

                selectedElement("server4project", "list-servers");
                selectedElement("projectJiraproject", "list-projects");
                selectedElement("requestType4project", "request-type");

                displaySpan();

             }

            function initCustomsFields(){
                var conf = squashtm.plugin.workflowautomjira.conf;
                var listCufs = conf.listCufs;
                conf.listCufsSaved = {};
                if (listCufs != null && listCufs !== undefined) {
                    retrieveRequiredFieldsFromJira().success(function(listCufsJira) {
                        if (listCufsJira != null && listCufsJira !== undefined) {
                            createCustomFields(listCufs, listCufsJira);

                            if ($('#cuf-panel label').length !== 0) {
                                $('#required-fields-label').show();
                            }
                        }
                    });
                }

            }

            function configureFields() {

                 $("#button-add").click(function(){
                        hideSuccessMessage();
                        /*validate if the fields are not empty*/
                       var ok = checkEmptyField();
                       if (ok === true ){
                            if ($("#parent").is(":visible")){
                               remoteIssueKeyExist();
                            }else  saveConfiguration();

                       }

                   });
                   var dialog = $("#delete-configuration-dialog");

                    dialog.formDialog();
                    dialog.on('formdialogcancel', function() {
                        dialog.formDialog('close');
                    });

                    dialog.on('formdialogconfirm', function() {
                        doRemoveConfiguration();
                    });
                 $("#button-remove").click(function(){
                   dialog.formDialog('open');
                 });
                 $("#list-servers").change(function(){

                    getAllProjectByIdServer().success(function(result){
                        /*update list projects*/
                        var myListProjects = $('#list-projects');
                        var myListRequestType = $('#request-type');
                        var none = translator.get('label.none');
                        if (result!=null){
                            $('#list-projects').empty();
                            $('#request-type').empty();
                             for(var i=0; i<result.length; i++) {
                             myListProjects.append('<option value="'+ result[i].key +'">'+ result[i].name  +'</option>');

                            };
                             myListProjects.append('<option value="0" selected>'+ none +'</option>');
                             myListRequestType.append('<option value="0" selected>'+ none +'</option>');
                             if($('#list-servers').val()!=0){
                                   $('#error-servers').hide();
                                   hideSuccessMessage();
                             }
                        }
                    });
                    clearRequiredFieldsPanel();
                  });/*fin change #list-servers*/

                 $("#list-projects").change(function(){

                  /**update liste request types*/

                  getRequestTypeByProjectKey().success(function(res){
                    var none = translator.get('label.none');
                    var myListRequestType = $('#request-type');
                    if (res!=null){
                         myListRequestType.empty();
                         for(var i=0; i<res.length; i++) {
                         myListRequestType.append('<option value="'+ res[i].id +'">'+ res[i].name  +'</option>');

                        };
                         myListRequestType.append('<option value="0" selected>'+none+'</option>');
                         myListRequestType.reload;
                         if($('#list-projects').val()!=0){
                               $('#error-projects').hide();
                         }

                    }
                    });
                    clearRequiredFieldsPanel();
                  });/*fin change #list-projects*/
                 $("#request-type").change(function(){
                    var conf = squashtm.plugin.workflowautomjira.conf;

                    if($('#request-type').val()!=0){
                          $('#error-type').hide();
                    }

                    retrieveRequiredFieldsFromJira().success(function(response){
                        clearRequiredFieldsPanel();
                        if(response.length!=0){
                            $("#required-fields-label").show();
                            $("#cuf-panel").show();
                            var serverId = $('#list-servers').val();
                            var projectId = $('#list-projects').val();
                            var typeId = $('#request-type').val();
                            if (conf.listCufsSaved.serverJira !== serverId || conf.listCufsSaved.projectKey !== projectId || conf.listCufsSaved.requestType !== typeId) {
                                conf.listCufs = response;
                            } else {
                                conf.listCufs = conf.listCufsSaved.listCufs;
                            }
                            completeConfigurationForm();
                        }
                    })
                 });/*fin change #request-type*/

             }/*fin configFields*/

            // ********* final initialization ***********
            function complete() {

                basic.init();
            }
              // ******** common code *********************

            function baseUrl() {
                var globconf = squashtm.plugin.workflowautomjira.conf;
                return squashtm.app.contextRoot + 'workflowautomationjira/project/' + globconf.projectId + '/configuration';
            }

            function createCustomFields(listCufs, listCufsJira) {
                var listCufsAll = listCufsJira;
                for (let i = 0; i < listCufsJira.length; i++) {
                    for (let j = 0; j < listCufs.length; j++) {
                        if (listCufsJira[i].idCuf === listCufs[j].idCuf) {
                            listCufsAll[i] = listCufs[j];
                            break;
                        }
                    }

                }

                saveListCufs(listCufsAll); // create saved list cufs in conf

                _.each(listCufsAll, function(cuf) {
                    createTag(cuf);
                });
            }

            function clearRequiredFieldsPanel() {
                hideSuccessMessage();
                squashtm.plugin.workflowautomjira.conf.listCufs = [];
                $("#required-fields-label").hide();
                $("#cuf-panel").empty();
                $("#cuf-panel").hide();
            }

            function retrieveRequiredFieldsFromJira() {
                var idServerSelected= $('#list-servers').val();
                var projectKeySelected=  $('#list-projects').val();
                var requestTypeId = $('#request-type').val();
                var url = baseUrl() + '/server/'+ idServerSelected + '/projects/'+projectKeySelected+'/issueType/' + requestTypeId + '/mandatoryCufs';

                return $.ajax({
                   url: url,
                   type: 'GET',
                   contentType: 'application/json'
               });
            }

            function doRemoveConfiguration() {
                var conf = squashtm.plugin.workflowautomjira.conf;
                var url = baseUrl();
                var msgSuccessRemove = translator.get("workflow.automation.jira.message.success.remove");
                $.ajax({
                    url: url,
                    type: 'DELETE',
                    contentType: 'application/json'
                }).success(function(){
                    conf.listCufsSaved = {};
                    document.location.reload();
                    initListDeroulante();
                    //showSuccessMessage(msgSuccessRemove);
                 });
            }

            function getAllProjectByIdServer(){

                var result;
                var idServerSelected= $('#list-servers').val();
                var url = baseUrl() + '/server/'+idServerSelected+'/projects';
                result = $.ajax({
                   url: url,
                   type: 'GET',
                   contentType: 'application/json'
               });
                return result;
            }

            function getRequestTypeByProjectKey(){
                var result;
                var projectKeySelected=  $('#list-projects').val();
                var idServerSelected= $('#list-servers').val();
                var url = baseUrl() + '/server/'+ idServerSelected + '/projects/'+projectKeySelected+'/request-types';
                result = $.ajax({
                   url: url,
                   type: 'GET',
                   contentType: 'application/json'
               });
                return result;
            }

            function checkEmptyField(){
                var isOk= true;
                var isOkCuf = true;
                var serverJira =$('#list-servers').val();
                var projectKey = $('#list-projects').val();
                var requestType = $('#request-type').val();
                var finalState = $("#final-state").val();
                var conf = squashtm.plugin.workflowautomjira.conf;
                var listCufs =  conf.listCufs;
                if(serverJira==0) {
                    $('#error-servers').show();
                    isOk= false
                }else{
                    $('#error-servers').hide();
                }
                if(projectKey==0) {
                    $('#error-projects').show();
                    isOk= false
                }else{
                     $('#error-projects').hide();
                 }
                if(requestType==0)  {
                     $('#error-type').show();
                    isOk= false
                }else{
                     $('#error-type').hide();
                }
                if(StringUtils.isBlank(finalState))  {
                     $('#error-final').show();
                    isOk= false
                }else{
                     $('#error-final').hide();
                 }
                if(listCufs!=null){
                     isOkCuf = checkEmptyFieldCuf(listCufs);
                }
                return (isOk && isOkCuf);
            }

            function checkEmptyFieldCuf(listCufs){
                var isOk= true;
                var labelUrl =  translator.get('workflow.automation.jira.error.invalid.url');
                var holderText = translator.get("workflow.automation.jira.rich-edit.placeholder");
                for (let i = 0; i < listCufs.length; i++) {
                    var cuf =  listCufs[i];
                    var idCuf = listCufs[i].idCuf;
                    var inputCuf = $('#'+idCuf+'');
                    var inputError = $('#error-'+idCuf+'');
                    var valCuf = getValueTag(inputCuf) ;
                    if(valCuf==0 || StringUtils.isBlank(valCuf) || valCuf == holderText){
                        inputError.show();
                        isOk= false;
                    }else inputError.hide();
                    if(isOk==true && inputCuf.hasClass("is-url")){
                        var isValid = isValidUrl(valCuf);
                        if(!isValid){
                            isOk= false;
                            inputError.show();
                            inputError.text(labelUrl);
                        }
                    }

                }//for

                return isOk
            }

            function isValidUrl(url){
                var pattern = /^(http|https)?:\/\/[a-zA-Z0-9-\.]+\.[a-z]{2,4}/;
                return pattern.test(url);
            }

            function saveConfiguration(){
                var conf = squashtm.plugin.workflowautomjira.conf;
                var url = baseUrl();
                var listCufs = getJsonListCufs();
                var configurationForProject ={
                    serverJira: $('#list-servers').val(),
                    projectKey: $('#list-projects').val(),
                    requestType: $('#request-type').val(),
                    finalState: $.trim($("#final-state").val()),
                    listCufs: listCufs
               };

                var msgSuccessSave=translator.get("workflow.automation.jira.message.success.save");


               $.ajax({
                   url: url,
                   type: 'POST',
                   data: JSON.stringify(configurationForProject),
                   contentType: 'application/json'
               }).success(function(){
                    showSuccessMessage(msgSuccessSave);
                    conf.listCufsSaved = configurationForProject;
               }).fail(function(){
                    console.log("erreur ds url");
               });

            }

            function saveListCufs(listCufs) {
                var conf = squashtm.plugin.workflowautomjira.conf;
                var serverId = $('#list-servers').val();
                var projectId = $('#list-projects').val();
                var typeId = $('#request-type').val();
                if (serverId !== undefined && projectId !== undefined && typeId !== undefined) {
                    conf.listCufsSaved = {
                        'serverJira' : serverId,
                        'projectKey' : projectId,
                        'requestType' : typeId,
                        'listCufs' : listCufs
                    }
                    conf.listCufs = listCufs;
                } else {
                    conf.listCufsSaved = {};
                }
            }

            function displaySpan(){
                $('.error-span').hide();
                $("#div-success-msg").hide();
            }

            function showSuccessMessage(message){
                   $('#div-success-msg').show();
                   $('#msg-succes').text(message);
            }

            function hideSuccessMessage(){

                   $('#div-success-msg').hide();
            }

            function  completeConfigurationForm(){
                var conf = squashtm.plugin.workflowautomjira.conf;
                var listCufsJira = conf.listCufs
                for (let i = 0; i < listCufsJira.length; i++) {
                    var cuf =  listCufsJira[i];
                    createTag(cuf);
                }
              }

            function createTag(cuf){
                var htmlString = createHtmlString(cuf);
                var fragment = create(htmlString);
                document.getElementById("cuf-panel").appendChild(fragment);
              }

            function create(htmlStr) {
                var frag = document.createDocumentFragment(),
                    temp = document.createElement('div');
                temp.innerHTML = htmlStr;
                while (temp.firstChild) {
                    frag.appendChild(temp.firstChild);
                  }
                    return frag;
            }

            function createHtmlString(cuf){
                var htmlString;
                var dateTime;
                var multiple;
                var version;
                var typeCuf = cuf.typeCuf;

                switch(typeCuf){
                    case 'text' :
                        htmlString = createInputText(cuf, typeCuf);
                        break;
                    case 'number':
                        htmlString = createInputText(cuf, typeCuf);
                        break;
                    case 'url' :
                        htmlString = createInputUrl(cuf, typeCuf);
                        break;
                    case 'duedate':
                    case 'date':
                        dateTime =false
                        htmlString = createInputDate(cuf, typeCuf, dateTime);
                        break;
                    case 'datetime':
                        dateTime= true;
                        htmlString = createInputDate(cuf, typeCuf, dateTime);
                        break;
                    case 'option':
                        htmlString = createRadioButton(cuf);
                        break;
                    case 'version':
                        multiple = "";
                        version = '-version';
                        htmlString = createDropdown(cuf, multiple, version);
                        break;
                    case 'priority':
                    case 'project':
                    case 'select':
                        multiple = "";
                        version="";
                        htmlString = createDropdown(cuf, multiple, version);
                        break;
                    case 'checkbox':
                        htmlString = createCheckbox(cuf);
                        break;

                    case 'textarea':
                        htmlString = createTextArea(cuf);
                        break;
                    case 'labels':
                        htmlString = createInputText(cuf, 'text');
                        break;
                    case 'multiselect':
                        multiple= '-multiple';
                        version="";
                        htmlString = createDropdown(cuf, multiple, version);
                        break;

                    case 'cascadingselect':
                        htmlString = createCascadingSelect(cuf);
                        break;
                    case 'multiversion':
                        multiple= '-multiple';
                        version="-version";
                        htmlString = createDropdown(cuf, multiple, version);
                        break;



                    default:
                }
                return htmlString;

            }//chooseTypeInput

            function createLabel(cuf){
                var label = '<label for="'+cuf.nameCuf+'" class="display-table-cell" style="vertical-align:top;">'+cuf.nameCuf+'</label>';
                return label;
            }

            function createSpanError(cuf){
                var label =  translator.get('workflow.automation.jira.error.empty.Cuf');
                return  '<span id="error-'+cuf.idCuf+'" class="display-table-cell  error-span" style="color: red; display: none;" >' + label +'</span>';
           }

            function createInputText(cuf, typeHtml){
                var htmlString;
                var input = '<input class = "custom-field is-input" id = "'+ cuf.idCuf+ '" name="'+cuf.nameCuf+'" type="'+ typeHtml +'" size="50" maxlength="255" value="' + cuf.valueCuf+ '"/>';
                htmlString = divOpen + createLabel(cuf) + input + createSpanError(cuf)+ divClose
                return htmlString;
            }

            function createInputUrl(cuf, typeHtml){
                var htmlString;
                var input = '<input class = "custom-field is-input is-url" id = "'+ cuf.idCuf+ '" name="'+cuf.nameCuf+'" type="'+ typeHtml +'" size="50" maxlength="255" value="' + cuf.valueCuf+ '"/>';
                htmlString = divOpen + createLabel(cuf) + input + createSpanError(cuf)+ divClose
                return htmlString;
            }
            function createInputDate(cuf, typeHtml, dateTime){
                var htmlString;
                var classHtml = dateTime? "class-cuf-date-time" : "class-cuf-date";
                var holderText = translator.get("workflow.automation.jira.rich-edit.placeholder");
                var valueDate = StringUtils.isBlank(cuf.valueCuf) ? holderText : cuf.valueCuf ;
                var  current_datetime = new Date();

                var input =  '<span  class="custom-field is-span '+ classHtml +'" id="'+ cuf.idCuf+'" data-locale="fr" th:attr="data-locale=#{squashtm.locale}"> '+ valueDate +' </span>'
                htmlString = divOpen + createLabel(cuf) + input + createSpanError(cuf)+ divClose
                return htmlString;
            }

            function createRadioButton(cuf){
                 var allowedValues = cuf.allowedValues;
                 var inputRadio="";
                 var htmlString = "";
                 var propChecked="";
                 if(allowedValues != null){
                     for (var i = 0; i < allowedValues.length; i++) {
                        propChecked="";
                        if(cuf.valueCuf!=null && allowedValues[i].id == cuf.valueCuf){
                            propChecked =  ' checked="checked"';
                        }
                        inputRadio += '<input type="radio" id = "'+ allowedValues[i].id +'" value="' + allowedValues[i].id + '" name ="'+cuf.nameCuf+'" '+ propChecked +' >' + allowedValues[i].name ;

                      }
                       htmlString = divOpen + createLabel(cuf) + '<div class="is-option" id = "' +cuf.idCuf+ '">' + inputRadio + divClose + createSpanError(cuf)+ divClose
                  }
                  return htmlString;
            }

            function createDropdown(cuf, multiple, version){
                 var allowedValues = cuf.allowedValues;
                 var inputOption="";
                 var htmlString = "";
                 var selectedValue="";

                 var select = '<select class="is-select'+multiple+ version +'" name="' + cuf.nameCuf +'" id="' + cuf.idCuf + '"  '+ multiple.substring(1) +'>'
                 var closeSelect = "</select>"
                 if(allowedValues != null){
                     for (var i = 0; i < allowedValues.length; i++) {
                        selectedValue="";
                        if(multiple==""){
                            if(cuf.valueCuf!=null && (allowedValues[i].id == cuf.valueCuf || allowedValues[i].scalar  ==cuf.valueCuf)){
                                selectedValue =  ' selected';
                            }
                        }else{
                            if(cuf.valueCuf!=null){
                                 var listValues = cuf.valueCuf.split(',');
                                 for (var j = 0; j<listValues.length; j++){
                                  if(allowedValues[i].id == listValues[j] || allowedValues[i].scalar  == listValues[j]){
                                    selectedValue =  ' selected';
                                  }
                                 }
                             }
                        }

                        inputOption +='<option value="'+allowedValues[i].id+'" ' + selectedValue + '>'+allowedValues[i].name+ '</option>';

                      }
                       htmlString = divOpen + createLabel(cuf) + select + inputOption + closeSelect + createSpanError(cuf) + divClose
                  }
                  return htmlString;
            }

            function createCheckbox(cuf){
                 var allowedValues = cuf.allowedValues;
                 var input="";
                 if(allowedValues != null){
                      for (var i = 0; i < allowedValues.length; i++) {
                         selectedValue="";
                         if(cuf.valueCuf!=null){
                             var listValues = cuf.valueCuf.split(',');
                             for (var j = 0; j<listValues.length; j++){
                              if(allowedValues[i].id == listValues[j]){
                                selectedValue =  ' checked';
                              }
                             }

                         }
                         input +='<input type="checkbox"  name="' + cuf.nameCuf +'" value = "'+allowedValues[i].id+'" ' + selectedValue+ ' >' +allowedValues[i].name+ '</input>'  ;
                       }
                        htmlString = divOpen + createLabel(cuf) +'<div id = "'+cuf.idCuf+'" class = "is-checkbox">' + input + divClose + createSpanError(cuf) +divClose
                   }
                return htmlString;
            }

            function createTextArea(cuf){
                var htmlString;
                var input = '<textarea class = "is-textArea" id = "'+ cuf.idCuf+ '" rows="5" cols="50">'+cuf.valueCuf+'</textarea>' ;
                htmlString = divOpen + createLabel(cuf) + input + createSpanError(cuf) + divClose
                return htmlString;

            }

            function createCascadingSelect(cuf){
                var allowedValues = cuf.allowedValues;
                var select= "";
                var option;
                var optgroup;
                var allOptGroup = "";
                var composite;
                var selectedValue;
                select += '<select id="'+cuf.idCuf+'" class="is-cascadingselect" > ';
                if(allowedValues != null){
                    for (var i = 0; i < allowedValues.length; i++) {
                         optgroup = "";
                         optgroup= ' <optgroup label="'+ allowedValues[i].scalar+ '" value="'+ allowedValues[i].scalar +'">'
                         composite = allowedValues[i].composite;
                         if (composite != null){
                          option="";
                          for (var j= 0; j<composite.length; j++){
                            selectedValue="";
                            if(cuf.valueCuf!=null && composite[j].scalar == cuf.valueCuf.split(",")[1]){
                              selectedValue =  ' selected';
                            }
                            option += '<option value="'+ composite[j].scalar +'" '+ selectedValue + '>'+ composite[j].scalar +'</option>'
                          }
                         }
                         allOptGroup +=optgroup + option +'</optgroup>';
                    }

                    htmlString = divOpen + createLabel(cuf) +  select + allOptGroup+ '</select>' + createSpanError(cuf) + divClose;
                }

                return htmlString;

            }

            /* Manage cuf  date and date time*/
            $(document).ready(function(){
                $(document).on('click', ".class-cuf-date", function (){
                    manageCufTypeDate();
                });

            });

            $(document).ready(function(){
                $(document).on('click', ".class-cuf-date-time", function (){
                    manageCufTypeDatetime();
                });

            });

            function manageCufTypeDatetime(){
                             var datepick = self.$(".class-cuf-date-time");
            	            // configure editable datepicker settings :
            				var dateSettings = confman.getStdDatepicker();
                            var holderText = translator.get("workflow.automation.jira.rich-edit.placeholder");
                            var dateObj=new Date();
            				var postfn = function (value) {
                                var revert = this.revert;
                                var localizedDate = value;
                                var postDateFormat = $.datepicker.ATOM;
                                var date = $.datepicker.parseDate(squashtm.app.dateFormat, localizedDate);
                                var postDate = $.datepicker.formatDate('dd/mm/yy', date);
                                var time  = dateObj.getHours()+":"+dateObj.getMinutes()+":"+dateObj.getSeconds();
                                datepick.text(postDate + " " + time );

            				};

            				// make editable
                            datepick.editable(postfn, {
                                type: 'datepicker',
                                tooltip: holderText,
                                datepicker: dateSettings,
                                name: "value"
                            });

                        };//datetime

            function manageCufTypeDate(){
                 var datepick = self.$(".class-cuf-date");
	            // configure editable datepicker settings :
				var dateSettings = confman.getStdDatepicker();
                var holderText = translator.get("workflow.automation.jira.rich-edit.placeholder");
				var postfn = function (value) {
                    var revert = this.revert;
                    var localizedDate = value;
                    var postDateFormat = $.datepicker.ATOM;
                    var date = $.datepicker.parseDate(squashtm.app.dateFormat, localizedDate);
                    var postDate = $.datepicker.formatDate(postDateFormat, date);
                    datepick.text(localizedDate);

				};

				// make editable
                datepick.editable(postfn, {
                    type: 'datepicker',
                    tooltip: holderText,
                    datepicker: dateSettings,
                    name: "value"/*,
                    onsubmit: function () {
                        return self._validate(this);
                    }*/
                });

            };//testDate

            function getJsonListCufs(){
                var conf = squashtm.plugin.workflowautomjira.conf;
                var jsonListCufs=[];
                var valueMap;

                var listCufs = conf.listCufs;
                if(listCufs!=null){
                     for(var i=0; i<listCufs.length; i++) {
                        var idCuf = listCufs[i].idCuf;
                        var nameCuf = listCufs[i].nameCuf;
                        var idType = listCufs[i].typeCuf;
                        var inputCuf = $('#'+idCuf+'');
                        var valCuf = getValueTag(inputCuf) ;

                        itemCufInfo={}
                        itemCufInfo["idCuf"]=idCuf;
                        itemCufInfo["nameCuf"]=nameCuf;
                        itemCufInfo["typeCuf"]=idType;
                        itemCufInfo["valueCuf"]=valCuf;
                        itemCufInfo["allowedValues"]=listCufs[i].allowedValues;

                        jsonListCufs.push(itemCufInfo);
                     }
                }
                return jsonListCufs;

            }

            function getValueTag(tag){
            var value;

            if(tag.hasClass("is-input") || tag.hasClass("is-textArea")) {
                    value =$.trim(tag.val());
            }
            if(tag.hasClass("is-span")) {
                    value =$.trim(tag.text())
            }

            if(tag.hasClass("is-option")) {
                value = tag.find(":checked").val();
            }
            if(tag.hasClass("is-select")) {
                value = tag.find(":selected").val();
            }
             if(tag.hasClass("is-select-version")) {
                value = tag.find(":selected").text();
            }

            if(tag.hasClass("is-checkbox")) {
                var tmp;
                var str = "";
                tag.find("input[type='checkbox']:checked").each(
                    function(){
                        str += $(this).val()  + ',' ;
                    }
                );
                value = str.substring(0, str.length-1);
            }
            if(tag.hasClass("is-select-multiple")) {
                var tmp;
                var str = "";
                tag.find(":selected").each(
                    function(){
                        str += $(this).val()  + ',' ;
                    }
                );
                value = str.substring(0, str.length-1);
            }
            if(tag.hasClass("is-select-multiple-version") ) {
                            var tmp;
                            var str = "";
                            tag.find(":selected").each(
                                function(){
                                    str += $(this).text()  + ',' ;
                                }
                            );
                            value = str.substring(0, str.length-1);
                        }

            if(tag.hasClass("is-cascadingselect")) {
                var parent;
                var child;
                child = tag.find(":selected");
                parent = child.closest('optgroup').attr('value');
                value =  parent+','+ child.val();
            }

            return value;

          }

            function remoteIssueKeyExist(){
                  var isExist = true ;
                  var labelParent =  translator.get('workflow.automation.jira.msg.error.parent.request.not.exist');
                  var parentRequest = $("#parent").val();
                  var serverJira =$('#list-servers').val();
                  var url = baseUrl() + '/server/' + serverJira + '/remoteIssue/' + parentRequest;
                  $.ajax({
                      url: url,
                      type: 'GET',
                      contentType: 'application/json'
                  }).done(function(result){
                    if(result === true){
                     saveConfiguration();
                     $('#error-parent').hide();
                    }else{
                        $('#error-parent').show();
                        $('#error-parent').text(labelParent);
                    }

                  });
            }
/*fin*/
        })
});
