/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.converters;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.advanceddomain.Rendering;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.config.FieldConfiguration;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.FieldTypeDirectory;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapAdvancedIssue;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapArtifact;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapArtifactValue;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapAssignee;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapField;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapFieldValue;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapProject;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapStubIssue;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapTracker;

@Component
public class TuleapToSquashConverter {
    @Inject
    private FieldConfiguration fieldConfiguration;
    @Inject
    @Named(value="tuleapConnectorMessageSource")
    private MessageSource messageSource;
    @Inject
    private ExceptionHandler exceptionHandler;
    public static final String TRACKER_FIELD_ID = "trackername";

    public AdvancedProject convertProject(TuleapProject tuleapProject) {
        return this.convertProject(tuleapProject, true);
    }

    public AdvancedProject convertProject(TuleapProject tuleapProject, boolean editableFields) {
        AdvancedProject squashProject = new AdvancedProject();
        squashProject.setId(tuleapProject.getId().toString());
        squashProject.setName(tuleapProject.getLabel());
        Map<String, List<Field>> schemes = this.getSchemes(tuleapProject, editableFields);
        squashProject.setSchemeMap(schemes);
        return squashProject;
    }

    private Map<String, List<Field>> getSchemes(TuleapProject tuleapProject, boolean editableFields) {
        LinkedHashMap<String, List<Field>> fieldMap = new LinkedHashMap<String, List<Field>>();
        List<TuleapTracker> trackers = tuleapProject.getTrackers();
        ArrayList trackerFieldValues = new ArrayList();
        Field trackerField = this.createEmptyTrackerTypeField();
        if (Objects.nonNull(trackers)) {
            if (trackers.isEmpty()) {
                throw this.exceptionHandler.noTrackerConfigured();
            }
            trackers.stream().sorted(Comparator.comparing(TuleapTracker::getLabel)).forEach(tuleapTracker -> {
                FieldValue trackerFieldValue = new FieldValue(tuleapTracker.getId().toString(), tuleapTracker.getLabel());
                trackerFieldValue.setTypename(TRACKER_FIELD_ID);
                trackerFieldValues.add(trackerFieldValue);
                String schemeKey = TuleapToSquashConverter.getSchemeName(tuleapTracker);
                List schemeFields = fieldMap.getOrDefault(schemeKey, new ArrayList());
                schemeFields.add(trackerField);
                List<TuleapField> fields = tuleapTracker.getFields();
                fields.stream().filter(TuleapField::isEditable).filter(TuleapField::isAllowed).filter(TuleapField::canSubmit).sorted((field1, field2) -> {
                    String name1 = field1.getName();
                    int index1 = this.fieldConfiguration.getExpectedOrder().indexOf(name1);
                    String name2 = field2.getName();
                    int index2 = this.fieldConfiguration.getExpectedOrder().indexOf(name2);
                    return index2 - index1;
                }).forEach(tuleapField -> schemeFields.add(this.convertTuleapField((TuleapField)tuleapField, (TuleapTracker)tuleapTracker, editableFields)));
                fieldMap.put(schemeKey, schemeFields);
            });
            trackerField.setPossibleValues(trackerFieldValues.toArray(new FieldValue[0]));
        }
        return fieldMap;
    }

    public static String getSchemeName(TuleapTracker tuleapTracker) {
        return "trackername:" + tuleapTracker.getLabel();
    }

    public AdvancedIssue convertTuleapArtifact(TuleapArtifact artifact) {
        if (artifact.isNotFound()) {
            return new TuleapStubIssue(this.messageSource, artifact.getId());
        }
        if (artifact.getTracker() == null) {
            throw new IllegalArgumentException("Programmatic error : You must provide a not null Tracker for artifact : " + String.valueOf(artifact.getId()));
        }
        TuleapAdvancedIssue advancedIssue = new TuleapAdvancedIssue(this.messageSource);
        advancedIssue.setId(artifact.getId().toString());
        advancedIssue.setCurrentScheme(TuleapToSquashConverter.getSchemeName(artifact.getTracker()));
        this.initializeFieldIdentifiers(artifact, advancedIssue);
        List<TuleapAssignee> tuleapAssignees = artifact.getAssignees();
        if (advancedIssue.getAssigneeField() != null && !tuleapAssignees.isEmpty()) {
            TuleapAssignee tuleapAssignee = tuleapAssignees.get(0);
            advancedIssue.setFieldValue(advancedIssue.getAssigneeField().getLabel(), new FieldValue("", tuleapAssignee.getUsername()));
        }
        TuleapField summaryField = advancedIssue.getSummaryField();
        TuleapField descriptionField = advancedIssue.getDescriptionField();
        TuleapField severityField = advancedIssue.getSeverityField();
        TuleapField statusField = advancedIssue.getStatusField();
        artifact.getValues().forEach(tuleapArtifactValue -> {
            FieldValue squashFieldValue = this.getSquashFieldValue((TuleapArtifactValue)tuleapArtifactValue);
            String fieldLabel = tuleapArtifactValue.getLabel();
            if (summaryField != null && fieldLabel.equals(summaryField.getLabel())) {
                advancedIssue.setFieldValue(fieldLabel, squashFieldValue);
            } else if (descriptionField != null && descriptionField.getLabel().equals(fieldLabel)) {
                advancedIssue.setFieldValue(fieldLabel, squashFieldValue);
            } else if (severityField != null && severityField.getLabel().equals(fieldLabel)) {
                advancedIssue.setFieldValue(severityField.getLabel(), squashFieldValue);
            } else if (statusField != null && statusField.getLabel().equals(fieldLabel)) {
                advancedIssue.setFieldValue(fieldLabel, squashFieldValue);
            }
        });
        AdvancedProject advancedProject = this.createReadOnlyStubProject(artifact, advancedIssue);
        advancedIssue.setProject(advancedProject);
        return advancedIssue;
    }

    private AdvancedProject createReadOnlyStubProject(TuleapArtifact artifact, TuleapAdvancedIssue advancedIssue) {
        TuleapProject tuleapProject = artifact.getProject();
        AdvancedProject squashProject = new AdvancedProject();
        squashProject.setId(tuleapProject.getId().toString());
        squashProject.setName(tuleapProject.getLabel());
        HashMap schemes = new HashMap();
        TuleapField summaryField = advancedIssue.getSummaryField();
        TuleapField descriptionField = advancedIssue.getDescriptionField();
        TuleapField severityField = advancedIssue.getSeverityField();
        TuleapField statusField = advancedIssue.getStatusField();
        TuleapField assigneeField = advancedIssue.getAssigneeField();
        String schemeKey = TuleapToSquashConverter.getSchemeName(artifact.getTracker());
        ArrayList<Field> fields = new ArrayList<Field>();
        schemes.put(schemeKey, fields);
        if (summaryField != null) {
            Field squashSummaryField = this.createReadOnlyField(summaryField.getLabel(), summaryField.getLabel());
            fields.add(squashSummaryField);
        }
        if (descriptionField != null) {
            Field squashDescriptionField = this.createReadOnlyField(descriptionField.getLabel(), descriptionField.getLabel());
            squashDescriptionField.getRendering().setInputType(new InputType(InputType.TypeName.TEXT_AREA.value, "unknown"));
            fields.add(squashDescriptionField);
        }
        if (severityField != null) {
            Field squashPriorityField = this.createReadOnlyField(severityField.getLabel(), severityField.getLabel());
            fields.add(squashPriorityField);
        }
        if (statusField != null) {
            Field squashStatusField = this.createReadOnlyField(statusField.getLabel(), statusField.getLabel());
            fields.add(squashStatusField);
        }
        if (assigneeField != null) {
            Field squashAssigneeField = this.createReadOnlyField(assigneeField.getLabel(), assigneeField.getLabel());
            fields.add(squashAssigneeField);
        }
        squashProject.setSchemeMap(schemes);
        return squashProject;
    }

    private void initializeFieldIdentifiers(TuleapArtifact artifact, TuleapAdvancedIssue advancedIssue) {
        TuleapTracker tracker = artifact.getTracker();
        List<TuleapField> fields = tracker.getFields();
        for (TuleapField field : fields) {
            String name = field.getName();
            if (name.equals(this.fieldConfiguration.getSummary())) {
                advancedIssue.setSummaryField(field);
            }
            if (name.equals(this.fieldConfiguration.getDetails())) {
                advancedIssue.setDescriptionField(field);
            }
            if (name.equals(this.fieldConfiguration.getAssignee())) {
                advancedIssue.setAssigneeField(field);
            }
            if (name.equals(this.fieldConfiguration.getSeverity())) {
                advancedIssue.setSeverityField(field);
            }
            if (!name.equals(this.fieldConfiguration.getStatus())) continue;
            advancedIssue.setStatusField(field);
        }
    }

    private FieldValue getSquashFieldValue(TuleapArtifactValue tuleapArtifactValue) {
        List<TuleapFieldValue> tuleapFieldValues = tuleapArtifactValue.getValues();
        if (tuleapFieldValues.isEmpty()) {
            return tuleapArtifactValue.getSquashFieldValue();
        }
        FieldValue fieldValue = new FieldValue();
        fieldValue.setScalar(tuleapFieldValues.get(0).getLabel());
        return fieldValue;
    }

    private Field convertTuleapField(TuleapField tuleapField, TuleapTracker tuleapTracker, boolean editableFields) {
        String tuleapFieldLabel = tuleapField.getLabel();
        Field field = new Field(tuleapFieldLabel, tuleapFieldLabel);
        this.initRendering(tuleapField, field, editableFields);
        if (tuleapTracker.isWorkflowField(tuleapField)) {
            this.initWorkflowFieldValues(tuleapField, field, tuleapTracker);
        } else {
            this.initFieldValues(tuleapField, field);
        }
        return field;
    }

    private void initWorkflowFieldValues(TuleapField tuleapField, Field field, TuleapTracker tuleapTracker) {
        List<TuleapFieldValue> visibleValues = tuleapField.getVisibleValues();
        List<Long> validInitialStatusIds = tuleapTracker.findValidInitialStatusIds();
        List<FieldValue> fieldValues = visibleValues.stream().filter(tuleapFieldValue -> tuleapFieldValue.getId() != null && StringUtils.isNotBlank((CharSequence)tuleapFieldValue.getLabel())).filter(tuleapFieldValue -> validInitialStatusIds.contains(tuleapFieldValue.getId())).map(this::createFieldValue).collect(Collectors.toList());
        field.setPossibleValues(fieldValues.toArray(new FieldValue[0]));
    }

    private void initFieldValues(TuleapField tuleapField, Field field) {
        List<TuleapFieldValue> visibleValues = tuleapField.getVisibleValues();
        List<FieldValue> fieldValues = visibleValues.stream().filter(tuleapFieldValue -> tuleapFieldValue.getId() != null && StringUtils.isNotBlank((CharSequence)tuleapFieldValue.getLabel())).map(this::createFieldValue).collect(Collectors.toList());
        if (tuleapField.shouldHaveEmptyValue()) {
            FieldValue dummy = this.createDummyFieldValue();
            ArrayList<FieldValue> valuesWithDummy = new ArrayList<FieldValue>();
            valuesWithDummy.add(0, dummy);
            valuesWithDummy.addAll(fieldValues);
            field.setPossibleValues(valuesWithDummy.toArray(new FieldValue[0]));
        } else {
            field.setPossibleValues(fieldValues.toArray(new FieldValue[0]));
        }
    }

    private FieldValue createDummyFieldValue() {
        FieldValue dummy = new FieldValue();
        dummy.setId("");
        dummy.setScalar("");
        return dummy;
    }

    private FieldValue createFieldValue(TuleapFieldValue tuleapFieldValue) {
        FieldValue squashFieldValue = new FieldValue();
        squashFieldValue.setId(tuleapFieldValue.getId().toString());
        squashFieldValue.setScalar(tuleapFieldValue.getLabel());
        return squashFieldValue;
    }

    private void initRendering(TuleapField tuleapField, Field field, boolean editableFields) {
        String squashType = FieldTypeDirectory.getSquashType(tuleapField.getType());
        InputType inputType = new InputType(squashType, tuleapField.getType());
        String[] operation = editableFields ? tuleapField.getEditPermissions().toArray(new String[0]) : new String[]{};
        Rendering rendering = new Rendering(operation, inputType, tuleapField.isRequired());
        field.setRendering(rendering);
    }

    private Field createEmptyTrackerTypeField() {
        Field trackerField = new Field();
        trackerField.setId(TRACKER_FIELD_ID);
        InputType inputType = new InputType(InputType.TypeName.DROPDOWN_LIST.value, TRACKER_FIELD_ID);
        inputType.setFieldSchemeSelector(true);
        Rendering rendering = new Rendering(new String[]{"SET"}, inputType, true);
        trackerField.setRendering(rendering);
        trackerField.setLabel("Tracker");
        return trackerField;
    }

    private Field createReadOnlyField(String id, String label) {
        Field field = new Field(id, label);
        Rendering rendering = new Rendering(new String[0], new InputType(InputType.TypeName.TEXT_FIELD.value, "unknown"), false);
        field.setRendering(rendering);
        return field;
    }
}

