/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting;

import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabNote;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;

@Component
public class ExistingReportingNoteFinder {
    public Optional<GitLabNote> findExistingReportingNote(GitLabClient client, GitLabIssue gitLabIssue, String tmSignature, String trackedCommentGlobalId) {
        if (trackedCommentGlobalId != null) {
            return this.findExistingReportingNoteById(gitLabIssue, trackedCommentGlobalId, client);
        }
        return this.findExistingReportingNoteBySignature(gitLabIssue, tmSignature, client);
    }

    private Optional<GitLabNote> findExistingReportingNoteById(GitLabIssue gitLabIssue, String trackedCommentId, GitLabClient client) {
        Optional<GitLabNote> existingNote = gitLabIssue.getNotes().stream().filter(note -> ExistingReportingNoteFinder.extractNumericNoteId(note.globalId()).equals(ExistingReportingNoteFinder.extractNumericNoteId(trackedCommentId))).findFirst();
        if (existingNote.isPresent()) {
            return existingNote;
        }
        return this.findExistingReportingNoteByIdInAllPages(gitLabIssue, trackedCommentId, client);
    }

    private Optional<GitLabNote> findExistingReportingNoteByIdInAllPages(GitLabIssue gitLabIssue, String trackedCommentId, GitLabClient client) {
        GitLabClient.Page<List<GitLabNote>> page;
        String cursor = null;
        do {
            Optional<GitLabNote> existingNote;
            if (!(existingNote = (page = client.getNoteClient().getIssueNotesPage(gitLabIssue.getGlobalId(), cursor)).items().stream().filter(note -> ExistingReportingNoteFinder.extractNumericNoteId(note.globalId()).equals(ExistingReportingNoteFinder.extractNumericNoteId(trackedCommentId))).findFirst()).isPresent()) continue;
            return existingNote;
        } while ((cursor = page.endCursor()) != null);
        return Optional.empty();
    }

    private static String extractNumericNoteId(String trackedCommentId) {
        return trackedCommentId.replaceAll("\\D", "");
    }

    private Optional<GitLabNote> findExistingReportingNoteBySignature(GitLabIssue gitLabIssue, String signature, GitLabClient client) {
        Optional<GitLabNote> existingNote = ExistingReportingNoteFinder.findReportingNoteWithSignature(gitLabIssue.getNotes(), signature);
        if (existingNote.isPresent()) {
            return existingNote;
        }
        return this.findExistingReportingNoteBySignatureInAllPages(gitLabIssue, signature, client);
    }

    private Optional<GitLabNote> findExistingReportingNoteBySignatureInAllPages(GitLabIssue gitLabIssue, String signature, GitLabClient client) {
        GitLabClient.Page<List<GitLabNote>> page;
        String cursor = null;
        GitLabNote lastMatchingNote = null;
        do {
            Optional<GitLabNote> existingNote;
            if (!(existingNote = ExistingReportingNoteFinder.findReportingNoteWithSignature((page = client.getNoteClient().getIssueNotesPage(gitLabIssue.getGlobalId(), cursor)).items(), signature)).isPresent()) continue;
            lastMatchingNote = existingNote.get();
        } while ((cursor = page.endCursor()) != null);
        return Optional.ofNullable(lastMatchingNote);
    }

    private static Optional<GitLabNote> findReportingNoteWithSignature(List<GitLabNote> notes, String signature) {
        if (notes == null) {
            return Optional.empty();
        }
        String trimmedSignature = StringUtils.trimAllWhitespace((String)signature);
        return notes.stream().filter(note -> StringUtils.trimAllWhitespace((String)note.body()).endsWith(trimmedSignature)).filter(note -> StringUtils.trimAllWhitespace((String)note.body()).startsWith("##")).reduce((first, second) -> second);
    }
}

