/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.SprintGroupDto;
import org.squashtest.tm.plugin.rest.validators.helper.SprintGroupDtoValidationHelper;

@Component
public class SprintGroupPostValidator
implements Validator {
    @Inject
    SprintGroupDtoValidationHelper sprintGroupDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return SprintGroupDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        SprintGroupDto sprintGroupDto = (SprintGroupDto)target;
        if (sprintGroupDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing sprint group, please do a patch request to the sprint group id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.sprintGroupDtoValidationHelper.checkParent(errors, sprintGroupDto, RestType.SPRINT_GROUP);
    }
}

