/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindException;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.jackson.model.ActionTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.CalledTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDtoVisitor;
import org.squashtest.tm.plugin.rest.service.RestInternalCustomFieldValueUpdaterService;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;
import org.squashtest.tm.plugin.rest.service.RestTestStepService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.service.impl.ActionTestStepPatcher;
import org.squashtest.tm.plugin.rest.service.impl.KeywordTestStepPatcher;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.testcase.TestStepModificationService;

@Service
@Transactional
public class RestTestStepServiceImpl
implements RestTestStepService {
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private TestStepModificationService testStepModificationService;
    @Inject
    private CallStepManagerService callStepManagerService;
    @Inject
    private CustomFieldValueHelper customFieldValueConverter;
    @Inject
    private ActionTestStepPatcher actionTestStepPatcher;
    @Inject
    private KeywordTestStepPatcher keywordTestStepPatcher;
    @Inject
    private RestInternalCustomFieldValueUpdaterService internalCufService;
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private RestRequirementVersionService requirementVersionService;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.testcase.TestStep' , 'READ')")
    public TestStep getOne(long id) {
        return this.testStepModificationService.findById(id);
    }

    @Override
    public TestStep createTestStep(TestStepDto testStepDto, TestCase testCase) throws InvocationTargetException, IllegalAccessException, BindException {
        return this.createStep(testCase, testStepDto);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#stepId,'org.squashtest.tm.domain.testcase.TestStep', 'WRITE')")
    public TestStep patchTestStep(final TestStepDto patch, final long stepId) throws BindException {
        final TestStep testStep = this.testStepModificationService.findById(stepId);
        if (patch.getIndex() != null) {
            this.testCaseModificationService.changeTestStepsPosition(testStep.getTestCase().getId().longValue(), patch.getIndex().intValue(), Collections.singletonList(patch.getId()));
        }
        TestStepDtoVisitor visitor = new TestStepDtoVisitor(){

            @Override
            public void visit(ActionTestStepDto actionTestStepDto) {
                RestTestStepServiceImpl.this.actionTestStepPatcher.patch(testStep, patch);
                RestTestStepServiceImpl.this.internalCufService.mergeCustomFields((BoundEntity)((ActionTestStep)testStep), actionTestStepDto.getCustomFields());
            }

            @Override
            public void visit(CalledTestStepDto calledTestStepDto) {
                ParameterAssignationMode mode;
                Long datasetId = null;
                if (calledTestStepDto.isDelegateParameterValues()) {
                    mode = ParameterAssignationMode.DELEGATE;
                } else if (calledTestStepDto.getCalledDataset() != null) {
                    mode = ParameterAssignationMode.CALLED_DATASET;
                    datasetId = calledTestStepDto.getCalledDataset().getId();
                } else {
                    mode = ParameterAssignationMode.NOTHING;
                }
                RestTestStepServiceImpl.this.callStepManagerService.setParameterAssignationMode(calledTestStepDto.getId().longValue(), mode, datasetId);
            }

            @Override
            public void visit(KeywordTestStepDto keywordTestStepDto) {
                if (keywordTestStepDto.getKeyword() != null) {
                    RestTestStepServiceImpl.this.testCaseModificationService.updateKeywordTestStep(stepId, keywordTestStepDto.getKeyword());
                }
                if (keywordTestStepDto.getAction() != null) {
                    RestTestStepServiceImpl.this.testCaseModificationService.updateKeywordTestStep(stepId, keywordTestStepDto.getAction());
                }
                RestTestStepServiceImpl.this.keywordTestStepPatcher.patch(testStep, patch);
            }
        };
        patch.accept(visitor);
        return testStep;
    }

    @Override
    public void deleteTestStepsByIds(List<Long> stepIds) {
        for (Long stepId : stepIds) {
            TestStep testStep = this.testStepModificationService.findById(stepId.longValue());
            this.testCaseModificationService.removeStepFromTestCase(testStep.getTestCase().getId().longValue(), stepId.longValue());
        }
    }

    private TestStep createStep(TestCase testCase, TestStepDto stepDto) throws BindException {
        Integer index = stepDto.getIndex();
        TestStep testStep = TestStepDto.convertDto(stepDto);
        testStep.setTestCase(testCase);
        TestStepDtoWithWrapperVisitor visitor = new TestStepDtoWithWrapperVisitor(index, testCase, testStep);
        stepDto.accept(visitor);
        return visitor.getTestStep();
    }

    private void addOrMergeVerifiedRequirements(TestStepDto testStepDto, TestStep testStep) {
        if (testStepDto.getVerifiedRequirements() == null) {
            return;
        }
        List<Long> reqVerIds = testStepDto.getVerifiedRequirements().stream().map(RequirementVersionDto::getId).collect(Collectors.toList());
        List<Long> verifReqIds = this.requirementVersionService.findReqIdsByVersionIds(reqVerIds);
        this.verifiedRequirementsManagerService.addVerifiedRequirementsToTestStep(verifReqIds, testStep.getId().longValue());
    }

    private class TestStepDtoWithWrapperVisitor
    implements TestStepDtoVisitor {
        private Wrapped<TestStep> wrappedTestStep = new Wrapped();
        private Integer index;
        private TestCase testCase;
        private TestStep testStep;

        public TestStepDtoWithWrapperVisitor(Integer index, TestCase testCase, TestStep testStep) {
            this.index = index;
            this.testCase = testCase;
            this.testStep = testStep;
        }

        @Override
        public void visit(ActionTestStepDto actionTestStepDto) {
            List<CustomFieldValueDto> customFieldValueDtos = actionTestStepDto.getCustomFields();
            Map<Long, RawValue> customFieldRawValues = RestTestStepServiceImpl.this.customFieldValueConverter.convertCustomFieldDtoToMap(customFieldValueDtos);
            if (this.index != null) {
                this.wrappedTestStep.setValue((Object)RestTestStepServiceImpl.this.testCaseModificationService.addActionTestStep(this.testCase.getId().longValue(), (ActionTestStep)this.testStep, customFieldRawValues, this.index.intValue()));
            } else {
                this.wrappedTestStep.setValue((Object)RestTestStepServiceImpl.this.testCaseModificationService.addActionTestStep(this.testCase.getId().longValue(), (ActionTestStep)this.testStep, customFieldRawValues));
            }
            RestTestStepServiceImpl.this.addOrMergeVerifiedRequirements(actionTestStepDto, this.testStep);
        }

        @Override
        public void visit(CalledTestStepDto calledTestStepDto) {
            CallTestStep callTestStep = (CallTestStep)this.testStep;
            RestTestStepServiceImpl.this.callStepManagerService.checkForCyclicStepCallBeforePaste(this.testCase.getId(), callTestStep.getCalledTestCase().getId());
            if (this.index != null) {
                this.testCase.addStep(this.index.intValue(), (TestStep)callTestStep);
            } else {
                this.testCase.addStep((TestStep)callTestStep);
            }
            this.wrappedTestStep.setValue((Object)this.testStep);
            RestTestStepServiceImpl.this.addOrMergeVerifiedRequirements(calledTestStepDto, this.testStep);
        }

        @Override
        public void visit(KeywordTestStepDto keywordTestStepDto) {
            KeywordTestStep keywordTestStep = (KeywordTestStep)this.testStep;
            KeywordTestStep createdKeywordTestStep = this.index != null ? RestTestStepServiceImpl.this.testCaseModificationService.addKeywordTestStep(this.testCase.getId().longValue(), keywordTestStepDto.getKeyword().name(), keywordTestStepDto.getAction(), this.index.intValue()) : RestTestStepServiceImpl.this.testCaseModificationService.addKeywordTestStep(this.testCase.getId().longValue(), keywordTestStep.getKeyword().name(), keywordTestStepDto.getAction());
            RestTestStepServiceImpl.this.keywordTestStepPatcher.patch(createdKeywordTestStep, keywordTestStepDto);
            this.wrappedTestStep.setValue((Object)createdKeywordTestStep);
            RestTestStepServiceImpl.this.addOrMergeVerifiedRequirements(keywordTestStepDto, this.testStep);
        }

        public TestStep getTestStep() {
            return (TestStep)this.wrappedTestStep.getValue();
        }
    }
}

