/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.users.ApiToken;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.plugin.rest.jackson.model.ApiTokenRestDto;
import org.squashtest.tm.plugin.rest.service.RestApiTokenService;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.dto.ApiTokenDto;
import org.squashtest.tm.service.user.ApiTokenService;
import org.squashtest.tm.service.user.UserManagerService;

@Service
@Transactional
public class RestApiTokenServiceImpl
implements RestApiTokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestApiTokenServiceImpl.class);
    private final ApiTokenService apiTokenService;
    private final UserManagerService userManagerService;

    public RestApiTokenServiceImpl(ApiTokenService apiTokenService, UserManagerService userManagerService) {
        this.apiTokenService = apiTokenService;
        this.userManagerService = userManagerService;
    }

    @Override
    public void selfDestroyToken(String token) {
        this.apiTokenService.selfDestroyApiToken(token);
    }

    @Override
    public Page<ApiToken> getAllTokensByUser(Pageable pageable) {
        Long userId = this.userManagerService.findByLogin(UserContextHolder.getUsername()).getId();
        return this.apiTokenService.findAllByUserId(userId.longValue(), pageable);
    }

    @Override
    public void deletePersonalApiToken(long tokenId) {
        try {
            this.apiTokenService.deletePersonalApiToken(tokenId);
        }
        catch (NoSuchElementException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtils.entityNotFoundException(ApiToken.class, (Long)tokenId);
        }
    }

    @Override
    public ApiTokenDto addToken(ApiTokenRestDto apiTokenRestDto) {
        return this.apiTokenService.generateApiToken(apiTokenRestDto.getName(), apiTokenRestDto.getExpiryDate(), apiTokenRestDto.getPermissions());
    }
}

