/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab;

import jakarta.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.squashtest.csp.core.bugtracker.core.NamespacedBugtrackerMessageSource;
import org.squashtest.tm.api.config.SquashPathProperties;
import org.squashtest.tm.plugin.bugtracker.gitlab.GitLabConfigurablePlugin;
import org.squashtest.tm.plugin.bugtracker.gitlab.service.ConfigurationService;

@Configuration
@ComponentScan
public class GitLabBugtrackerConnectorConfig {
    private final SquashPathProperties squashPathProperties;
    private final ConfigurationService configurationService;

    public GitLabBugtrackerConnectorConfig(SquashPathProperties squashPathProperties, @Named(value="squash.tm.plugin.bugtracker.gitlab.ConfigurationService") ConfigurationService configurationService) {
        this.squashPathProperties = squashPathProperties;
        this.configurationService = configurationService;
    }

    @Bean
    @Lazy
    public MessageSource gitlabConnectorMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setCacheSeconds(60);
        messageSource.setBasenames(new String[]{"classpath:/org/squashtest/tm/plugin/bugtracker/gitlab/messages"});
        return new NamespacedBugtrackerMessageSource((MessageSource)messageSource, "bugtracker.gitlab.");
    }

    @Bean(name={"gitlab-bugtracker"})
    GitLabConfigurablePlugin gitLabConfigurablePlugin() {
        return new GitLabConfigurablePlugin(this.gitlabConnectorMessageSource(), this.configurationService);
    }
}

