/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.rest.admin.jackson.model.MilestoneDto;
import org.squashtest.tm.plugin.rest.admin.service.RestMilestoneAdminService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.MilestonePatcher;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.milestone.MilestoneFinderService;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class RestMilestoneAdminServiceImpl
implements RestMilestoneAdminService {
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private MilestonePatcher milestonePatcher;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private MilestoneManagerService milestoneManager;
    @Inject
    private MilestoneDao milestoneDao;
    @Inject
    private GenericProjectDao projectDao;
    @Inject
    private MilestoneBindingManagerService milestoneBindingManagerService;
    @Inject
    private MilestoneFinderService milestoneFinderService;

    @Override
    public Milestone addMilestone(MilestoneDto milestoneDto) {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        Milestone milestone = new Milestone();
        this.milestonePatcher.patch(milestone, milestoneDto);
        this.setRange(milestone);
        this.setPerimetre(milestone);
        this.milestoneManager.addMilestone(milestone);
        return this.milestoneDao.findByLabel(milestone.getLabel());
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Milestone> findAllMilestone(Pageable pageable) {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        return this.milestoneDao.findAll(pageable);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public GenericProject bindMilestonesToProject(Long projectId, List<Long> milestoneIds) {
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        this.milestoneBindingManagerService.bindMilestonesToProject(milestoneIds, project.getId().longValue());
        return project;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public List<Milestone> findMilestonesByProject(Long projectId) {
        return this.milestoneBindingManagerService.getAllBindedMilestoneForProject(projectId.longValue());
    }

    @Override
    public Milestone updateMilestone(Long milestoneId, MilestoneDto milestoneDto) {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        Milestone milestone = (Milestone)this.milestoneDao.getReferenceById((Object)milestoneId);
        this.milestonePatcher.patch(milestone, milestoneDto);
        return milestone;
    }

    @Override
    public void deleteMilestone(List<Long> milestoneIds) {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        this.milestoneManager.removeMilestones(milestoneIds);
    }

    @Override
    public Milestone findMilestoneById(Long milestoneId) {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        return this.milestoneFinderService.findById(milestoneId.longValue());
    }

    private void setRange(Milestone milestone) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            milestone.setRange(MilestoneRange.GLOBAL);
        } else {
            milestone.setRange(MilestoneRange.RESTRICTED);
        }
    }

    private void setPerimetre(Milestone milestone) {
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            List projects = this.projectFinder.findAllICanManage();
            milestone.addProjectsToPerimeter(projects);
        }
    }
}

