/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jooq.DSLContext;
import org.jooq.OrderField;
import org.jooq.TableLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.environmentvariable.EVBindableEntity;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableBinding;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableOption;
import org.squashtest.tm.domain.environmentvariable.SingleSelectEnvironmentVariable;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RestEnvironmentVariableDto;
import org.squashtest.tm.plugin.rest.admin.service.RestEnvironmentVariableService;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingValueService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableManagerService;
import org.squashtest.tm.service.internal.display.dto.TestAutomationServerDto;
import org.squashtest.tm.service.internal.repository.EnvironmentVariableBindingDao;
import org.squashtest.tm.service.internal.repository.EnvironmentVariableDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;
import org.squashtest.tm.service.internal.repository.display.TestAutomationServerDisplayDao;

@Service
@Transactional
public class RestEnvironmentVariableServiceImpl
implements RestEnvironmentVariableService {
    @Inject
    private EnvironmentVariableDao environmentVariableDao;
    @Inject
    private EnvironmentVariableManagerService environmentVariableManagerService;
    @Inject
    private EnvironmentVariableBindingService environmentVariableBindingService;
    @Inject
    private EnvironmentVariableBindingValueService environmentVariableBindingValueService;
    @Inject
    private GenericProjectDao projectDao;
    @Inject
    private TestAutomationServerDao serverDao;
    @Inject
    private TestAutomationServerDisplayDao serverDisplayDao;
    @Inject
    private EnvironmentVariableBindingDao environmentVariableBindingDao;
    @Inject
    private DSLContext dslContext;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvironmentVariable findById(long evId) {
        Optional evOptional = this.environmentVariableDao.findById((Object)evId);
        return (EnvironmentVariable)evOptional.orElseThrow(() -> ExceptionUtils.entityNotFoundException(EnvironmentVariable.class, (Long)evId));
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<EnvironmentVariableOption> findSingleSelectEnvironmentVariableOptionsByEVId(long evId) {
        return this.dslContext.selectFrom((TableLike)Tables.ENVIRONMENT_VARIABLE_OPTION).where(Tables.ENVIRONMENT_VARIABLE_OPTION.EV_ID.eq((Object)evId)).orderBy((OrderField)Tables.ENVIRONMENT_VARIABLE_OPTION.POSITION).fetchInto(EnvironmentVariableOption.class);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<EnvironmentVariable> findSortedEnvironmentVariable(Pageable pageable) {
        return this.environmentVariableDao.findAll(pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvironmentVariable addEnvironmentVariable(EnvironmentVariable ev) {
        this.environmentVariableManagerService.persist(ev);
        return ev;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvironmentVariable updateEnvironmentVariableName(long evId, RestEnvironmentVariableDto evDto) {
        EnvironmentVariable ev = this.findById(evId);
        if (Objects.nonNull(evDto.getName()) && !evDto.getName().equals(ev.getName())) {
            this.environmentVariableManagerService.changeName(ev.getId(), evDto.getName());
        }
        return ev;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvironmentVariable updateEnvironmentVariableOption(long evId, String optionLabel, EnvironmentVariableOption newEVOption) {
        SingleSelectEnvironmentVariable ssev = (SingleSelectEnvironmentVariable)this.findById(evId);
        Optional<EnvironmentVariableOption> option = ssev.getOptions().stream().filter(opt -> opt.getLabel().equals(optionLabel)).findFirst();
        if (option.isEmpty()) {
            throw new EntityNotFoundException(String.format("The environment variable option with label %s does not exist in environment variable with id %d", optionLabel, ssev.getId()));
        }
        if (Objects.nonNull(newEVOption.getLabel()) && !optionLabel.equals(newEVOption.getLabel())) {
            this.environmentVariableManagerService.changeOptionLabel(ssev.getId().longValue(), optionLabel, newEVOption.getLabel());
        }
        if (Objects.nonNull(newEVOption.getPosition()) && !option.get().getPosition().equals(newEVOption.getPosition())) {
            this.environmentVariableManagerService.changeOptionsPosition(ssev.getId(), newEVOption.getPosition(), Collections.singletonList(optionLabel));
        }
        return ssev;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindEnvironmentVariableToProject(Long projectId, List<Long> evIds) {
        this.verifyIfProjectExists(projectId);
        this.environmentVariableBindingService.createNewBindings(projectId, EVBindableEntity.PROJECT, evIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void unbindEnvironmentVariableToProject(Long projectId, List<Long> evIds) {
        this.verifyIfProjectExists(projectId);
        this.environmentVariableBindingService.unbind(projectId, EVBindableEntity.PROJECT, evIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void bindEnvironmentVariableToTestAutomationServer(Long testAutomationServerId, List<Long> evIds) {
        this.verifyIfTestAutomationServerExists(testAutomationServerId);
        this.environmentVariableBindingService.createNewBindings(testAutomationServerId, EVBindableEntity.TEST_AUTOMATION_SERVER, evIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public TestAutomationServerDto getTestAutomationServerById(Long testAutomationServerId) {
        return this.serverDisplayDao.getTestAutomationServerById(testAutomationServerId.longValue());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void unbindEnvironmentVariableToTestAutomationServer(Long testAutomationServerId, List<Long> evIds) {
        this.verifyIfTestAutomationServerExists(testAutomationServerId);
        this.environmentVariableBindingService.unbind(testAutomationServerId, EVBindableEntity.TEST_AUTOMATION_SERVER, evIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public EnvironmentVariableBinding setDefaultValueOfAnEnvironmentVariableToProject(Long projectId, Long evId, String value) {
        this.verifyIfProjectExists(projectId);
        EnvironmentVariableBinding binding = this.environmentVariableBindingDao.findByEntityIdTypeAndEvId(projectId, EVBindableEntity.PROJECT, evId);
        this.verifyIfBindingExists(binding.getId());
        this.environmentVariableBindingValueService.editEnvironmentVariableValue(binding.getId(), value);
        return binding;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvironmentVariableBinding setDefaultValueOfAnEnvironmentVariableToTestAutomationServer(Long testAutomationServerId, Long evId, String value) {
        this.verifyIfTestAutomationServerExists(testAutomationServerId);
        EnvironmentVariableBinding binding = this.environmentVariableBindingDao.findByEntityIdTypeAndEvId(testAutomationServerId, EVBindableEntity.TEST_AUTOMATION_SERVER, evId);
        this.verifyIfBindingExists(binding.getId());
        this.environmentVariableBindingValueService.editEnvironmentVariableValue(binding.getId(), value);
        return binding;
    }

    private void verifyIfProjectExists(Long projectId) {
        if (this.projectDao.findById((Object)projectId).isEmpty()) {
            throw ExceptionUtils.entityNotFoundException(GenericProject.class, (Long)projectId);
        }
    }

    private void verifyIfTestAutomationServerExists(Long testAutomationServerId) {
        if (this.serverDao.findById((Object)testAutomationServerId).isEmpty()) {
            throw ExceptionUtils.entityNotFoundException(TestAutomationServer.class, (Long)testAutomationServerId);
        }
    }

    private void verifyIfBindingExists(Long bindingId) {
        if (this.environmentVariableBindingDao.findById((Object)bindingId).isEmpty()) {
            throw ExceptionUtils.entityNotFoundException(EnvironmentVariableBinding.class, (Long)bindingId);
        }
    }
}

