/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.patcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import org.squashtest.tm.plugin.rest.service.impl.PatchableAttributes;

public abstract class AbstractPatcher {
    public void patch(Object entity, Object dto) {
        Class<?> entityClass = entity.getClass();
        Class<?> dtoClass = dto.getClass();
        for (PatchableAttributes patchableAttributes : this.getPatchableAttributes()) {
            try {
                Method getter = dtoClass.getMethod(patchableAttributes.getGetterName(), new Class[0]);
                Method setter = entityClass.getMethod(patchableAttributes.getSetterName(), patchableAttributes.getPropertyClass());
                Object value = getter.invoke(dto, new Object[0]);
                if (value == null) continue;
                setter.invoke(entity, value);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    abstract EnumSet<? extends PatchableAttributes> getPatchableAttributes();
}

