/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.importer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.squashtest.tm.plugin.jirasync.domain.ImportStatus;

public class ImporterState {
    private Set<String> processedReqs = new HashSet<String>();
    private Set<String> untouchableReqs = new HashSet<String>();
    private SetMultimap<String, String> epicLinkMap = HashMultimap.create();
    private boolean hadFailureOnFilterFetch = false;
    private boolean hadFailureOnFieldImport = false;
    private boolean hasAllFetchFailed = true;

    public Set<String> getProcessedReqs() {
        return this.processedReqs;
    }

    public boolean hasProcessedAlready(String key) {
        return this.processedReqs.contains(key);
    }

    public void addProcessedReqs(Collection<String> newProcessed) {
        this.processedReqs.addAll(newProcessed);
        this.untouchableReqs.removeAll(newProcessed);
    }

    public Set<String> getUntouchableReqs() {
        return this.untouchableReqs;
    }

    public void addUntouchableReqs(Collection<String> untouchables) {
        this.untouchableReqs.addAll(untouchables);
        this.untouchableReqs.removeAll(this.processedReqs);
    }

    public Set<String> getNonDeletableReqs() {
        HashSet<String> nonDeletable = new HashSet<String>();
        nonDeletable.addAll(this.processedReqs);
        nonDeletable.addAll(this.untouchableReqs);
        return nonDeletable;
    }

    public SetMultimap<String, String> getEpicLinkMap() {
        return this.epicLinkMap;
    }

    public void addEpicRelationship(String usKey, String epicKey) {
        this.epicLinkMap.put((Object)epicKey, (Object)usKey);
    }

    public boolean isHadFailureOnFilterFetch() {
        return this.hadFailureOnFilterFetch;
    }

    public void setHadFailureOnFilterFetch(boolean hadFailureOnFilterFetch) {
        this.hadFailureOnFilterFetch = hadFailureOnFilterFetch;
    }

    public boolean isHadFailureOnFieldImport() {
        return this.hadFailureOnFieldImport;
    }

    public void setHadFailureOnFieldImport(boolean hadFailureOnFieldImport) {
        this.hadFailureOnFieldImport = hadFailureOnFieldImport;
    }

    public boolean isHasAllFetchFailed() {
        return this.hasAllFetchFailed;
    }

    public void setHasAllFetchFailed(boolean hasAllFetchFailed) {
        this.hasAllFetchFailed = hasAllFetchFailed;
    }

    public ImportStatus toImportStatus() {
        return new ImportStatus(this.hadFailureOnFilterFetch, this.hadFailureOnFieldImport, this.hasAllFetchFailed);
    }
}

