/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.async;

import java.net.URI;
import jirasync.com.atlassian.httpclient.api.HttpClient;
import jirasync.com.atlassian.jira.rest.client.api.MetadataRestClient;
import jirasync.com.atlassian.jira.rest.client.api.domain.Field;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueType;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssuelinksType;
import jirasync.com.atlassian.jira.rest.client.api.domain.Priority;
import jirasync.com.atlassian.jira.rest.client.api.domain.Resolution;
import jirasync.com.atlassian.jira.rest.client.api.domain.ServerInfo;
import jirasync.com.atlassian.jira.rest.client.api.domain.Status;
import jirasync.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jirasync.com.atlassian.jira.rest.client.internal.json.FieldJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.IssueLinkTypesJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonArrayParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.PriorityJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.ResolutionJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.ServerInfoJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.StatusJsonParser;
import jirasync.com.sun.ws.rs.core.UriBuilder;
import jirasync.io.atlassian.util.concurrent.Promise;

public class AsynchronousMetadataRestClient
extends AbstractAsynchronousRestClient
implements MetadataRestClient {
    private static final String SERVER_INFO_RESOURCE = "/serverInfo";
    private final ServerInfoJsonParser serverInfoJsonParser = new ServerInfoJsonParser();
    private final IssueTypeJsonParser issueTypeJsonParser = new IssueTypeJsonParser();
    private final GenericJsonArrayParser<IssueType> issueTypesJsonParser = GenericJsonArrayParser.create(this.issueTypeJsonParser);
    private final StatusJsonParser statusJsonParser = new StatusJsonParser();
    private final GenericJsonArrayParser<Status> statusesJsonParser = GenericJsonArrayParser.create(this.statusJsonParser);
    private final PriorityJsonParser priorityJsonParser = new PriorityJsonParser();
    private final GenericJsonArrayParser<Priority> prioritiesJsonParser = GenericJsonArrayParser.create(this.priorityJsonParser);
    private final ResolutionJsonParser resolutionJsonParser = new ResolutionJsonParser();
    private final GenericJsonArrayParser<Resolution> resolutionsJsonParser = GenericJsonArrayParser.create(this.resolutionJsonParser);
    private final IssueLinkTypesJsonParser issueLinkTypesJsonParser = new IssueLinkTypesJsonParser();
    private final JsonArrayParser<Iterable<Field>> fieldsJsonParser = FieldJsonParser.createFieldsArrayParser();
    private final URI baseUri;

    public AsynchronousMetadataRestClient(URI baseUri, HttpClient httpClient) {
        super(httpClient);
        this.baseUri = baseUri;
    }

    @Override
    public Promise<IssueType> getIssueType(URI uri) {
        return this.getAndParse(uri, this.issueTypeJsonParser);
    }

    @Override
    public Promise<Iterable<IssueType>> getIssueTypes() {
        URI uri = UriBuilder.fromUri(this.baseUri).path("issuetype").build(new Object[0]);
        return this.getAndParse(uri, this.issueTypesJsonParser);
    }

    @Override
    public Promise<Iterable<IssuelinksType>> getIssueLinkTypes() {
        URI uri = UriBuilder.fromUri(this.baseUri).path("issueLinkType").build(new Object[0]);
        return this.getAndParse(uri, this.issueLinkTypesJsonParser);
    }

    @Override
    public Promise<Status> getStatus(URI uri) {
        return this.getAndParse(uri, this.statusJsonParser);
    }

    @Override
    public Promise<Iterable<Status>> getStatuses() {
        URI uri = UriBuilder.fromUri(this.baseUri).path("status").build(new Object[0]);
        return this.getAndParse(uri, this.statusesJsonParser);
    }

    @Override
    public Promise<Priority> getPriority(URI uri) {
        return this.getAndParse(uri, this.priorityJsonParser);
    }

    @Override
    public Promise<Iterable<Priority>> getPriorities() {
        URI uri = UriBuilder.fromUri(this.baseUri).path("priority").build(new Object[0]);
        return this.getAndParse(uri, this.prioritiesJsonParser);
    }

    @Override
    public Promise<Resolution> getResolution(URI uri) {
        return this.getAndParse(uri, this.resolutionJsonParser);
    }

    @Override
    public Promise<Iterable<Resolution>> getResolutions() {
        URI uri = UriBuilder.fromUri(this.baseUri).path("resolution").build(new Object[0]);
        return this.getAndParse(uri, this.resolutionsJsonParser);
    }

    @Override
    public Promise<ServerInfo> getServerInfo() {
        URI serverInfoUri = UriBuilder.fromUri(this.baseUri).path(SERVER_INFO_RESOURCE).build(new Object[0]);
        return this.getAndParse(serverInfoUri, this.serverInfoJsonParser);
    }

    @Override
    public Promise<Iterable<Field>> getFields() {
        URI uri = UriBuilder.fromUri(this.baseUri).path("field").build(new Object[0]);
        return this.getAndParse(uri, this.fieldsJsonParser);
    }
}

