/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.domain;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.squashtest.tm.plugin.redminereq.exceptions.EmptyFilterBindingFilterException;
import org.squashtest.tm.plugin.redminereq.exceptions.InvalidFilterBindingKeyException;
import org.squashtest.tm.plugin.redminereq.exceptions.NonIntegerFilterBindingFilterException;
import org.squashtest.tm.plugin.redminereq.exceptions.PathValidationDomainException;

public class FilterBinding {
    public static final String FORBIDDEN_KEY_CHARACTERS = "+";
    private String key;
    private String filter;
    private String path;

    public FilterBinding() {
    }

    public FilterBinding(String key, String filter, String path) {
        this.setKey(key);
        this.setFilter(filter);
        this.setPath(path);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            throw new EmptyFilterBindingFilterException();
        }
        boolean containsForbiddenCharacters = FORBIDDEN_KEY_CHARACTERS.codePoints().mapToObj(c -> String.valueOf((char)c)).anyMatch(key::contains);
        if (containsForbiddenCharacters) {
            throw new InvalidFilterBindingKeyException();
        }
        this.key = key;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        if (filter == null || StringUtils.isBlank((String)filter)) {
            throw new EmptyFilterBindingFilterException();
        }
        if (!StringUtils.isNumeric((String)filter)) {
            throw new NonIntegerFilterBindingFilterException();
        }
        this.filter = filter;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path == null) {
            this.path = null;
        } else {
            String trimmed = StringUtils.trim((String)path);
            if (!this.isPathValid(trimmed)) {
                throw new PathValidationDomainException();
            }
            this.path = trimmed;
        }
    }

    public String toString() {
        return "{ " + this.getId() + " : " + this.path + " }";
    }

    public String getId() {
        return this.key + FORBIDDEN_KEY_CHARACTERS + this.filter;
    }

    public static FilterBinding byId(String id) {
        int plusidx = id.indexOf(FORBIDDEN_KEY_CHARACTERS);
        String projname = id.substring(0, plusidx);
        String filtername = id.substring(plusidx + 1);
        return new FilterBinding(projname, filtername, null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterBinding other = (FilterBinding)obj;
        if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    private boolean isPathValid(String path) {
        if (path.length() == 0) {
            return true;
        }
        char first = path.charAt(0);
        char last = path.charAt(path.length() - 1);
        if (first == '/' || last == '/') {
            return false;
        }
        boolean hasEmptyPart = Arrays.stream(path.split("/")).anyMatch(part -> part.length() == 0);
        return !hasEmptyPart;
    }
}

