/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client;

import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevOpsClient;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevOpsClientImpl;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevopsCredentialHolder;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.utils.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.utils.RestTemplateFactory;

@Component
public class AzureDevOpsClientFactory {
    private final RestTemplateFactory restTemplateFactory;
    private final ExceptionHandler exceptionHandler;
    private final AzureDevopsCredentialHolder azureDevopsCredentialHolder = new AzureDevopsCredentialHolder();

    public AzureDevOpsClientFactory(RestTemplateFactory restTemplateFactory, ExceptionHandler exceptionHandler) {
        this.restTemplateFactory = restTemplateFactory;
        this.exceptionHandler = exceptionHandler;
    }

    public AzureDevOpsClient createClient() {
        return new AzureDevOpsClientImpl(this.restTemplateFactory, this.exceptionHandler);
    }

    public AzureDevOpsClient createAndInitClientAndCredentials(BugTracker bugtracker, Credentials credentials) {
        AzureDevOpsClientImpl azureDevOpsClient = new AzureDevOpsClientImpl(this.restTemplateFactory, this.exceptionHandler);
        azureDevOpsClient.init(bugtracker, credentials);
        this.azureDevopsCredentialHolder.set(credentials);
        return azureDevOpsClient;
    }

    public AzureDevOpsClient createAndInitClientWithRegisteredCredentials(BugTracker bugtracker) {
        AzureDevOpsClientImpl azureDevOpsClient = new AzureDevOpsClientImpl(this.restTemplateFactory, this.exceptionHandler);
        azureDevOpsClient.init(bugtracker, (Credentials)this.azureDevopsCredentialHolder.get());
        return azureDevOpsClient;
    }
}

