/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo.api.internal;

import java.io.Serializable;
import java.util.Set;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Absent;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Action;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Function;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Present;
import xsquash4gitlab.com.apollographql.apollo.api.internal.Utils;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> Optional<T> absent() {
        return Absent.withType();
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Utils.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(@Nullable T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    @Nullable
    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract <V> Optional<V> transform(Function<? super T, V> var1);

    public abstract <V> Optional<V> map(Function<? super T, V> var1);

    public abstract <V> Optional<V> flatMap(Function<? super T, Optional<V>> var1);

    public abstract Optional<T> apply(Action<T> var1);

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

